/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.xades.v132;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class UnsignedXadesParser {
    public static String NAMESPACE = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String XADES_V132_XSD_SCHEMA_RESOURCE_LOCATION = "/XAdESv132.xsd";
    private JAXBContext jaxbContext = null;
    private Schema schema = null;

    public Object parseUnsignedMessage(byte[] message) throws MessageContentException, MessageProcessingException {
        try {
            Object object = this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(message));
            if (object instanceof JAXBElement) {
                return ((JAXBElement)object).getValue();
            }
            return object;
        }
        catch (SAXException e) {
            throw new MessageContentException("Error occurred during SAML unmarshaller: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error occurred during SAML unmarshaller: " + e.getMessage(), e);
        }
    }

    public byte[] marshallUnsignedMessage(Object object) throws MessageContentException, MessageProcessingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMarshaller().marshal(object, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error occurred marshalling object: " + e.getMessage(), e);
        }
    }

    protected Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setSchema(this.getSchema());
        return unmarshaller;
    }

    protected JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)"org.certificateservices.messages.xades.v132.jaxb:org.certificateservices.messages.xmldsig.jaxb");
        }
        return this.jaxbContext;
    }

    private Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = this.generateSchema();
        }
        return this.schema;
    }

    private Schema generateSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new UnsignedXadesParserLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(XADES_V132_XSD_SCHEMA_RESOURCE_LOCATION))};
        return schemaFactory.newSchema(sources);
    }

    public class UnsignedXadesParserLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xmldsig-core-schema.xsd"));
                    }
                    if (namespaceURI.equals(NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(UnsignedXadesParser.XADES_V132_XSD_SCHEMA_RESOURCE_LOCATION));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

