/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.EncryptionAlgorithmScheme;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.SigningAlgorithmScheme;
import org.certificateservices.messages.TruststoreHelper;
import org.certificateservices.messages.utils.SettingsUtils;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.utils.XMLSigner;

public class SimpleMessageSecurityProvider
implements ContextMessageSecurityProvider {
    public static final String SETTING_PREFIX = "simplesecurityprovider";
    public static final String SETTING_SIGNINGKEYSTORE_PATH = "simplesecurityprovider.signingkeystore.path";
    public static final String SETTING_SIGNINGKEYSTORE_PASSWORD = "simplesecurityprovider.signingkeystore.password";
    public static final String SETTING_SIGNINGKEYSTORE_ALIAS = "simplesecurityprovider.signingkeystore.alias";
    public static final String SETTING_DECRYPTKEYSTORE_PATH = "simplesecurityprovider.decryptkeystore.path";
    public static final String SETTING_DECRYPTKEYSTORE_PASSWORD = "simplesecurityprovider.decryptkeystore.password";
    public static final String SETTING_DECRYPTKEYSTORE_DEFAULTKEY_ALIAS = "simplesecurityprovider.decryptkeystore.defaultkey.alias";
    public static final String SETTING_TRUSTKEYSTORE_PATH = "simplesecurityprovider.trustkeystore.path";
    public static final String SETTING_TRUSTKEYSTORE_PASSWORD = "simplesecurityprovider.trustkeystore.password";
    public static final String SETTING_SIGNATURE_ALGORITHM_SCHEME = "simplesecurityprovider.signature.algorithm";
    public static final SigningAlgorithmScheme DEFAULT_SIGNATURE_ALGORITHM_SCHEME = SigningAlgorithmScheme.RSAWithSHA256;
    public static final String SETTING_ENCRYPTION_ALGORITHM_SCHEME = "simplesecurityprovider.encryption.algorithm";
    public static final EncryptionAlgorithmScheme DEFAULT_ENCRYPTION_ALGORITHM_SCHEME = EncryptionAlgorithmScheme.RSA_OAEP_WITH_AES256;
    PrivateKey signPrivateKey = null;
    X509Certificate signCertificate = null;
    Map<String, PrivateKey> decryptionKeys = new HashMap<String, PrivateKey>();
    Map<String, X509Certificate[]> decryptionCertificates = new HashMap<String, X509Certificate[]>();
    String defaultDecryptionKeyId = null;
    private SigningAlgorithmScheme signingAlgorithmScheme;
    private EncryptionAlgorithmScheme encryptionAlgorithmScheme;
    protected TruststoreHelper truststoreHelper;

    public SimpleMessageSecurityProvider(Properties config) throws MessageProcessingException {
        this(config, SimpleMessageSecurityProvider.getKeyStore(config, SETTING_TRUSTKEYSTORE_PATH, SETTING_TRUSTKEYSTORE_PASSWORD));
    }

    public SimpleMessageSecurityProvider(Properties config, KeyStore trustStore) throws MessageProcessingException {
        String signKeystorePath = SettingsUtils.getRequiredProperty(config, SETTING_SIGNINGKEYSTORE_PATH);
        String signKeystoreAlias = SettingsUtils.getRequiredProperty(config, SETTING_SIGNINGKEYSTORE_ALIAS);
        try {
            String signKeystorePassword = SettingsUtils.getRequiredProperty(config, SETTING_SIGNINGKEYSTORE_PASSWORD);
            KeyStore signKeystore = this.getSigningKeyStore(config);
            this.signCertificate = (X509Certificate)signKeystore.getCertificate(signKeystoreAlias);
            this.signPrivateKey = (PrivateKey)signKeystore.getKey(signKeystoreAlias, signKeystorePassword.toCharArray());
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error loading signing keystore: " + e.getMessage(), e);
        }
        if (this.signCertificate == null || this.signPrivateKey == null) {
            throw new MessageProcessingException("Error finding signing certificate and key for alias : " + signKeystoreAlias + ", in key store: " + signKeystorePath);
        }
        String decKeystorePath = SettingsUtils.getRequiredProperty(config, SETTING_DECRYPTKEYSTORE_PATH, SETTING_SIGNINGKEYSTORE_PATH);
        KeyStore decKS = this.getDecryptionKeyStore(config);
        String defaultDecryptionAlias = this.getDefaultDecryptionAlias(config);
        char[] decKeyStorePassword = this.getDecryptionKeyStorePassword(config);
        try {
            Enumeration<String> aliases = decKS.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Key key = decKS.getKey(alias, decKeyStorePassword);
                Certificate[] certChain = decKS.getCertificateChain(alias);
                if (key == null || !(key instanceof PrivateKey) || certChain == null || certChain.length <= 0) continue;
                X509Certificate[] x509CertChain = (X509Certificate[])Arrays.copyOf(certChain, certChain.length, X509Certificate[].class);
                String keyId = XMLEncrypter.generateKeyId(x509CertChain[0].getPublicKey());
                this.decryptionKeys.put(keyId, (PrivateKey)key);
                this.decryptionCertificates.put(keyId, x509CertChain);
            }
            Certificate defaultDecryptCert = decKS.getCertificate(defaultDecryptionAlias);
            if (defaultDecryptCert != null) {
                this.defaultDecryptionKeyId = XMLEncrypter.generateKeyId(defaultDecryptCert.getPublicKey());
            }
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error reading decryption keys and certificates from keystore: " + e.getMessage(), e);
        }
        if (this.decryptionKeys.size() == 0) {
            throw new MessageProcessingException("Error no decryption keys found in decryption keystore: " + decKeystorePath);
        }
        if (this.decryptionKeys.get(this.defaultDecryptionKeyId) == null) {
            throw new MessageProcessingException("Error no default decryption key with id (alias) :" + defaultDecryptionAlias + " found in decryption keystore: " + decKeystorePath);
        }
        this.signingAlgorithmScheme = SigningAlgorithmScheme.getByName(config.getProperty(SETTING_SIGNATURE_ALGORITHM_SCHEME));
        if (this.signingAlgorithmScheme == null) {
            this.signingAlgorithmScheme = DEFAULT_SIGNATURE_ALGORITHM_SCHEME;
        }
        this.encryptionAlgorithmScheme = EncryptionAlgorithmScheme.getByName(config.getProperty(SETTING_ENCRYPTION_ALGORITHM_SCHEME));
        if (this.encryptionAlgorithmScheme == null) {
            this.encryptionAlgorithmScheme = DEFAULT_ENCRYPTION_ALGORITHM_SCHEME;
        }
        this.truststoreHelper = new TruststoreHelper(config, trustStore, SETTING_PREFIX);
    }

    @Override
    public PrivateKey getSigningKey() throws MessageProcessingException {
        return this.getSigningKey(DEFAULT_CONTEXT);
    }

    @Override
    public PrivateKey getSigningKey(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.signPrivateKey;
    }

    @Override
    public X509Certificate getSigningCertificate() throws MessageProcessingException {
        return this.getSigningCertificate(DEFAULT_CONTEXT);
    }

    @Override
    public X509Certificate getSigningCertificate(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.signCertificate;
    }

    @Override
    public boolean isValidAndAuthorized(X509Certificate signCertificate, String organisation) throws IllegalArgumentException, MessageProcessingException {
        return this.isValidAndAuthorized(DEFAULT_CONTEXT, signCertificate, organisation);
    }

    @Override
    public boolean isValidAndAuthorized(ContextMessageSecurityProvider.Context context, X509Certificate signCertificate, String organisation) throws IllegalArgumentException, MessageProcessingException {
        if (!XMLSigner.checkBasicCertificateValidation(signCertificate)) {
            return false;
        }
        return this.truststoreHelper.isTrusted(context, signCertificate);
    }

    @Override
    public PrivateKey getDecryptionKey(String keyId) throws MessageProcessingException {
        return this.getDecryptionKey(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public PrivateKey getDecryptionKey(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        return this.decryptionKeys.get(keyId == null ? this.defaultDecryptionKeyId : keyId);
    }

    @Override
    public X509Certificate getDecryptionCertificate(String keyId) throws MessageProcessingException {
        return this.getDecryptionCertificate(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public X509Certificate getDecryptionCertificate(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        return this.decryptionCertificates.get(keyId == null ? this.defaultDecryptionKeyId : keyId)[0];
    }

    @Override
    public X509Certificate[] getDecryptionCertificateChain(String keyId) throws MessageProcessingException {
        return this.getDecryptionCertificateChain(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public X509Certificate[] getDecryptionCertificateChain(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        return this.decryptionCertificates.get(keyId == null ? this.defaultDecryptionKeyId : keyId);
    }

    @Override
    public Set<String> getDecryptionKeyIds() throws MessageProcessingException {
        return this.getDecryptionKeyIds(DEFAULT_CONTEXT);
    }

    @Override
    public Set<String> getDecryptionKeyIds(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.decryptionKeys.keySet();
    }

    @Override
    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme() throws MessageProcessingException {
        return this.getEncryptionAlgorithmScheme(DEFAULT_CONTEXT);
    }

    @Override
    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.encryptionAlgorithmScheme;
    }

    @Override
    public SigningAlgorithmScheme getSigningAlgorithmScheme() throws MessageProcessingException {
        return this.getSigningAlgorithmScheme(DEFAULT_CONTEXT);
    }

    @Override
    public String getProvider() {
        return "BC";
    }

    @Override
    public SigningAlgorithmScheme getSigningAlgorithmScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.signingAlgorithmScheme;
    }

    @Override
    public String getProvider(ContextMessageSecurityProvider.Context context) {
        return this.getProvider();
    }

    protected KeyStore getSigningKeyStore(Properties config) throws MessageProcessingException {
        return SimpleMessageSecurityProvider.getKeyStore(config, SETTING_SIGNINGKEYSTORE_PATH, SETTING_SIGNINGKEYSTORE_PASSWORD);
    }

    protected KeyStore getDecryptionKeyStore(Properties config) throws MessageProcessingException {
        String encryptPath = config.getProperty(SETTING_DECRYPTKEYSTORE_PATH);
        if (encryptPath == null || encryptPath.trim().equals("")) {
            return this.getSigningKeyStore(config);
        }
        return SimpleMessageSecurityProvider.getKeyStore(config, SETTING_DECRYPTKEYSTORE_PATH, SETTING_DECRYPTKEYSTORE_PASSWORD);
    }

    protected char[] getDecryptionKeyStorePassword(Properties config) throws MessageProcessingException {
        String encryptPath = config.getProperty(SETTING_DECRYPTKEYSTORE_PATH);
        if (encryptPath == null || encryptPath.trim().equals("")) {
            return SettingsUtils.getRequiredProperty(config, SETTING_SIGNINGKEYSTORE_PASSWORD).toCharArray();
        }
        return SettingsUtils.getRequiredProperty(config, SETTING_DECRYPTKEYSTORE_PASSWORD).toCharArray();
    }

    protected String getDefaultDecryptionAlias(Properties config) throws MessageProcessingException {
        return SettingsUtils.getRequiredProperty(config, SETTING_DECRYPTKEYSTORE_DEFAULTKEY_ALIAS, SETTING_SIGNINGKEYSTORE_ALIAS);
    }

    public static KeyStore getKeyStore(Properties config, String pathSetting, String passwordSetting) throws MessageProcessingException {
        String keyStorePath = SettingsUtils.getRequiredProperty(config, pathSetting);
        InputStream keyStoreInputStream = SimpleMessageSecurityProvider.class.getClassLoader().getResourceAsStream(keyStorePath);
        if (keyStoreInputStream == null) {
            File keyStoreFile = new File(keyStorePath);
            if (!(keyStoreFile.canRead() && keyStoreFile.exists() && keyStoreFile.isFile())) {
                throw new MessageProcessingException("Error reading keystore: " + keyStorePath + ", make sure it exists and is readable");
            }
            try {
                keyStoreInputStream = new FileInputStream(keyStoreFile);
            }
            catch (FileNotFoundException e) {
                throw new MessageProcessingException("Error keystore file: " + keyStoreFile + " not found.");
            }
        }
        String keystorePassword = SettingsUtils.getRequiredProperty(config, passwordSetting);
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreInputStream, keystorePassword.toCharArray());
            return keyStore;
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error reading keystore " + keyStorePath + ", make sure it is a JKS file and password is correct.");
        }
    }
}

