/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.PKCS11MessageSecurityProvider;
import org.certificateservices.messages.utils.CertUtils;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.SettingsUtils;
import org.certificateservices.messages.utils.SubjectDNMatcher;
import org.certificateservices.messages.utils.SystemTime;

public class TruststoreHelper {
    Logger log = Logger.getLogger(TruststoreHelper.class.getName());
    protected SystemTime systemTime = new DefaultSystemTime();
    public static String TRUSTKEYSTORE_TYPE_ENDENTITY = "ENDENTITY";
    public static String TRUSTKEYSTORE_TYPE_CA = "CA";
    public static final String SETTING_TRUSTKEYSTORE_TYPE = ".trustkeystore.type";
    public static final String DEFAULT_TRUSTKEYSTORE_TYPE = TRUSTKEYSTORE_TYPE_ENDENTITY;
    public static final String SETTING_TRUSTKEYSTORE_PATH = ".trustkeystore.path";
    public static final String SETTING_TRUSTKEYSTORE_PASSWORD = ".trustkeystore.password";
    public static final String SETTING_TRUSTKEYSTORE_MATCHSUBJECT = ".trustkeystore.matchsubject";
    public static final String DEFAULT_TRUSTKEYSTORE_MATCHSUBJECT = "true";
    public static final String SETTING_TRUSTKEYSTORE_MATCHDNFIELD = ".trustkeystore.matchdnfield";
    public static final String SETTING_TRUSTKEYSTORE_MATCHDNVALUE = ".trustkeystore.matchdnvalue";
    private KeyStore trustStore;
    private final String trustStoreType;
    private boolean trustStoreMatchSubject;
    private String trustStoreMatchFieldName;
    private ASN1ObjectIdentifier trustStoreMatchField;
    private String trustStoreMatchValue;

    public TruststoreHelper(Properties config, KeyStore trustStore, String settingPrefix) throws MessageProcessingException {
        this.trustStore = trustStore;
        this.trustStoreType = this.getTrustStoreType(config, settingPrefix);
        if (this.trustStoreType.equals(TRUSTKEYSTORE_TYPE_CA)) {
            this.trustStoreMatchSubject = this.useSubjectMatch(config, settingPrefix);
            if (this.trustStoreMatchSubject) {
                this.trustStoreMatchFieldName = SettingsUtils.getRequiredProperty(config, settingPrefix + SETTING_TRUSTKEYSTORE_MATCHDNFIELD).trim().toUpperCase();
                this.trustStoreMatchField = this.getMatchSubjectField(this.trustStoreMatchFieldName, settingPrefix);
                this.trustStoreMatchValue = this.getMatchSubjectValue(config, settingPrefix);
            }
        }
    }

    public boolean isTrusted(ContextMessageSecurityProvider.Context context, X509Certificate signCertificate) throws IllegalArgumentException, MessageProcessingException {
        if (this.trustStoreType.equals(TRUSTKEYSTORE_TYPE_ENDENTITY)) {
            return this.checkCertificateMatchFromTruststore(signCertificate);
        }
        return this.validateCertificateChain(signCertificate) && this.matchCertificateField(signCertificate);
    }

    protected String getTrustStoreType(Properties config, String settingPrefix) throws MessageProcessingException {
        String type = config.getProperty(settingPrefix + SETTING_TRUSTKEYSTORE_TYPE, DEFAULT_TRUSTKEYSTORE_TYPE).trim().toUpperCase();
        if (type.equals(TRUSTKEYSTORE_TYPE_CA) || type.equals(TRUSTKEYSTORE_TYPE_ENDENTITY)) {
            return type;
        }
        throw new MessageProcessingException("Invalid setting for simple message security provider, setting " + settingPrefix + SETTING_TRUSTKEYSTORE_TYPE + " should have a value of either " + TRUSTKEYSTORE_TYPE_CA + " or " + TRUSTKEYSTORE_TYPE_ENDENTITY + " not: " + type);
    }

    protected boolean useSubjectMatch(Properties config, String settingPrefix) throws MessageProcessingException {
        String val = config.getProperty(settingPrefix + SETTING_TRUSTKEYSTORE_MATCHSUBJECT, DEFAULT_TRUSTKEYSTORE_MATCHSUBJECT).trim().toLowerCase();
        if (val.equals(DEFAULT_TRUSTKEYSTORE_MATCHSUBJECT) || val.equals("false")) {
            return Boolean.parseBoolean(val);
        }
        throw new MessageProcessingException("Invalid setting for simple message security provider, setting " + settingPrefix + SETTING_TRUSTKEYSTORE_MATCHSUBJECT + " should have a value of either true or false not: " + val);
    }

    protected ASN1ObjectIdentifier getMatchSubjectField(String trustStoreMatchFieldName, String settingPrefix) throws MessageProcessingException {
        try {
            return new SubjectDNMatcher.AvailableDNFields().getIdentifier(trustStoreMatchFieldName);
        }
        catch (IllegalArgumentException e) {
            throw new MessageProcessingException("Invalid DN field " + trustStoreMatchFieldName + " configured in setting " + settingPrefix + SETTING_TRUSTKEYSTORE_MATCHDNFIELD + ".");
        }
    }

    protected String getMatchSubjectValue(Properties config, String settingPrefix) throws MessageProcessingException {
        return SettingsUtils.getRequiredProperty(config, settingPrefix + SETTING_TRUSTKEYSTORE_MATCHDNVALUE).trim();
    }

    protected boolean validateCertificateChain(X509Certificate certificate) {
        try {
            CertPath path = CertUtils.getCertificateFactory().generateCertPath(Collections.singletonList(certificate));
            CertPathValidator validator = CertPathValidator.getInstance("PKIX", "BC");
            PKIXParameters params = new PKIXParameters(this.trustStore);
            params.setDate(this.systemTime.getSystemTime());
            params.setRevocationEnabled(false);
            params.setCertPathCheckers(Collections.singletonList(new ExtendedKeyUsageChecker()));
            validator.validate(path, params);
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error validating certificate chain of CSMessage signing certificate: " + e.getMessage(), e);
            return false;
        }
    }

    protected boolean matchCertificateField(X509Certificate certificate) {
        if (this.trustStoreMatchSubject) {
            List<String> fieldValues = CertUtils.getSubjectDNFields(CertUtils.getSubject(certificate), this.trustStoreMatchField);
            boolean result = fieldValues.contains(this.trustStoreMatchValue);
            if (!result) {
                this.log.severe("Error validating certificate " + certificate.getSubjectDN().toString() + ", does not match configured truststore value of " + this.trustStoreMatchFieldName + " = " + this.trustStoreMatchValue);
            }
            return result;
        }
        return true;
    }

    protected boolean checkCertificateMatchFromTruststore(X509Certificate certificate) throws MessageProcessingException {
        boolean foundMatching = false;
        try {
            Enumeration<String> aliases = this.trustStore.aliases();
            while (aliases.hasMoreElements()) {
                if (!PKCS11MessageSecurityProvider.isEqual(certificate, (X509Certificate)this.trustStore.getCertificate(aliases.nextElement()))) continue;
                foundMatching = true;
                break;
            }
        }
        catch (CertificateEncodingException e) {
            throw new MessageProcessingException("Error reading certificates from truststore: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            throw new MessageProcessingException("Error reading certificates from truststore: " + e.getMessage());
        }
        return foundMatching;
    }

    public static class ExtendedKeyUsageChecker
    extends PKIXCertPathChecker {
        private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";

        @Override
        public void init(boolean forward) throws CertPathValidatorException {
        }

        @Override
        public boolean isForwardCheckingSupported() {
            return true;
        }

        @Override
        public Set<String> getSupportedExtensions() {
            return Collections.singleton(OID_EXTENDED_KEY_USAGE);
        }

        @Override
        public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
            unresolvedCritExts.remove(OID_EXTENDED_KEY_USAGE);
        }
    }
}

