/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.assertion;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.AssertionData;
import org.certificateservices.messages.assertion.AssertionPayloadParser;
import org.certificateservices.messages.csmessages.jaxb.Approver;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeStatementType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeType;
import org.certificateservices.messages.saml2.assertion.jaxb.StatementAbstractType;

public class ApprovalAssertionData
extends AssertionData {
    private String approvalId;
    private List<String> approvalRequests;
    private String destinationId;
    private List<Approver> approvers;

    public ApprovalAssertionData(AssertionPayloadParser assertionPayloadParser) {
        super(assertionPayloadParser);
    }

    @Override
    public void parse(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        this.parseCommonData(assertion);
        try {
            for (StatementAbstractType nextStatement : ((AssertionType)assertion.getValue()).getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(nextStatement instanceof AttributeStatementType)) continue;
                for (Object attr : ((AttributeStatementType)nextStatement).getAttributeOrEncryptedAttribute()) {
                    if (!(attr instanceof AttributeType)) continue;
                    if (((AttributeType)attr).getName().equals("ApprovalId")) {
                        this.approvalId = (String)((AttributeType)attr).getAttributeValue().get(0);
                    }
                    if (((AttributeType)attr).getName().equals("DestinationId")) {
                        this.destinationId = (String)((AttributeType)attr).getAttributeValue().get(0);
                    }
                    if (((AttributeType)attr).getName().equals("ApprovedRequests")) {
                        this.approvalRequests = new ArrayList<String>();
                        for (Object next : ((AttributeType)attr).getAttributeValue()) {
                            if (!(next instanceof String)) continue;
                            this.approvalRequests.add((String)next);
                        }
                    }
                    if (!((AttributeType)attr).getName().equals("Approvers")) continue;
                    this.approvers = new ArrayList<Approver>();
                    for (Object next : ((AttributeType)attr).getAttributeValue()) {
                        if (!(next instanceof Approver)) continue;
                        this.approvers.add((Approver)next);
                    }
                    if (this.approvers.size() != 0) continue;
                    this.approvers = null;
                }
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing Approval Assertion: " + e.getMessage(), e);
        }
    }

    public String getApprovalId() {
        return this.approvalId;
    }

    public List<String> getApprovalRequests() {
        return this.approvalRequests;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public List<Approver> getApprovers() {
        return this.approvers;
    }

    public String toString() {
        return "ApprovalAssertionData [approvalId=" + this.approvalId + ", approvalRequests=" + this.approvalRequests + ", destinationId=" + this.destinationId + ", id=" + this.getId() + ", notBefore=" + this.getNotBefore() + ", notOnOrAfter=" + this.getNotOnOrAfter() + ", subjectId=" + this.getSubjectId() + ", signCertificate=" + this.getSignCertificate().toString() + "]";
    }
}

