/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import jakarta.xml.bind.Marshaller;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.CSMessageVersion;
import org.certificateservices.messages.csmessages.jaxb.ApprovalStatus;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;
import org.w3c.dom.Document;

public interface CSMessageParser {
    public void init(MessageSecurityProvider var1, Properties var2) throws MessageProcessingException;

    public CSMessage parseMessage(byte[] var1) throws MessageContentException, MessageProcessingException;

    public CSMessage parseMessage(byte[] var1, boolean var2) throws MessageContentException, MessageProcessingException;

    public CSMessage parseMessage(byte[] var1, boolean var2, boolean var3) throws MessageContentException, MessageProcessingException;

    public CSMessage parseMessage(Document var1) throws MessageContentException, MessageProcessingException;

    public CSMessage parseMessage(Document var1, boolean var2) throws MessageContentException, MessageProcessingException;

    public CSMessage parseMessage(Document var1, boolean var2, boolean var3) throws MessageContentException, MessageProcessingException;

    public byte[] generateCSRequestMessage(String var1, String var2, String var3, String var4, Object var5, List<Object> var6) throws MessageContentException, MessageProcessingException;

    public byte[] generateCSRequestMessage(String var1, String var2, String var3, String var4, Object var5, Credential var6, List<Object> var7) throws MessageContentException, MessageProcessingException;

    public CSMessage genCSMessage(String var1, String var2, String var3, String var4, String var5, String var6, Credential var7, Object var8, List<Object> var9) throws MessageContentException, MessageProcessingException;

    public CSMessageResponseData generateCSResponseMessage(String var1, CSMessage var2, String var3, Object var4) throws MessageContentException, MessageProcessingException;

    public CSMessageResponseData generateCSResponseMessage(String var1, CSMessage var2, String var3, Object var4, boolean var5) throws MessageContentException, MessageProcessingException;

    public byte[] generateGetApprovalRequest(String var1, String var2, String var3, byte[] var4, Credential var5, List<Object> var6) throws MessageContentException, MessageProcessingException;

    public byte[] generateIsApprovedRequest(String var1, String var2, String var3, String var4, Credential var5, List<Object> var6) throws MessageContentException, MessageProcessingException;

    public CSMessageResponseData generateIsApprovedResponse(String var1, CSMessage var2, ApprovalStatus var3, List<Object> var4) throws MessageContentException, MessageProcessingException;

    public CSMessageResponseData generateGetApprovalResponse(String var1, CSMessage var2, String var3, ApprovalStatus var4, List<Object> var5) throws MessageContentException, MessageProcessingException;

    public byte[] populateOriginatorAssertionsAndSignCSMessage(CSMessage var1, String var2, Credential var3, List<Object> var4) throws MessageContentException, MessageProcessingException;

    public CSMessageResponseData genCSFailureResponse(String var1, byte[] var2, RequestStatus var3, String var4, String var5, Credential var6) throws MessageContentException, MessageProcessingException;

    public X509Certificate getSigningCertificate(byte[] var1) throws MessageContentException, MessageProcessingException;

    public byte[] marshallAndSignCSMessage(CSMessage var1) throws MessageProcessingException, MessageContentException;

    public byte[] marshallCSMessage(CSMessage var1) throws MessageProcessingException, MessageContentException;

    public void validatePayloadObject(CSMessageVersion var1, Object var2) throws MessageContentException;

    public CSMessageVersion getVersionFromMessage(byte[] var1) throws MessageContentException, MessageProcessingException;

    public Credential getOriginatorFromRequest(CSMessage var1);

    public MessageSecurityProvider getMessageSecurityProvider();

    public Marshaller getMarshaller(CSMessage var1) throws MessageContentException, MessageProcessingException;
}

