/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.keystoremgmt;

import java.io.InputStream;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.CredentialRequest;
import org.certificateservices.messages.keystoremgmt.jaxb.AttachCredentialsRequest;
import org.certificateservices.messages.keystoremgmt.jaxb.AttachCredentialsResponse;
import org.certificateservices.messages.keystoremgmt.jaxb.CredentialRequestParams;
import org.certificateservices.messages.keystoremgmt.jaxb.GenerateCredentialRequestRequest;
import org.certificateservices.messages.keystoremgmt.jaxb.GenerateCredentialRequestResponse;
import org.certificateservices.messages.keystoremgmt.jaxb.GetAvailableKeyStoreInfoRequest;
import org.certificateservices.messages.keystoremgmt.jaxb.GetAvailableKeyStoreInfoResponse;
import org.certificateservices.messages.keystoremgmt.jaxb.KeyStore;
import org.certificateservices.messages.keystoremgmt.jaxb.ObjectFactory;
import org.certificateservices.messages.keystoremgmt.jaxb.RemoveKeyRequest;
import org.certificateservices.messages.keystoremgmt.jaxb.RemoveKeyResponse;
import org.certificateservices.messages.keystoremgmt.jaxb.UpdateKeyDescriptionRequest;
import org.certificateservices.messages.keystoremgmt.jaxb.UpdateKeyDescriptionResponse;
import org.certificateservices.messages.keystoremgmt.jaxb.X509CredentialRequestParams;

public class KeystoreMgmtPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/keystoremgmt2_0";
    private static final String KEYSTOREMGMT_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/keystoremgmt_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_KEYSTOREMGMT_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_KEYSTOREMGMT_VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.keystoremgmt.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_KEYSTOREMGMT_VERSION)) {
            return this.getClass().getResourceAsStream(KEYSTOREMGMT_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported KeystoreMgmt Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_KEYSTOREMGMT_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_KEYSTOREMGMT_VERSION;
    }

    public byte[] generateGetAvailableKeyStoreInfoRequest(String requestId, String destinationId, String organisation, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetAvailableKeyStoreInfoRequest payload = this.of.createGetAvailableKeyStoreInfoRequest();
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateGetAvailableKeyStoreInfoResponse(String relatedEndEntity, CSMessage request, List<KeyStore> keyStores, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetAvailableKeyStoreInfoResponse response = this.of.createGetAvailableKeyStoreInfoResponse();
        response.setKeyStores(new GetAvailableKeyStoreInfoResponse.KeyStores());
        for (KeyStore ks : keyStores) {
            response.getKeyStores().getKeyStore().add(ks);
        }
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] generateGenerateCredentialRequestRequest(String requestId, String destinationId, String organisation, String keyStoreProviderName, String application, CredentialRequestParams credentialRequestParams, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GenerateCredentialRequestRequest payload = this.of.createGenerateCredentialRequestRequest();
        payload.setApplication(application);
        payload.setKeyStoreProviderName(keyStoreProviderName);
        payload.setOrganisationShortName(organisation);
        payload.setCredentialRequestParams(new GenerateCredentialRequestRequest.CredentialRequestParams());
        if (credentialRequestParams instanceof X509CredentialRequestParams) {
            payload.getCredentialRequestParams().setX509CredentialRequestParams((X509CredentialRequestParams)credentialRequestParams);
        } else {
            payload.getCredentialRequestParams().setBaseRequestParams(credentialRequestParams);
        }
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateGenerateCredentialRequestResponse(String relatedEndEntity, CSMessage request, CredentialRequest credentialRequest, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GenerateCredentialRequestResponse response = this.of.createGenerateCredentialRequestResponse();
        response.setCredentialRequest(credentialRequest);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] generateRemoveKeyRequest(String requestId, String destinationId, String organisation, String keyStoreProviderName, String alias, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RemoveKeyRequest payload = this.of.createRemoveKeyRequest();
        payload.setAlias(alias);
        payload.setKeyStoreProviderName(keyStoreProviderName);
        payload.setOrganisationShortName(organisation);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateRemoveKeyResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RemoveKeyResponse response = this.of.createRemoveKeyResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] generateAttachCredentialsRequest(String requestId, String destinationId, String organisation, String keyStoreProviderName, String alias, List<Credential> credentialChain, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        AttachCredentialsRequest payload = this.of.createAttachCredentialsRequest();
        payload.setAlias(alias);
        payload.setKeyStoreProviderName(keyStoreProviderName);
        payload.setOrganisationShortName(organisation);
        payload.setCredentials(new AttachCredentialsRequest.Credentials());
        for (Credential c : credentialChain) {
            payload.getCredentials().getCredential().add(c);
        }
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateAttachCredentialsResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        AttachCredentialsResponse response = this.of.createAttachCredentialsResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] generateUpdateKeyDescriptionRequest(String requestId, String destinationId, String organisation, String keyStoreProviderName, String alias, String description, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        UpdateKeyDescriptionRequest payload = this.of.createUpdateKeyDescriptionRequest();
        payload.setAlias(alias);
        payload.setKeyStoreProviderName(keyStoreProviderName);
        payload.setOrganisationShortName(organisation);
        payload.setDescription(description);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateUpdateKeyDescriptionResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        UpdateKeyDescriptionResponse response = this.of.createUpdateKeyDescriptionResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }
}

