/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.saml2.protocol;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.ResponseStatusCodes;
import org.certificateservices.messages.saml2.BaseSAMLMessageParser;
import org.certificateservices.messages.saml2.assertion.jaxb.ConditionsType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.saml2.assertion.jaxb.SubjectType;
import org.certificateservices.messages.saml2.protocol.jaxb.AuthnRequestType;
import org.certificateservices.messages.saml2.protocol.jaxb.ExtensionsType;
import org.certificateservices.messages.saml2.protocol.jaxb.NameIDPolicyType;
import org.certificateservices.messages.saml2.protocol.jaxb.RequestAbstractType;
import org.certificateservices.messages.saml2.protocol.jaxb.RequestedAuthnContextType;
import org.certificateservices.messages.saml2.protocol.jaxb.ResponseType;
import org.certificateservices.messages.saml2.protocol.jaxb.ScopingType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusCodeType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusDetailType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusResponseType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusType;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.XMLSigner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLProtocolMessageParser
extends BaseSAMLMessageParser {
    private static final String BASE_JAXB_CONTEXT = "org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.saml2.protocol.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb:org.certificateservices.messages.sweeid2.pricipalselection1_0.jaxb";
    private AuthNSignatureLocationFinder authNSignatureLocationFinder = new AuthNSignatureLocationFinder();

    @Override
    public String getNameSpace() {
        return PROTOCOL_NAMESPACE;
    }

    @Override
    public String getJAXBPackages() {
        return BASE_JAXB_CONTEXT;
    }

    @Override
    public String[] getDefaultSchemaLocations() throws SAXException {
        return new String[]{"/xmldsig-core-schema.xsd", "/xenc-schema.xsd", "/cs-message-saml-schema-assertion-2.0.xsd", "/cs-message-saml-schema-protocol-2.0.xsd"};
    }

    @Override
    public XMLSigner.SignatureLocationFinder getSignatureLocationFinder() {
        return this.samlpSignatureLocationFinder;
    }

    @Override
    public XMLSigner.OrganisationLookup getOrganisationLookup() {
        return null;
    }

    @Override
    protected String lookupSchemaForElement(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (namespaceURI != null) {
            if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                return "/xmldsig-core-schema.xsd";
            }
            if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                return "/xenc-schema.xsd";
            }
            if (namespaceURI.equals(ASSERTION_NAMESPACE)) {
                return "/cs-message-saml-schema-assertion-2.0.xsd";
            }
            if (namespaceURI.equals(PROTOCOL_NAMESPACE)) {
                return "/cs-message-saml-schema-protocol-2.0.xsd";
            }
        }
        return null;
    }

    public byte[] genAuthNRequest(ContextMessageSecurityProvider.Context context, String id, Boolean forceAuthn, Boolean isPassive, String protocolBinding, Integer assertionConsumerServiceIndex, String assertionConsumerServiceURL, Integer attributeConsumingServiceIndex, String providerName, String destination, String consent, NameIDType issuer, ExtensionsType extensions, SubjectType subject, NameIDPolicyType nameIdPolicy, ConditionsType conditions, RequestedAuthnContextType requestedAuthnContext, ScopingType scoping, boolean signRequest) throws MessageProcessingException, MessageContentException {
        AuthnRequestType art = this.samlpOf.createAuthnRequestType();
        this.populateRequestAbstractType(art, id, destination, consent, issuer, extensions);
        art.setForceAuthn(forceAuthn);
        art.setIsPassive(isPassive);
        art.setProtocolBinding(protocolBinding);
        art.setAssertionConsumerServiceIndex(assertionConsumerServiceIndex);
        art.setAssertionConsumerServiceURL(assertionConsumerServiceURL);
        art.setAttributeConsumingServiceIndex(attributeConsumingServiceIndex);
        art.setProviderName(providerName);
        art.setSubject(subject);
        art.setNameIDPolicy(nameIdPolicy);
        art.setConditions(conditions);
        art.setRequestedAuthnContext(requestedAuthnContext);
        art.setScoping(scoping);
        Document doc = this.getDocumentBuilder().newDocument();
        try {
            this.getMarshaller().marshal(this.samlpOf.createAuthnRequest(art), (Node)doc);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling message " + e.getMessage(), e);
        }
        if (signRequest) {
            this.xmlSigner.sign(context, doc, this.authNSignatureLocationFinder);
        }
        return this.xmlSigner.marshallDoc(doc);
    }

    public byte[] genResponse(ContextMessageSecurityProvider.Context context, String inResponseTo, NameIDType issuer, String destination, String consent, ExtensionsType extensions, ResponseStatusCodes statusCode, String statusMessage, StatusDetailType statusDetail, List<JAXBElement<?>> assertions, boolean signAssertions, boolean signSAMLPResponse) throws MessageContentException, MessageProcessingException {
        try {
            ResponseType responseType = this.samlpOf.createResponseType();
            this.populateStatusResponseType(responseType, inResponseTo, destination, consent, issuer, extensions, statusCode, statusMessage, statusDetail);
            if (assertions != null) {
                for (JAXBElement<?> a : assertions) {
                    responseType.getAssertionOrEncryptedAssertion().add(a.getValue());
                }
            }
            JAXBElement<ResponseType> response = this.samlpOf.createResponse(responseType);
            return this.marshallAndSignSAMLPOrAssertion(context, response, signAssertions, signSAMLPResponse);
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error generation SAMLP Failure Message: " + e.getMessage(), e);
        }
    }

    protected void populateRequestAbstractType(RequestAbstractType requestAbstractType, String id, String destination, String consent, NameIDType issuer, ExtensionsType extensions) throws MessageProcessingException, MessageContentException {
        requestAbstractType.setID(id);
        requestAbstractType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
        requestAbstractType.setVersion(DEFAULT_SAML_VERSION);
        requestAbstractType.setDestination(destination);
        requestAbstractType.setConsent(consent);
        requestAbstractType.setIssuer(issuer);
        requestAbstractType.setExtensions(extensions);
    }

    protected void populateRequestAbstractType(RequestAbstractType requestAbstractType, String destination, String consent, NameIDType issuer, ExtensionsType extensions) throws MessageProcessingException, MessageContentException {
        this.populateRequestAbstractType(requestAbstractType, "_" + MessageGenerateUtils.generateRandomUUID(), destination, consent, issuer, extensions);
    }

    protected void populateStatusResponseType(StatusResponseType statusResponseType, String inResponseTo, String destination, String consent, NameIDType issuer, ExtensionsType extensions, ResponseStatusCodes statusCode, String statusMessage, StatusDetailType statusDetail) throws MessageProcessingException, MessageContentException {
        StatusCodeType statusCodeType = this.samlpOf.createStatusCodeType();
        statusCodeType.setValue(statusCode.getURIValue());
        StatusType statusType = this.samlpOf.createStatusType();
        statusType.setStatusCode(statusCodeType);
        statusType.setStatusMessage(statusMessage);
        statusType.setStatusDetail(statusDetail);
        statusResponseType.setID("_" + MessageGenerateUtils.generateRandomUUID());
        statusResponseType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
        statusResponseType.setVersion(DEFAULT_SAML_VERSION);
        statusResponseType.setInResponseTo(inResponseTo);
        statusResponseType.setStatus(statusType);
        statusResponseType.setIssuer(issuer);
        statusResponseType.setDestination(destination);
        statusResponseType.setConsent(consent);
        statusResponseType.setExtensions(extensions);
    }

    public List<Document> extractAssertionsFromSAMLP(Document samlPResponse) throws MessageContentException {
        try {
            ArrayList<Document> retval = new ArrayList<Document>();
            NodeList assertionNodes = samlPResponse.getElementsByTagNameNS(ASSERTION_NAMESPACE, "Assertion");
            for (int i = 0; i < assertionNodes.getLength(); ++i) {
                Node assertionNode = assertionNodes.item(i);
                Document newDoc = this.getDocumentBuilder().newDocument();
                Node newNode = assertionNode.cloneNode(true);
                newDoc.adoptNode(newNode);
                newDoc.appendChild(newNode);
                retval.add(newDoc);
            }
            return retval;
        }
        catch (Exception e) {
            throw new MessageContentException("Error extracting assertions from SAMLP Response: " + e.getMessage(), e);
        }
    }

    private class AuthNSignatureLocationFinder
    extends BaseSAMLMessageParser.SAMLPSignatureLocationFinder {
        private AuthNSignatureLocationFinder() {
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            ArrayList<QName> beforeSiblings = new ArrayList<QName>();
            beforeSiblings.add(new QName(BaseSAMLMessageParser.PROTOCOL_NAMESPACE, "Extensions"));
            beforeSiblings.add(new QName(BaseSAMLMessageParser.ASSERTION_NAMESPACE, "Subject"));
            beforeSiblings.add(new QName(BaseSAMLMessageParser.PROTOCOL_NAMESPACE, "NameIDPolicy"));
            beforeSiblings.add(new QName(BaseSAMLMessageParser.ASSERTION_NAMESPACE, "Conditions"));
            beforeSiblings.add(new QName(BaseSAMLMessageParser.PROTOCOL_NAMESPACE, "RequestedAuthnContext"));
            beforeSiblings.add(new QName(BaseSAMLMessageParser.PROTOCOL_NAMESPACE, "Scoping"));
            return beforeSiblings;
        }
    }
}

