/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509DataOnlyKeySelector
extends KeySelector {
    protected static Logger log = Logger.getLogger(X509DataOnlyKeySelector.class.getName());
    protected MessageSecurityProvider pkiMessageSecurityProvider;

    public X509DataOnlyKeySelector(MessageSecurityProvider pkiMessageSecurityProvider) {
        this.pkiMessageSecurityProvider = pkiMessageSecurityProvider;
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        SignatureMethod sm = (SignatureMethod)method;
        String organisation = this.findOrganisation(context);
        for (XMLStructure kiType : keyInfo.getContent()) {
            if (kiType instanceof X509Data) {
                X509Data xd = (X509Data)kiType;
                KeySelectorResult ksr = this.x509DataSelect(xd, sm, organisation);
                if (ksr == null) continue;
                return ksr;
            }
            if (kiType instanceof KeyName) {
                log.fine("Recieved digitally signed message with unsupported KeyName in KeyInfo, skipping.");
                continue;
            }
            if (!(kiType instanceof RetrievalMethod)) continue;
            log.fine("Recieved digitally signed message with unsupported KeyName in RetrievalMethod, skipping.");
        }
        return new SimpleKeySelectorResult(null);
    }

    private String findOrganisation(XMLCryptoContext context) throws KeySelectorException {
        String retval = null;
        if (!(context instanceof DOMValidateContext)) {
            throw new KeySelectorException("Invalid XMLCryptoContext, a DOMValidateContext is required to extract organisation name.");
        }
        DOMValidateContext ctx = (DOMValidateContext)context;
        NodeList csMessageChilds = ctx.getNode().getParentNode().getChildNodes();
        for (int i = 0; i < csMessageChilds.getLength(); ++i) {
            Node next = csMessageChilds.item(i);
            if (!next.getLocalName().equals("organisation")) continue;
            retval = next.getTextContent();
            break;
        }
        if (retval == null) {
            throw new KeySelectorException("Error couldn't find required organisation name in message");
        }
        return retval;
    }

    private KeySelectorResult x509DataSelect(X509Data xd, SignatureMethod sm, String organisation) throws KeySelectorException {
        SimpleKeySelectorResult ksr = null;
        Iterator<?> xi = xd.getContent().iterator();
        while (xi.hasNext()) {
            ksr = null;
            Object o = xi.next();
            if (o instanceof X509Certificate) {
                X509Certificate xcert = (X509Certificate)o;
                try {
                    if (this.pkiMessageSecurityProvider.isValidAndAuthorized(xcert, organisation)) {
                        ksr = new SimpleKeySelectorResult(xcert.getPublicKey());
                    }
                    log.fine("A certificate with DN " + xcert.getSubjectDN().toString() + " signing a message wasn't authorized or valid.");
                }
                catch (IllegalArgumentException e) {
                    throw new KeySelectorException(e.getMessage(), e);
                }
                catch (MessageProcessingException e) {
                    throw new KeySelectorException(e.getMessage(), e);
                }
            } else if (o instanceof X509IssuerSerial) {
                log.fine("Recieved digitally signed message with unsupported X509Data with X509IssuerSerial, skipping.");
            } else if (o instanceof String) {
                log.fine("Recieved digitally signed message with unsupported X509Data with String, only X509Certificate supported, skipping.");
            } else {
                if (!(o instanceof byte[])) continue;
                log.fine("Recieved digitally signed message with unsupported X509Data with String, only SPKIInfo supported, skipping.");
            }
            if (ksr == null) continue;
            return ksr;
        }
        return null;
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final Key key;

        SimpleKeySelectorResult(Key key) {
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

