/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.sensitivekeys;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.sensitivekeys.jaxb.AsymmetricKey;
import org.certificateservices.messages.sensitivekeys.jaxb.EncodedKey;
import org.certificateservices.messages.sensitivekeys.jaxb.KeyData;
import org.certificateservices.messages.sensitivekeys.jaxb.ObjectFactory;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class SensitiveKeysParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/sensitivekeys";
    public static String DEFAULT_VERSION = "2.0";
    public static final String SENSITIVE_KEYS_XSD_SCHEMA_RESOURCE_LOCATION = "/sensitivekeys_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private XMLEncrypter xmlEncrypter;
    private Map<String, KeyFactory> keyFactoryMap = new HashMap<String, KeyFactory>();
    private JAXBContext jaxbContext = null;
    private Schema schema = null;
    private Transformer transformer = null;

    public SensitiveKeysParser(MessageSecurityProvider securityProvider) throws MessageProcessingException {
        try {
            this.xmlEncrypter = new XMLEncrypter(securityProvider, this.getDocumentBuilder(), this.getMarshaller(), this.getUnmarshaller());
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initializing SensitiveKeysParser: " + e.getMessage(), e);
        }
    }

    public KeyData parse(byte[] data) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(data));
            return (KeyData)this.getUnmarshaller().unmarshal((Node)doc);
        }
        catch (SAXException e) {
            throw new MessageContentException("Message content error when parsing sensitive key data: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Message content error when parsing sensitive key data: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when parsing sensitive key data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when parsing sensitive key data: " + e.getMessage(), e);
        }
    }

    public KeyData decryptAndParse(byte[] encryptedData) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(encryptedData));
            return (KeyData)this.xmlEncrypter.decryptDocument(doc);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error parsing encrypted sensitive key data: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new MessageContentException("Internal content encrypted sensitive key data: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Internal content encrypted sensitive key data: " + e.getMessage(), e);
        }
    }

    public KeyData genKeyData(KeyPair asymmetricKey) {
        return this.genKeyData(this.encodeKey(asymmetricKey.getPublic()), this.encodeKey(asymmetricKey.getPrivate()));
    }

    public KeyData genKeyData(EncodedKey publicKey, EncodedKey privateKey) {
        KeyData kd = this.of.createKeyData();
        kd.setVersion(DEFAULT_VERSION);
        AsymmetricKey ak = this.of.createAsymmetricKey();
        ak.setPublicKey(publicKey);
        ak.setPrivateKey(privateKey);
        kd.setAsymmetricKey(ak);
        return kd;
    }

    public KeyData genKeyData(Key symmetricKey) {
        return this.genKeyData(this.encodeKey(symmetricKey));
    }

    public KeyData genKeyData(EncodedKey symmetricKey) {
        KeyData kd = this.of.createKeyData();
        kd.setVersion(DEFAULT_VERSION);
        kd.setSymmetricKey(symmetricKey);
        return kd;
    }

    public SecretKey getSymmetricKey(KeyData keyData) throws MessageContentException {
        if (keyData.getSymmetricKey() == null) {
            throw new MessageContentException("Error extracting symmetric key from key data, no symmetric key data found.");
        }
        return new SecretKeySpec(keyData.getSymmetricKey().getData(), keyData.getSymmetricKey().getAlgorithm());
    }

    public KeyPair getAssymmetricKey(KeyData keyData) throws MessageContentException {
        if (keyData.getAsymmetricKey() == null) {
            throw new MessageContentException("Error extracting asymmetric key from key data, no asymmetric key data found.");
        }
        try {
            PublicKey publicKey = null;
            EncodedKey pubKeyEncoded = keyData.getAsymmetricKey().getPublicKey();
            KeyFactory keyFactory = this.getKeyFactory(pubKeyEncoded.getAlgorithm());
            if (pubKeyEncoded.getFormat().equals("X.509")) {
                publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(pubKeyEncoded.getData()));
            }
            PrivateKey privateKey = null;
            EncodedKey privateKeyEncoded = keyData.getAsymmetricKey().getPrivateKey();
            if (privateKeyEncoded.getFormat().equals("PKCS#8")) {
                privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyEncoded.getData()));
            }
            if (publicKey != null && privateKey != null) {
                return new KeyPair(publicKey, privateKey);
            }
            throw new MessageContentException("Invalid key specification, unsupported encoding format for assymetric key, public key: " + pubKeyEncoded.getFormat() + ", private key: " + privateKeyEncoded.getFormat());
        }
        catch (InvalidKeySpecException e) {
            throw new MessageContentException("Invalid key specification in KeyData XML: " + e.getMessage(), e);
        }
    }

    protected EncodedKey encodeKey(Key key) {
        EncodedKey ek = this.of.createEncodedKey();
        ek.setAlgorithm(key.getAlgorithm());
        ek.setFormat(key.getFormat());
        ek.setData(key.getEncoded());
        return ek;
    }

    public byte[] marshall(KeyData key) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal((Object)key, (Node)doc);
            StringWriter writer = new StringWriter();
            this.getTransformer().transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when generating sensitive key data: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageProcessingException("Internal error when generating sensitive key data: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageProcessingException("Internal error when generating sensitive key data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when generating sensitive key data: " + e.getMessage(), e);
        }
    }

    public byte[] encryptAndMarshall(KeyData key, List<X509Certificate> recipients) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal((Object)key, (Node)doc);
            Document encDoc = this.xmlEncrypter.encryptElement(doc, recipients, false);
            StringWriter writer = new StringWriter();
            this.getTransformer().transform(new DOMSource(encDoc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when generating sensitive key data: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageProcessingException("Internal error when generating sensitive key data: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageProcessingException("Internal error when generating sensitive key data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when generating sensitive key data: " + e.getMessage(), e);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setSchema(this.getSchema());
        return unmarshaller;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            String jaxbClassPath = "org.certificateservices.messages.sensitivekeys.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb";
            this.jaxbContext = JAXBContext.newInstance((String)jaxbClassPath);
        }
        return this.jaxbContext;
    }

    private Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = this.generateSchema();
        }
        return this.schema;
    }

    private Schema generateSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new SensitiveKeysParserLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/xenc-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(SENSITIVE_KEYS_XSD_SCHEMA_RESOURCE_LOCATION))};
        Schema schema = schemaFactory.newSchema(sources);
        return schema;
    }

    private Transformer getTransformer() throws MessageProcessingException {
        if (this.transformer == null) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                this.transformer = tf.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new MessageProcessingException("Error instanciating Transformer for XMLSigner: " + e.getMessage(), e);
            }
        }
        return this.transformer;
    }

    private KeyFactory getKeyFactory(String algoritm) throws MessageContentException {
        KeyFactory retval = this.keyFactoryMap.get(algoritm);
        if (retval == null) {
            try {
                retval = KeyFactory.getInstance(algoritm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new MessageContentException("Error in KeyData XML, unsupported key algorithm: " + algoritm);
            }
            this.keyFactoryMap.put(algoritm, retval);
        }
        return retval;
    }

    public class SensitiveKeysParserLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xenc-schema.xsd"));
                    }
                    if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xmldsig-core-schema.xsd"));
                    }
                    if (namespaceURI.equals(NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(SensitiveKeysParser.SENSITIVE_KEYS_XSD_SCHEMA_RESOURCE_LOCATION));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

