/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.assertion;

import jakarta.xml.bind.JAXBElement;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.AssertionPayloadParser;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.utils.MessageGenerateUtils;

public abstract class AssertionData {
    protected String id;
    protected Date notBefore;
    protected Date notOnOrAfter;
    protected String subjectId;
    protected X509Certificate signCertificate;
    protected AssertionPayloadParser assertionPayloadParser;

    public AssertionData(AssertionPayloadParser assertionPayloadParser) {
        this.assertionPayloadParser = assertionPayloadParser;
    }

    public abstract void parse(JAXBElement<AssertionType> var1) throws MessageContentException, MessageProcessingException;

    protected void parseCommonData(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        AssertionType assertionType = (AssertionType)assertion.getValue();
        this.id = assertionType.getID();
        this.notBefore = MessageGenerateUtils.xMLGregorianCalendarToDate(assertionType.getConditions().getNotBefore());
        this.notOnOrAfter = MessageGenerateUtils.xMLGregorianCalendarToDate(assertionType.getConditions().getNotOnOrAfter());
        for (JAXBElement<?> subjectContent : assertionType.getSubject().getContent()) {
            if (!(subjectContent instanceof JAXBElement) || !(subjectContent.getValue() instanceof NameIDType)) continue;
            this.subjectId = ((NameIDType)subjectContent.getValue()).getValue();
        }
        this.signCertificate = this.assertionPayloadParser.getCertificateFromAssertion(assertion);
    }

    public String getId() {
        return this.id;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public X509Certificate getSignCertificate() {
        return this.signCertificate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssertionData other = (AssertionData)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

