/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import java.util.Properties;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;

public class CSMessageParserManager {
    public static final String SETTING_CSMESSAGEPARSER_IMPL = "csmessage.parser.impl";
    private static final String DEFAULT_IMPLEMENTATION = DefaultCSMessageParser.class.getName();
    private static CSMessageParser parser;
    private static MessageSecurityProvider securityProvider;
    private static Properties config;

    public static CSMessageParser initCSMessageParser(MessageSecurityProvider securityProvider, Properties config) throws MessageProcessingException {
        CSMessageParserManager.securityProvider = securityProvider;
        CSMessageParserManager.config = config;
        parser = CSMessageParserManager.newCSMessageParser();
        return parser;
    }

    public static boolean isInitialized() {
        return parser != null;
    }

    public static CSMessageParser getCSMessageParser() throws MessageProcessingException {
        if (config == null) {
            throw new MessageProcessingException("Error CS Message parser haven't been initialized, make sure initCSMessageParser() is called before getCSMessageParser");
        }
        if (parser == null) {
            parser = CSMessageParserManager.newCSMessageParser();
        }
        return parser;
    }

    private static CSMessageParser newCSMessageParser() throws MessageProcessingException {
        String cp = config.getProperty(SETTING_CSMESSAGEPARSER_IMPL, DEFAULT_IMPLEMENTATION);
        try {
            Class<?> c = CSMessageParserManager.class.getClassLoader().loadClass(cp);
            CSMessageParser parser = (CSMessageParser)c.newInstance();
            parser.init(securityProvider, config);
            return parser;
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error creating CS Message Parser: " + e.getMessage(), e);
        }
    }
}

