/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509NameTokenizer;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.certificateservices.messages.utils.BCCertificateFactory;

public class CertUtils {
    private static Logger log = Logger.getLogger(CertUtils.class.getName());
    public static final String BEGIN_CERTIFICATE_REQUEST = "-----BEGIN CERTIFICATE REQUEST-----";
    public static final String END_CERTIFICATE_REQUEST = "-----END CERTIFICATE REQUEST-----";
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_PKCS7 = "-----BEGIN PKCS7-----";
    public static final String END_PKCS7 = "-----END PKCS7-----";
    public static final int BASE64_LINE_LENGTH = 64;
    public static final String GUID_OBJECTID = "1.3.6.1.4.1.311.25.1";
    public static final String KRB5PRINCIPAL_OBJECTID = "1.3.6.1.5.2.2";
    public static final String UPN_OBJECTID = "1.3.6.1.4.1.311.20.2.3";
    private static CertificateFactory certFact = null;

    public static CertificateFactory getCertificateFactory() throws NoSuchProviderException {
        if (certFact == null) {
            certFact = new BCCertificateFactory();
        }
        return certFact;
    }

    public static Provider getBCProvider() throws NoSuchProviderException {
        Provider bc = Security.getProvider("BC");
        if (bc == null) {
            throw new NoSuchProviderException();
        }
        return bc;
    }

    public static X509Certificate getCertfromByteArray(byte[] cert) throws CertificateException {
        try {
            CertificateFactory cf = CertUtils.getCertificateFactory();
            X509Certificate x509cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            if (x509cert == null) {
                throw new CertificateException("Error invalid certificate data");
            }
            return x509cert;
        }
        catch (NoSuchProviderException e) {
            throw new CertificateException("No such provider BC when creating certificate: " + e.getMessage());
        }
    }

    public static String getPEMCertFromByteArray(byte[] cert) {
        String pem = null;
        byte[] bytes = Base64.encode((byte[])cert);
        pem = "-----BEGIN CERTIFICATE-----\n";
        int l = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte[] buf;
            if (l < 64) {
                buf = new byte[]{bytes[i]};
                ++l;
            } else {
                buf = new byte[]{10, bytes[i]};
                l = 1;
            }
            pem = pem + new String(buf, Charset.forName("UTF-8"));
        }
        pem = pem + "\n" + END_CERTIFICATE;
        return pem;
    }

    public static String getPemCertificateRequestFromByteArray(byte[] certificateRequest) {
        String pem = null;
        byte[] bytes = Base64.encode((byte[])certificateRequest);
        pem = "-----BEGIN CERTIFICATE REQUEST-----\n";
        int l = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte[] buf;
            if (l < 64) {
                buf = new byte[]{bytes[i]};
                ++l;
            } else {
                buf = new byte[]{10, bytes[i]};
                l = 1;
            }
            pem = pem + new String(buf, Charset.forName("UTF-8"));
        }
        pem = pem + "\n" + END_CERTIFICATE_REQUEST;
        return pem;
    }

    public static X509CRL getCRLfromByteArray(byte[] crl) throws CRLException {
        try {
            CertificateFactory cf = CertUtils.getCertificateFactory();
            X509CRL x509crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crl));
            if (x509crl == null) {
                throw new CRLException("Error invalid crl data");
            }
            return x509crl;
        }
        catch (NoSuchProviderException e) {
            throw new CRLException("No such provider BC when creating certificate: " + e.getMessage());
        }
    }

    public static byte[] getBytesFromPEM(byte[] inbuf, String beginKey, String endKey) throws IOException {
        String temp;
        if (inbuf == null) {
            throw new IOException("Error, data was null in input buffer");
        }
        ByteArrayInputStream instream = new ByteArrayInputStream(inbuf);
        BufferedReader bufRdr = new BufferedReader(new InputStreamReader(instream));
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        PrintStream opstr = new PrintStream(ostr);
        while ((temp = bufRdr.readLine()) != null && !temp.equals(beginKey)) {
        }
        if (temp == null) {
            throw new IOException("Error in input buffer, missing " + beginKey + " boundary");
        }
        while ((temp = bufRdr.readLine()) != null && !temp.equals(endKey)) {
            opstr.print(temp);
        }
        if (temp == null) {
            throw new IOException("Error in input buffer, missing " + endKey + " boundary");
        }
        opstr.close();
        byte[] bytes = Base64.decode((byte[])ostr.toByteArray());
        return bytes;
    }

    public static PKCS10CertificationRequest genPKCS10RequestMessageFromPEM(byte[] b64Encoded) {
        byte[] buffer = null;
        try {
            String beginKey = BEGIN_CERTIFICATE_REQUEST;
            String endKey = END_CERTIFICATE_REQUEST;
            buffer = CertUtils.getBytesFromPEM(b64Encoded, beginKey, endKey);
        }
        catch (IOException e) {
            try {
                String beginKey = "-----BEGIN NEW CERTIFICATE REQUEST-----";
                String endKey = "-----END NEW CERTIFICATE REQUEST-----";
                buffer = CertUtils.getBytesFromPEM(b64Encoded, beginKey, endKey);
            }
            catch (IOException ioe) {
                try {
                    buffer = Base64.decode((byte[])b64Encoded);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (buffer == null) {
            return null;
        }
        PKCS10CertificationRequest retval = null;
        try {
            retval = new PKCS10CertificationRequest(buffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return retval;
    }

    public static X509Certificate getX509CertificateFromPEMorDER(byte[] certData) {
        if (certData == null) {
            return null;
        }
        X509Certificate retval = null;
        try {
            retval = CertUtils.getCertfromByteArray(certData);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (retval == null) {
            try {
                retval = CertUtils.getCertfromByteArray(CertUtils.getBytesFromPEM(certData, BEGIN_CERTIFICATE, END_CERTIFICATE));
            }
            catch (IOException | CertificateException exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static synchronized void installBCProvider() {
        Security.removeProvider("BC");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static String getNormalizedSubject(String subject) {
        if (subject == null) {
            return null;
        }
        return new X500Name(BCStyle.INSTANCE, subject).toString();
    }

    public static X500Name toX500Name(String dNName) {
        if (dNName == null) {
            return null;
        }
        return new X500Name(BCStyle.INSTANCE, dNName);
    }

    public static String getIssuer(X509Certificate certificate) {
        return new X500Name(BCStyle.INSTANCE, certificate.getIssuerDN().toString()).toString();
    }

    public static String getIssuer(X509CRL crl) {
        return new X500Name(BCStyle.INSTANCE, crl.getIssuerDN().toString()).toString();
    }

    public static String getSubject(X509Certificate certificate) {
        return new X500Name(BCStyle.INSTANCE, certificate.getSubjectDN().toString()).toString();
    }

    public static String getSubjectDNFromCSR(byte[] certRequest) {
        PKCS10CertificationRequest pkcs10CertificationRequest = new PKCS10CertificationRequest(certRequest);
        return pkcs10CertificationRequest.getCertificationRequestInfo().getSubject().toString();
    }

    public static X509Certificate normalizeCertificate(X509Certificate certificate) {
        if (!certificate.getClass().getName().contains("bouncycastle")) {
            try {
                certificate = (X509Certificate)CertUtils.getCertificateFactory().generateCertificate(new ByteArrayInputStream(certificate.getEncoded()));
            }
            catch (CertificateException e) {
                log.log(Level.SEVERE, "Error parsing certificate when extracting issuer dn: " + e.getMessage(), e);
            }
            catch (NoSuchProviderException e) {
                log.log(Level.SEVERE, "Error BC Provider not found when extracting issuer dn: " + e.getMessage(), e);
            }
        }
        return certificate;
    }

    public static boolean isDNsEqual(String x500Name1, String x500Name2) {
        return BCStyle.INSTANCE.areEqual(new X500Name(BCStyle.INSTANCE, x500Name1), new X500Name(BCStyle.INSTANCE, x500Name2));
    }

    public static int getDNHashCode(String x500Name) {
        if (x500Name == null) {
            return 0;
        }
        return BCStyle.INSTANCE.calculateHashCode(new X500Name(BCStyle.INSTANCE, x500Name));
    }

    public static String getSubjectDNField(String subject, ASN1ObjectIdentifier fieldName) {
        if (subject == null) {
            return null;
        }
        int n = 0;
        RDN[] rDNArray = new X500Name(BCStyle.INSTANCE, subject).getRDNs(fieldName);
        int n2 = rDNArray.length;
        if (n < n2) {
            RDN rDN = rDNArray[n];
            AttributeTypeAndValue first = rDN.getFirst();
            return first.getValue().toString();
        }
        return null;
    }

    public static List<String> getSubjectDNFields(String subject, ASN1ObjectIdentifier fieldName) {
        ArrayList<String> retval = new ArrayList<String>();
        if (subject == null) {
            return retval;
        }
        for (RDN rDN : new X500Name(BCStyle.INSTANCE, subject).getRDNs(fieldName)) {
            if (rDN.isMultiValued()) {
                AttributeTypeAndValue[] values = rDN.getTypesAndValues();
                for (int i = 0; i < values.length; ++i) {
                    retval.add(values[i].getValue().toString());
                }
                continue;
            }
            retval.add(rDN.getFirst().getValue().toString());
        }
        return retval;
    }

    public static String getSubjectDNField(X509Certificate cert, ASN1ObjectIdentifier fieldName) {
        if (cert == null) {
            return null;
        }
        return CertUtils.getSubjectDNField(CertUtils.getSubject(cert), fieldName);
    }

    public static String getCertificateUniqueId(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return cert.getSerialNumber().toString(16) + ";" + CertUtils.getIssuer(cert);
    }

    public static String getFirstSubjectField(ASN1ObjectIdentifier dnField, String subjectDN) {
        String retval;
        block1: {
            if (dnField == null || subjectDN == null || subjectDN.trim().equals("")) {
                return null;
            }
            retval = null;
            int n = 0;
            RDN[] rDNArray = new X500Name(BCStyle.INSTANCE, subjectDN).getRDNs(dnField);
            int n2 = rDNArray.length;
            if (n >= n2) break block1;
            RDN rDN = rDNArray[n];
            AttributeTypeAndValue first = rDN.getFirst();
            retval = first.getValue().toString();
        }
        return retval;
    }

    public static String getCertSerialnumberAsString(Certificate cert) throws IllegalArgumentException {
        if (cert != null && cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSerialNumber().toString(16).toLowerCase();
        }
        throw new IllegalArgumentException("Illegal certificate type or 'null' certificate specified when parsing serial number.");
    }

    public static String getEmailFromAlternativeName(X509Certificate certificate) throws CertificateParsingException {
        if (certificate != null && certificate.getSubjectAlternativeNames() != null) {
            for (List<?> item : certificate.getSubjectAlternativeNames()) {
                Integer type = (Integer)item.get(0);
                if (type != 1) continue;
                return (String)item.get(1);
            }
        }
        return null;
    }

    public static boolean isDeltaCRL(X509CRL crl) {
        if (crl == null) {
            return false;
        }
        return crl.getExtensionValue(X509Extension.deltaCRLIndicator.getId()) != null;
    }

    public static Long readCRLNumberFromCRL(X509CRL crl) throws CRLException {
        if (crl == null) {
            return null;
        }
        try {
            byte[] extentionData = crl.getExtensionValue(X509Extension.cRLNumber.getId());
            if (extentionData != null) {
                ASN1Integer crlNumber = (ASN1Integer)X509ExtensionUtil.fromExtensionValue((byte[])extentionData);
                return crlNumber.getValue().longValue();
            }
            return null;
        }
        catch (Exception e) {
            throw new CRLException("bad encoding of CRL number in CRL.");
        }
    }

    public static String getGUIDFromAlternativeName(X509Certificate cert) throws IOException, CertificateParsingException {
        Collection<List<?>> altNames;
        if (cert != null && (altNames = cert.getSubjectAlternativeNames()) != null) {
            for (List<?> altName : altNames) {
                ASN1Sequence seq = CertUtils.getAltnameSequence(altName);
                String retval = CertUtils.getGUIDStringFromSequence(seq);
                if (retval == null) continue;
                return retval;
            }
        }
        return null;
    }

    private static String getGUIDStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id;
        if (seq != null && (id = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0))).getId().equals(GUID_OBJECTID)) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1OctetString str = ASN1OctetString.getInstance((Object)obj.getBaseObject());
            return new String(Hex.encode((byte[])str.getOctets()));
        }
        return null;
    }

    private static ASN1Sequence getAltnameSequence(List<?> listitem) throws IOException {
        Integer no = (Integer)listitem.get(0);
        if (no == 0) {
            byte[] altName = (byte[])listitem.get(1);
            return CertUtils.getAltnameSequence(altName);
        }
        return null;
    }

    private static ASN1Sequence getAltnameSequence(byte[] value) throws IOException {
        ASN1Primitive oct = null;
        try (ASN1InputStream ais = new ASN1InputStream((InputStream)new ByteArrayInputStream(value));){
            oct = ais.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read ASN1InputStream", e);
        }
        if (oct instanceof ASN1TaggedObject) {
            oct = ((ASN1TaggedObject)oct).getBaseObject();
        }
        return ASN1Sequence.getInstance((Object)oct);
    }

    public static String getPartFromDN(String dn, String dnpart) {
        log.fine(">getPartFromDN: dn:'" + dn + "', dnpart=" + dnpart);
        String part = null;
        if (dn != null && dnpart != null) {
            dnpart = dnpart + "=";
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken();
                if (o.length() <= dnpart.length() || !o.substring(0, dnpart.length()).equalsIgnoreCase(dnpart)) continue;
                part = o.substring(dnpart.length());
                break;
            }
        }
        log.fine("<getpartFromDN: resulting DN part=" + part);
        return part;
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        log.fine(">isSelfSigned: cert: " + CertUtils.getIssuer(cert) + "\n" + CertUtils.getSubject(cert));
        boolean ret = CertUtils.getSubject(cert).equals(CertUtils.getIssuer(cert));
        log.fine("<isSelfSigned:" + ret);
        return ret;
    }

    public static List<X509Certificate> buildCertificateChain(Collection<X509Certificate> certificates) throws GeneralSecurityException {
        ArrayList<X509Certificate> resultChain = new ArrayList<X509Certificate>();
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>(certificates);
        if (certificateList.size() == 1) {
            if (CertUtils.isSelfSigned((X509Certificate)certificateList.get(0))) {
                resultChain.add((X509Certificate)certificateList.get(0));
                return resultChain;
            }
            throw new GeneralSecurityException("Bad Certificate chain: certificate chain in not complete");
        }
        if (certificateList.size() == 0) {
            throw new GeneralSecurityException("Bad Certificate chain: certificate chain in empty");
        }
        HashSet<X509Certificate> rootCAs = new HashSet<X509Certificate>();
        HashSet<X509Certificate> subCAs = new HashSet<X509Certificate>();
        X509Certificate cert = null;
        boolean certExists = false;
        for (X509Certificate certificate : certificates) {
            if (CertUtils.isSelfSigned(certificate)) {
                rootCAs.add(certificate);
                continue;
            }
            boolean isSubCa = false;
            for (X509Certificate c : certificates) {
                if (!CertUtils.getIssuer(c).equalsIgnoreCase(CertUtils.getSubject(certificate))) continue;
                isSubCa = true;
                subCAs.add(certificate);
                break;
            }
            if (!isSubCa && !certExists) {
                cert = certificate;
                certExists = true;
                continue;
            }
            if (isSubCa || !certExists) continue;
            throw new GeneralSecurityException("Bad Certificate chain: more than one end certificates exist in the chain.");
        }
        if (rootCAs.isEmpty() && (!subCAs.isEmpty() || cert != null)) {
            throw new GeneralSecurityException("Bad Certificate chain: Root CA does not exist in the chain.");
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustCertificate : rootCAs) {
            trustAnchors.add(new TrustAnchor(trustCertificate, null));
        }
        subCAs.add(cert);
        CertStore subCAStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(subCAs), "BC");
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.addCertStore(subCAStore);
        pkixParams.setRevocationEnabled(false);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
        PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(pkixParams);
        for (Certificate certificate : result.getCertPath().getCertificates()) {
            resultChain.add((X509Certificate)certificate);
        }
        int subCAChainlength = resultChain.size();
        for (X509Certificate rootCA : rootCAs) {
            if (!CertUtils.getIssuer((X509Certificate)resultChain.get(subCAChainlength - 1)).equalsIgnoreCase(CertUtils.getSubject(rootCA))) continue;
            resultChain.add(rootCA);
            break;
        }
        return resultChain;
    }

    public static List<X509Certificate> getCertificateChainfromPem(byte[] certChain) throws CertificateException, IOException {
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        try (BufferedReader bufRdr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certChain)));){
            String temp;
            while ((temp = bufRdr.readLine()) != null) {
                while (temp != null && !temp.equals(BEGIN_CERTIFICATE)) {
                    temp = bufRdr.readLine();
                }
                if (temp == null) {
                    if (ret.isEmpty()) {
                        throw new IOException("Error in input buffer, missing -----BEGIN CERTIFICATE----- boundary");
                    }
                    break;
                }
                try (ByteArrayOutputStream ostr = new ByteArrayOutputStream();
                     PrintStream opstr = new PrintStream(ostr, true);){
                    while ((temp = bufRdr.readLine()) != null && !temp.equals(END_CERTIFICATE)) {
                        opstr.print(temp);
                    }
                    if (temp == null) {
                        throw new IOException("Error in input buffer, missing -----END CERTIFICATE----- boundary");
                    }
                    byte[] certbuf = Base64.decode((byte[])ostr.toByteArray());
                    X509Certificate certificate = CertUtils.getCertfromByteArray(certbuf);
                    ret.add(certificate);
                }
            }
        }
        return ret;
    }

    public static int getPublicKeyLengthFromCertificate(Certificate certificate) throws CertificateException {
        int bitLength = -1;
        if (certificate == null) {
            throw new NullPointerException("Certificate is null");
        }
        try {
            if (certificate.getPublicKey() instanceof RSAPublicKey) {
                bitLength = ((RSAPublicKey)certificate.getPublicKey()).getModulus().bitLength();
            } else if (certificate.getPublicKey() instanceof ECPublicKey) {
                bitLength = ((ECPublicKey)certificate.getPublicKey()).getParams().getCurve().getField().getFieldSize();
            } else if (certificate.getPublicKey() instanceof DSAPublicKey) {
                bitLength = ((DSAPublicKey)certificate.getPublicKey()).getParams().getP().bitLength();
            }
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        return bitLength;
    }
}

