/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.v2x.registration;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.v2x.registration.jaxb.ATAppPermissionsType;
import org.certificateservices.messages.v2x.registration.jaxb.AppPermissionsType;
import org.certificateservices.messages.v2x.registration.jaxb.BaseRegisterRequestType;
import org.certificateservices.messages.v2x.registration.jaxb.BaseV2XResponseType;
import org.certificateservices.messages.v2x.registration.jaxb.CanonicalKeyType;
import org.certificateservices.messages.v2x.registration.jaxb.DeactivateITSSRequest;
import org.certificateservices.messages.v2x.registration.jaxb.DeactivateITSSResponse;
import org.certificateservices.messages.v2x.registration.jaxb.EnrolmentCredentialType;
import org.certificateservices.messages.v2x.registration.jaxb.EnrolmentCredentialsType;
import org.certificateservices.messages.v2x.registration.jaxb.GetITSSDataRequest;
import org.certificateservices.messages.v2x.registration.jaxb.GetITSSDataResponse;
import org.certificateservices.messages.v2x.registration.jaxb.ITSSStatusType;
import org.certificateservices.messages.v2x.registration.jaxb.ObjectFactory;
import org.certificateservices.messages.v2x.registration.jaxb.ReactivateITSSRequest;
import org.certificateservices.messages.v2x.registration.jaxb.ReactivateITSSResponse;
import org.certificateservices.messages.v2x.registration.jaxb.RegionsType;
import org.certificateservices.messages.v2x.registration.jaxb.RegisterITSSRequest;
import org.certificateservices.messages.v2x.registration.jaxb.RegisterITSSResponse;
import org.certificateservices.messages.v2x.registration.jaxb.UpdateITSSRequest;
import org.certificateservices.messages.v2x.registration.jaxb.UpdateITSSResponse;

public class V2XPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/v2x_registration_2_0";
    public static final String V2X_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/v2x_registration_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_V2X_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_V2X_VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.v2x.registration.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_V2X_VERSION)) {
            return this.getClass().getResourceAsStream(V2X_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported SysConfig Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_V2X_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_V2X_VERSION;
    }

    public byte[] generateRegisterITSSRequest(String requestId, String destinationId, String organisation, String ecuType, String canonicalId, byte[] canonicalSignPubKey, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RegisterITSSRequest payload = this.of.createRegisterITSSRequest();
        payload.setEcuType(ecuType);
        payload.setCanonicalId(canonicalId);
        payload.setEaName(eaName);
        payload.setCanonicalPublicKey(this.createCanonicalKeyType(canonicalSignPubKey));
        ATAppPermissionsType atAppPermissionsType = this.of.createATAppPermissionsType();
        atAppPermissionsType.getAppPermission().addAll(atAppPermissions);
        payload.setAtPermissions(atAppPermissionsType);
        this.populateBaseRegisterRequestType(payload, canonicalId, ecProfile, atProfile, itssValidFrom, itssValidTo, regions);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateRegisterITSSResponse(String relatedEndEntity, CSMessage request, String ecuType, String canonicalId, CanonicalKeyType canonicalKey, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, ITSSStatusType itsStatus) throws MessageContentException, MessageProcessingException {
        RegisterITSSResponse payload = this.of.createRegisterITSSResponse();
        this.populateBaseV2XResponseType(payload, ecuType, canonicalId, canonicalKey, eaName, ecProfile, atProfile, atAppPermissions, itssValidFrom, itssValidTo, regions, itsStatus);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public CSMessageResponseData generateRegisterITSSResponse(String relatedEndEntity, CSMessage request, RegisterITSSResponse payload) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public byte[] generateUpdateITSSRequest(String requestId, String destinationId, String organisation, String ecuType, String canonicalId, byte[] canonicalSignPubKey, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        UpdateITSSRequest payload = this.of.createUpdateITSSRequest();
        payload.setEaName(eaName);
        payload.setEcuType(ecuType);
        payload.setCanonicalPublicKey(this.createCanonicalKeyType(canonicalSignPubKey));
        if (atAppPermissions != null) {
            ATAppPermissionsType atAppPermissionsType = this.of.createATAppPermissionsType();
            atAppPermissionsType.getAppPermission().addAll(atAppPermissions);
            payload.setAtPermissions(atAppPermissionsType);
        }
        this.populateBaseRegisterRequestType(payload, canonicalId, ecProfile, atProfile, itssValidFrom, itssValidTo, regions);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateUpdateITSSResponse(String relatedEndEntity, CSMessage request, String ecuType, String canonicalId, CanonicalKeyType canonicalKey, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, ITSSStatusType itsStatus) throws MessageContentException, MessageProcessingException {
        UpdateITSSResponse payload = this.of.createUpdateITSSResponse();
        this.populateBaseV2XResponseType(payload, ecuType, canonicalId, canonicalKey, eaName, ecProfile, atProfile, atAppPermissions, itssValidFrom, itssValidTo, regions, itsStatus);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public CSMessageResponseData generateUpdateITSSResponse(String relatedEndEntity, CSMessage request, UpdateITSSResponse payload) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public byte[] generateGetITSSDataRequest(String requestId, String destinationId, String organisation, String canonicalId, boolean includeEC, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetITSSDataRequest payload = this.of.createGetITSSDataRequest();
        payload.setCanonicalId(canonicalId);
        if (includeEC) {
            payload.setIncludeEC(includeEC);
        }
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateGetITSSDataResponse(String relatedEndEntity, CSMessage request, String ecuType, String canonicalId, CanonicalKeyType canonicalKeyType, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, ITSSStatusType itsStatus, List<EnrolmentCredentialType> enrolmentCredentials) throws MessageContentException, MessageProcessingException {
        GetITSSDataResponse payload = this.of.createGetITSSDataResponse();
        this.populateBaseV2XResponseType(payload, ecuType, canonicalId, canonicalKeyType, eaName, ecProfile, atProfile, atAppPermissions, itssValidFrom, itssValidTo, regions, itsStatus);
        if (enrolmentCredentials != null) {
            EnrolmentCredentialsType enrolmentCredentialsType = this.of.createEnrolmentCredentialsType();
            enrolmentCredentialsType.getEc().addAll(enrolmentCredentials);
            payload.setEnrolmentCredentials(enrolmentCredentialsType);
        }
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public CSMessageResponseData generateGetITSSDataResponse(String relatedEndEntity, CSMessage request, GetITSSDataResponse payload) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public byte[] generateDeactivateITSSRequest(String requestId, String destinationId, String organisation, String canonicalId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        DeactivateITSSRequest payload = this.of.createDeactivateITSSRequest();
        payload.setCanonicalId(canonicalId);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateDeactivateITSSResponse(String relatedEndEntity, CSMessage request, String ecuType, String canonicalId, CanonicalKeyType canonicalKey, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, ITSSStatusType itsStatus) throws MessageContentException, MessageProcessingException {
        DeactivateITSSResponse payload = this.of.createDeactivateITSSResponse();
        this.populateBaseV2XResponseType(payload, ecuType, canonicalId, canonicalKey, eaName, ecProfile, atProfile, atAppPermissions, itssValidFrom, itssValidTo, regions, itsStatus);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public CSMessageResponseData generateDeactivateITSSResponse(String relatedEndEntity, CSMessage request, DeactivateITSSResponse payload) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public byte[] generateReactivateITSSRequest(String requestId, String destinationId, String organisation, String canonicalId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ReactivateITSSRequest payload = this.of.createReactivateITSSRequest();
        payload.setCanonicalId(canonicalId);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateReactivateITSSResponse(String relatedEndEntity, CSMessage request, String ecuType, String canonicalId, CanonicalKeyType canonicalKey, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, ITSSStatusType itsStatus) throws MessageContentException, MessageProcessingException {
        ReactivateITSSResponse payload = this.of.createReactivateITSSResponse();
        this.populateBaseV2XResponseType(payload, ecuType, canonicalId, canonicalKey, eaName, ecProfile, atProfile, atAppPermissions, itssValidFrom, itssValidTo, regions, itsStatus);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public CSMessageResponseData generateReactivateITSSResponse(String relatedEndEntity, CSMessage request, ReactivateITSSResponse payload) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    private void populateBaseV2XResponseType(BaseV2XResponseType payload, String ecuType, String canonicalId, CanonicalKeyType canonicalKeyType, String eaName, String ecProfile, String atProfile, List<AppPermissionsType> atAppPermissions, Date itssValidFrom, Date itssValidTo, RegionsType regions, ITSSStatusType itssStatus) throws MessageProcessingException {
        payload.setEcuType(ecuType);
        payload.setCanonicalId(canonicalId);
        payload.setCanonicalPublicKey(canonicalKeyType);
        payload.setEaName(eaName);
        payload.setEcProfile(ecProfile);
        payload.setAtProfile(atProfile);
        if (atAppPermissions != null) {
            ATAppPermissionsType atAppPermissionsType = this.of.createATAppPermissionsType();
            atAppPermissionsType.getAppPermission().addAll(atAppPermissions);
            payload.setAtPermissions(atAppPermissionsType);
        }
        if (itssValidFrom != null) {
            payload.setItssValidFrom(MessageGenerateUtils.dateToXMLGregorianCalendar(itssValidFrom));
        }
        if (itssValidTo != null) {
            payload.setItssValidTo(MessageGenerateUtils.dateToXMLGregorianCalendar(itssValidTo));
        }
        payload.setRegions(regions);
        payload.setItssStatus(itssStatus);
    }

    private void populateBaseRegisterRequestType(BaseRegisterRequestType payload, String canonicalId, String ecProfile, String atProfile, Date itssValidFrom, Date itssValidTo, RegionsType regions) throws MessageProcessingException {
        payload.setCanonicalId(canonicalId);
        payload.setEcProfile(ecProfile);
        payload.setAtProfile(atProfile);
        if (itssValidFrom != null) {
            payload.setItssValidFrom(MessageGenerateUtils.dateToXMLGregorianCalendar(itssValidFrom));
        }
        if (itssValidTo != null) {
            payload.setItssValidTo(MessageGenerateUtils.dateToXMLGregorianCalendar(itssValidTo));
        }
        payload.setRegions(regions);
    }

    private CanonicalKeyType createCanonicalKeyType(byte[] canonicalSignPubKey) {
        CanonicalKeyType canonicalKeyType = this.of.createCanonicalKeyType();
        canonicalKeyType.setPublicVerificationKey(canonicalSignPubKey);
        return canonicalKeyType;
    }
}

