/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.assertion;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.AssertionData;
import org.certificateservices.messages.assertion.AssertionPayloadParser;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeStatementType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeType;
import org.certificateservices.messages.saml2.assertion.jaxb.StatementAbstractType;

public class AuthorizationAssertionData
extends AssertionData {
    private List<String> roles;
    private List<String> departments;

    public AuthorizationAssertionData(AssertionPayloadParser assertionPayloadParser) {
        super(assertionPayloadParser);
    }

    @Override
    public void parse(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        this.parseCommonData(assertion);
        try {
            for (StatementAbstractType nextStatement : ((AssertionType)assertion.getValue()).getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(nextStatement instanceof AttributeStatementType)) continue;
                for (Object attr : ((AttributeStatementType)nextStatement).getAttributeOrEncryptedAttribute()) {
                    if (!(attr instanceof AttributeType)) continue;
                    if (((AttributeType)attr).getName().equals("Roles")) {
                        this.roles = new ArrayList<String>();
                        for (Object next : ((AttributeType)attr).getAttributeValue()) {
                            if (!(next instanceof String)) continue;
                            this.roles.add((String)next);
                        }
                    }
                    if (!((AttributeType)attr).getName().equals("Departments")) continue;
                    this.departments = new ArrayList<String>();
                    for (Object next : ((AttributeType)attr).getAttributeValue()) {
                        if (!(next instanceof String)) continue;
                        this.departments.add((String)next);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing Authorization Assertion: " + e.getMessage(), e);
        }
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getDepartments() {
        return this.departments;
    }

    public String toString() {
        return "AuthorizationAssertionData [roles=" + this.roles + ", departments=" + this.departments + ", id=" + this.getId() + ", notBefore=" + this.getNotBefore() + ", notOnOrAfter=" + this.getNotOnOrAfter() + ", subjectId=" + this.getSubjectId() + ", signCertificate=" + this.getSignCertificate().toString() + "]";
    }
}

