/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.heartbeat;

import java.util.Date;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.heartbeat.HealthStatus;

public class MonitoringPoint {
    public static String MONITORING_POINT_ID_OVERALL_HEALTH = "HEALTH";
    private String monitoringPointId;
    private Date timestamp;
    private HealthStatus status;
    private String description;
    private Long currentThroughput;
    private Long maxThroughput;
    private String throughputUnits;

    public MonitoringPoint(String monitoringPointId, Date timestamp, HealthStatus status) throws MessageContentException {
        if (monitoringPointId == null || monitoringPointId.equals("")) {
            throw new MessageContentException("Error creating monitoring point in heart beat message, the monitoring point id cannot be null or empty");
        }
        if (timestamp == null) {
            throw new MessageContentException("Error creating monitoring point in heart beat message, time stamp cannot be null.");
        }
        if (status == null) {
            throw new MessageContentException("Error creating monitoring point in heart beat message, status cannot be null.");
        }
        this.monitoringPointId = monitoringPointId;
        this.timestamp = timestamp;
        this.status = status;
    }

    public MonitoringPoint(String monitoringPointId, Date timestamp, HealthStatus status, String description) throws MessageContentException {
        this(monitoringPointId, timestamp, status);
        this.description = description;
    }

    public MonitoringPoint(String monitoringPointId, Date timestamp, HealthStatus status, String description, Long currentThroughput, Long maxThroughput, String throughputUnits) throws MessageContentException {
        this(monitoringPointId, timestamp, status, description);
        this.currentThroughput = currentThroughput;
        this.maxThroughput = maxThroughput;
        this.throughputUnits = throughputUnits;
    }

    public String getMonitoringPointId() {
        return this.monitoringPointId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public HealthStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getCurrentThroughput() {
        return this.currentThroughput;
    }

    public Long getMaxThroughput() {
        return this.maxThroughput;
    }

    public String getThroughputUnits() {
        return this.throughputUnits;
    }
}

