/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.assertion;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.AssertionData;
import org.certificateservices.messages.assertion.AssertionPayloadParser;
import org.certificateservices.messages.credmanagement.jaxb.FieldValue;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeStatementType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeType;
import org.certificateservices.messages.saml2.assertion.jaxb.StatementAbstractType;

public class UserDataAssertionData
extends AssertionData {
    private String displayName;
    private List<FieldValue> fieldValues;
    private String tokenType;

    public UserDataAssertionData(AssertionPayloadParser assertionPayloadParser) {
        super(assertionPayloadParser);
    }

    @Override
    public void parse(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        this.parseCommonData(assertion);
        try {
            for (StatementAbstractType nextStatement : ((AssertionType)assertion.getValue()).getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(nextStatement instanceof AttributeStatementType)) continue;
                for (Object attr : ((AttributeStatementType)nextStatement).getAttributeOrEncryptedAttribute()) {
                    if (!(attr instanceof AttributeType)) continue;
                    if (((AttributeType)attr).getName().equals("DisplayName")) {
                        this.displayName = (String)((AttributeType)attr).getAttributeValue().get(0);
                    }
                    if (((AttributeType)attr).getName().equals("TokenType")) {
                        this.tokenType = (String)((AttributeType)attr).getAttributeValue().get(0);
                    }
                    if (!((AttributeType)attr).getName().equals("UserData")) continue;
                    this.fieldValues = new ArrayList<FieldValue>();
                    for (Object next : ((AttributeType)attr).getAttributeValue()) {
                        if (!(next instanceof FieldValue)) continue;
                        this.fieldValues.add((FieldValue)next);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing User Data Assertion: " + e.getMessage(), e);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public List<FieldValue> getFieldValues() {
        return this.fieldValues;
    }

    public String toString() {
        return "ApprovalAssertionData [displayName=" + this.displayName + ", tokenType=" + this.tokenType + ", fieldValues=" + this.fieldValues + ", id=" + this.getId() + ", notBefore=" + this.getNotBefore() + ", notOnOrAfter=" + this.getNotOnOrAfter() + ", subjectId=" + this.getSubjectId() + ", signCertificate=" + this.getSignCertificate().toString() + "]";
    }
}

