/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.pkimessages;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.certificateservices.messages.MessageException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.pkimessages.DefaultMessageNameCatalogue;
import org.certificateservices.messages.pkimessages.MessageNameCatalogue;
import org.certificateservices.messages.pkimessages.PKIMessageGenerateUtils;
import org.certificateservices.messages.pkimessages.PKIMessageParser;
import org.certificateservices.messages.pkimessages.PKIMessageResponseData;
import org.certificateservices.messages.pkimessages.PKISettingsUtils;
import org.certificateservices.messages.pkimessages.X509DataOnlyKeySelector;
import org.certificateservices.messages.pkimessages.XSDLSInput;
import org.certificateservices.messages.pkimessages.jaxb.ChangeCredentialStatusRequest;
import org.certificateservices.messages.pkimessages.jaxb.ChangeCredentialStatusResponse;
import org.certificateservices.messages.pkimessages.jaxb.Credential;
import org.certificateservices.messages.pkimessages.jaxb.CredentialStatusList;
import org.certificateservices.messages.pkimessages.jaxb.FetchHardTokenDataRequest;
import org.certificateservices.messages.pkimessages.jaxb.FetchHardTokenDataResponse;
import org.certificateservices.messages.pkimessages.jaxb.GetCredentialRequest;
import org.certificateservices.messages.pkimessages.jaxb.GetCredentialResponse;
import org.certificateservices.messages.pkimessages.jaxb.GetCredentialStatusListRequest;
import org.certificateservices.messages.pkimessages.jaxb.GetCredentialStatusListResponse;
import org.certificateservices.messages.pkimessages.jaxb.GetIssuerCredentialsRequest;
import org.certificateservices.messages.pkimessages.jaxb.GetIssuerCredentialsResponse;
import org.certificateservices.messages.pkimessages.jaxb.IsIssuerRequest;
import org.certificateservices.messages.pkimessages.jaxb.IsIssuerResponse;
import org.certificateservices.messages.pkimessages.jaxb.IssueCredentialStatusListRequest;
import org.certificateservices.messages.pkimessages.jaxb.IssueCredentialStatusListResponse;
import org.certificateservices.messages.pkimessages.jaxb.IssueTokenCredentialsRequest;
import org.certificateservices.messages.pkimessages.jaxb.IssueTokenCredentialsResponse;
import org.certificateservices.messages.pkimessages.jaxb.ObjectFactory;
import org.certificateservices.messages.pkimessages.jaxb.Originator;
import org.certificateservices.messages.pkimessages.jaxb.PKIMessage;
import org.certificateservices.messages.pkimessages.jaxb.PKIResponse;
import org.certificateservices.messages.pkimessages.jaxb.RemoveCredentialRequest;
import org.certificateservices.messages.pkimessages.jaxb.RemoveCredentialResponse;
import org.certificateservices.messages.pkimessages.jaxb.RequestStatus;
import org.certificateservices.messages.pkimessages.jaxb.StoreHardTokenDataRequest;
import org.certificateservices.messages.pkimessages.jaxb.StoreHardTokenDataResponse;
import org.certificateservices.messages.pkimessages.jaxb.TokenRequest;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.SettingsUtils;
import org.certificateservices.messages.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultPKIMessageParser
implements PKIMessageParser {
    public static final String SETTING_SOURCEID = "pkimessage.sourceid";
    public static final String SETTING_SIGN = "pkimessage.sign";
    public static final String SETTING_REQUIRESIGNATURE = "pkimessage.requiresignature";
    public static final String SETTING_MESSAGE_NAME_CATALOGUE_IMPL = "pkimessage.messagenamecatalogue.impl";
    public static final String DEFAULT_MESSAGE_NAME_CATALOGUE_IMPL = DefaultMessageNameCatalogue.class.getName();
    private static final String PKIMESSAGE_VERSION_1_0 = "1.0";
    private static final String PKIMESSAGE_VERSION_1_1 = "1.1";
    private static final String PKIMESSAGE_XSD_SCHEMA_1_0_RESOURCE_LOCATION = "/pkimessages_schema1_0.xsd";
    private static final String PKIMESSAGE_XSD_SCHEMA_1_1_RESOURCE_LOCATION = "/pkimessages_schema1_1.xsd";
    private static final String PKIMESSAGE_XSD_SCHEMA_1_0_URI = "http://certificateservices.org/xsd/pkimessages1_0 pkimessages_schema1_0.xsd";
    private static final Map<String, String> pkiMessageSchemaMap = new HashMap<String, String>();
    private static final Map<String, String> pkiMessageSchemaUriMap;
    private static final String XMLDSIG_XSD_SCHEMA_RESOURCE_LOCATION = "/xmldsig-core-schema.xsd";
    private static final String[] SUPPORTED_PKIMESSAGE_VERSIONS;
    private Map<String, Marshaller> pkixMessageMarshallers = new HashMap<String, Marshaller>();
    private Map<String, Unmarshaller> pkixMessageUnmarshallers = new HashMap<String, Unmarshaller>();
    private ObjectFactory objectFactory = new ObjectFactory();
    private Properties properties = null;
    private MessageSecurityProvider securityProvider = null;
    private MessageNameCatalogue messageNameCatalogue = null;
    private String sourceId = null;
    private String defaultVersion = "1.1";
    private Boolean signMessages;
    private Boolean requireSignature;
    private JAXBContext jaxbContext = null;

    @Override
    public void init(MessageSecurityProvider securityProvider, Properties config) throws MessageException {
        this.properties = config;
        this.securityProvider = securityProvider;
        this.messageNameCatalogue = this.getMessageNameCatalogue(config);
        for (String version : SUPPORTED_PKIMESSAGE_VERSIONS) {
            this.getPKIMessageMarshaller(version);
            this.getPKIMessageUnmarshaller(version);
        }
        this.sourceId = SettingsUtils.getProperty(config, SETTING_SOURCEID, "csmessage.sourceid");
        if (this.sourceId == null || this.sourceId.trim().equals("")) {
            throw new MessageException("Error setting csmessage.sourceid must be set.");
        }
    }

    Marshaller createMarshaller(JAXBContext jaxbContext, String schemaLocation) throws JAXBException {
        Marshaller retval = jaxbContext.createMarshaller();
        retval.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
        retval.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return retval;
    }

    @Override
    public synchronized PKIMessage parseMessage(byte[] messageData) throws IllegalArgumentException, MessageException {
        try {
            String version = this.getVersionFromMessage(messageData);
            this.verifyPKIMessageVersion(version);
            Object object = this.getPKIMessageUnmarshaller(version).unmarshal((InputStream)new ByteArrayInputStream(messageData));
            this.validatePKIMessage(object, new String(messageData, "UTF-8"));
            return (PKIMessage)object;
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Error parsing PKI Message: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error parsing PKI Message: " + e.getMessage(), e);
        }
    }

    private void verifyPKIMessageVersion(String version) throws IllegalArgumentException {
        boolean foundVersion = false;
        for (String supportedVersion : SUPPORTED_PKIMESSAGE_VERSIONS) {
            if (!supportedVersion.equals(version)) continue;
            foundVersion = true;
            break;
        }
        if (!foundVersion) {
            throw new IllegalArgumentException("Error unsupported protocol version " + version);
        }
    }

    private void validatePKIMessage(Object object, String message) throws IllegalArgumentException, MessageException {
        if (!(object instanceof PKIMessage)) {
            throw new IllegalArgumentException("Error: parsed object not a PKI Message.");
        }
        PKIMessage pkiMessage = (PKIMessage)object;
        this.validatePKIMessageHeader(pkiMessage, message);
    }

    private void validatePKIMessageHeader(PKIMessage pkiMessage, String message) throws IllegalArgumentException, MessageException {
        this.validateSignature(message);
    }

    private void validateSignature(String message) throws IllegalArgumentException, MessageException {
        if (this.requireSignature()) {
            try {
                DocumentBuilder builder = XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
                Document doc = builder.parse(new InputSource(new StringReader(message)));
                Node signature = doc.getElementsByTagName("ds:Signature").item(0);
                if (signature == null) {
                    throw new IllegalArgumentException("Required digital signature not found in message.");
                }
                DOMValidateContext validationContext = new DOMValidateContext(new X509DataOnlyKeySelector(this.securityProvider), signature);
                validationContext.setIdAttributeNS(doc.getDocumentElement(), null, "ID");
                XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
                XMLSignature sig = signatureFactory.unmarshalXMLSignature(validationContext);
                if (!sig.validate(validationContext)) {
                    throw new IllegalArgumentException("Error, signed message didn't pass validation.");
                }
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (e instanceof MessageException) {
                    throw (MessageException)e;
                }
                throw new IllegalArgumentException("Error validating signature of message: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public byte[] genIssueTokenCredentialsRequest(String requestId, String destinationId, String organisation, TokenRequest tokenRequest, Credential originator) throws IllegalArgumentException, MessageException {
        IssueTokenCredentialsRequest payload = this.objectFactory.createIssueTokenCredentialsRequest();
        payload.setTokenRequest(tokenRequest);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genIssueTokenCredentialsResponse(String relatedEndEntity, PKIMessage request, List<Credential> credentials, List<Credential> revokedCredentials) throws IllegalArgumentException, MessageException {
        IssueTokenCredentialsRequest issueTokenCredentialsRequest = request.getPayload().getIssueTokenCredentialsRequest();
        if (issueTokenCredentialsRequest == null) {
            throw new IllegalArgumentException("Error IssueTokenCredentialsResponse requires a IssueTokenCredentialsRequest in request payload.");
        }
        IssueTokenCredentialsResponse payload = this.objectFactory.createIssueTokenCredentialsResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setTokenRequest(issueTokenCredentialsRequest.getTokenRequest());
        payload.setCredentials(new IssueTokenCredentialsResponse.Credentials());
        for (Credential cred : credentials) {
            payload.getCredentials().getCredential().add(cred);
        }
        if (revokedCredentials != null) {
            payload.setRevokedCredentials(new IssueTokenCredentialsResponse.Credentials());
            for (Credential cred : revokedCredentials) {
                payload.getRevokedCredentials().getCredential().add(cred);
            }
        }
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData, true);
    }

    @Override
    public byte[] genChangeCredentialStatusRequest(String requestId, String destinationId, String organisation, String issuerId, String serialNumber, int newCredentialStatus, String reasonInformation, Credential originator) throws IllegalArgumentException, MessageException {
        ChangeCredentialStatusRequest payload = this.objectFactory.createChangeCredentialStatusRequest();
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        payload.setNewCredentialStatus(newCredentialStatus);
        payload.setReasonInformation(reasonInformation);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genChangeCredentialStatusResponse(String relatedEndEntity, PKIMessage request, String issuerId, String serialNumber, int credentialStatus, String reasonInformation, Date revocationDate) throws IllegalArgumentException, MessageException {
        ChangeCredentialStatusRequest changeCredentialStatusRequest = request.getPayload().getChangeCredentialStatusRequest();
        if (changeCredentialStatusRequest == null) {
            throw new IllegalArgumentException("Error ChangeCredentialStatusResponse requires a ChangeCredentialStatusRequest in request payload.");
        }
        ChangeCredentialStatusResponse payload = this.objectFactory.createChangeCredentialStatusResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        payload.setCredentialStatus(credentialStatus);
        payload.setReasonInformation(reasonInformation);
        payload.setRevocationDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(revocationDate));
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData, true);
    }

    @Override
    public byte[] genGetCredentialRequest(String requestId, String destinationId, String organisation, String credentialSubType, String issuerId, String serialNumber, Credential originator) throws IllegalArgumentException, MessageException {
        GetCredentialRequest payload = this.objectFactory.createGetCredentialRequest();
        payload.setCredentialSubType(credentialSubType);
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genGetCredentialResponse(String relatedEndEntity, PKIMessage request, Credential credential) throws IllegalArgumentException, MessageException {
        GetCredentialRequest getCredentialRequest = request.getPayload().getGetCredentialRequest();
        if (getCredentialRequest == null) {
            throw new IllegalArgumentException("Error GetCredentialResponse requires a GetCredentialRequest in request payload.");
        }
        GetCredentialResponse payload = this.objectFactory.createGetCredentialResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setCredential(credential);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public byte[] genGetCredentialStatusListRequest(String requestId, String destinationId, String organisation, String issuerId, Long serialNumber, String credentialStatusListType, Credential originator) throws IllegalArgumentException, MessageException {
        GetCredentialStatusListRequest payload = this.objectFactory.createGetCredentialStatusListRequest();
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        payload.setCredentialStatusListType(credentialStatusListType);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genGetCredentialStatusListResponse(String relatedEndEntity, PKIMessage request, CredentialStatusList credentialStatusList) throws IllegalArgumentException, MessageException {
        GetCredentialStatusListRequest getCredentialStatusListRequest = request.getPayload().getGetCredentialStatusListRequest();
        if (getCredentialStatusListRequest == null) {
            throw new IllegalArgumentException("Error GetCredentialStatusListResponse requires a GetCredentialStatusListRequest in request payload.");
        }
        GetCredentialStatusListResponse payload = this.objectFactory.createGetCredentialStatusListResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setCredentialStatusList(credentialStatusList);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public byte[] genGetIssuerCredentialsRequest(String requestId, String destinationId, String organisation, String issuerId, Credential originator) throws IllegalArgumentException, MessageException {
        GetIssuerCredentialsRequest payload = this.objectFactory.createGetIssuerCredentialsRequest();
        payload.setIssuerId(issuerId);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genGetIssuerCredentialsResponse(String relatedEndEntity, PKIMessage request, Credential issuerCredential) throws IllegalArgumentException, MessageException {
        GetIssuerCredentialsRequest getIssuerCredentialsRequest = request.getPayload().getGetIssuerCredentialsRequest();
        if (getIssuerCredentialsRequest == null) {
            throw new IllegalArgumentException("Error GetIssuerCredentialsResponse requires a GetIssuerCredentialsRequest in request payload.");
        }
        GetIssuerCredentialsResponse payload = this.objectFactory.createGetIssuerCredentialsResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setCredential(issuerCredential);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public byte[] genIsIssuerRequest(String requestId, String destinationId, String organisation, String issuerId, Credential originator) throws IllegalArgumentException, MessageException {
        IsIssuerRequest payload = this.objectFactory.createIsIssuerRequest();
        payload.setIssuerId(issuerId);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genIsIssuerResponse(String relatedEndEntity, PKIMessage request, boolean isIssuer) throws IllegalArgumentException, MessageException {
        IsIssuerRequest isIssuerRequest = request.getPayload().getIsIssuerRequest();
        if (isIssuerRequest == null) {
            throw new IllegalArgumentException("Error IsIssuerResponse requires a IsIssuerRequest in request payload.");
        }
        IsIssuerResponse payload = this.objectFactory.createIsIssuerResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setIsIssuer(isIssuer);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public byte[] genIssueCredentialStatusListRequest(String requestId, String destinationId, String organisation, String issuerId, String credentialStatusListType, Boolean force, Date requestedValidFromDate, Date requestedNotAfterDate, Credential originator) throws IllegalArgumentException, MessageException {
        IssueCredentialStatusListRequest payload = this.objectFactory.createIssueCredentialStatusListRequest();
        payload.setIssuerId(issuerId);
        payload.setCredentialStatusListType(credentialStatusListType);
        payload.setForce(force);
        payload.setRequestedNotAfterDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(requestedNotAfterDate));
        payload.setRequestedValidFromDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(requestedValidFromDate));
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genIssueCredentialStatusListResponse(String relatedEndEntity, PKIMessage request, CredentialStatusList credentialStatusList) throws IllegalArgumentException, MessageException {
        IssueCredentialStatusListRequest issueCredentialStatusListRequest = request.getPayload().getIssueCredentialStatusListRequest();
        if (issueCredentialStatusListRequest == null) {
            throw new IllegalArgumentException("Error IssueCredentialStatusListResponse requires a IssueCredentialStatusListRequest in request payload.");
        }
        IssueCredentialStatusListResponse payload = this.objectFactory.createIssueCredentialStatusListResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setCredentialStatusList(credentialStatusList);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData, true);
    }

    @Override
    public PKIMessageResponseData genIssueCredentialStatusListResponseWithoutRequest(String relatedEndEntity, String destination, String name, String organisation, CredentialStatusList credentialStatusList, Credential originator) throws IllegalArgumentException, MessageException {
        String responseId = MessageGenerateUtils.generateRandomUUID();
        IssueCredentialStatusListResponse payload = this.objectFactory.createIssueCredentialStatusListResponse();
        payload.setFailureMessage(null);
        payload.setStatus(RequestStatus.SUCCESS);
        payload.setInResponseTo(responseId);
        payload.setCredentialStatusList(credentialStatusList);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, name, responseId, destination, organisation, originator, payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData, true);
    }

    @Override
    public byte[] genRemoveCredentialRequest(String requestId, String destinationId, String organisation, String issuerId, String serialNumber, Credential originator) throws IllegalArgumentException, MessageException {
        RemoveCredentialRequest payload = this.objectFactory.createRemoveCredentialRequest();
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genRemoveCredentialResponse(String relatedEndEntity, PKIMessage request) throws IllegalArgumentException, MessageException {
        RemoveCredentialRequest removeCredentialRequest = request.getPayload().getRemoveCredentialRequest();
        if (removeCredentialRequest == null) {
            throw new IllegalArgumentException("Error RemoveCredentialResponse requires a RemoveCredentialRequest in request payload.");
        }
        RemoveCredentialResponse payload = this.objectFactory.createRemoveCredentialResponse();
        this.populateSuccessfulResponse(payload, request);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public byte[] genFetchHardTokenDataRequest(String requestId, String destinationId, String organisation, String tokenSerial, String relatedCredentialSerialNumber, String relatedCredentialIssuerId, Credential adminCredential, Credential originator) throws IllegalArgumentException, MessageException {
        FetchHardTokenDataRequest payload = this.objectFactory.createFetchHardTokenDataRequest();
        payload.setTokenSerial(tokenSerial);
        payload.setRelatedCredentialSerialNumber(relatedCredentialSerialNumber);
        payload.setRelatedCredentialIssuerId(relatedCredentialIssuerId);
        payload.setAdminCredential(adminCredential);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genFetchHardTokenDataResponse(String relatedEndEntity, PKIMessage request, String tokenSerial, byte[] encryptedData) throws IllegalArgumentException, MessageException {
        FetchHardTokenDataRequest fetchHardTokenDataRequest = request.getPayload().getFetchHardTokenDataRequest();
        if (fetchHardTokenDataRequest == null) {
            throw new IllegalArgumentException("Error FetchHardTokenDataResponse requires a FetchHardTokenDataRequest in request payload.");
        }
        FetchHardTokenDataResponse payload = this.objectFactory.createFetchHardTokenDataResponse();
        this.populateSuccessfulResponse(payload, request);
        payload.setTokenSerial(tokenSerial);
        payload.setEncryptedData(encryptedData);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public byte[] genStoreHardTokenDataRequest(String requestId, String destinationId, String organisation, String tokenSerial, String relatedCredentialSerialNumber, String relatedCredentialIssuerId, byte[] encryptedData, Credential originator) throws IllegalArgumentException, MessageException {
        StoreHardTokenDataRequest payload = this.objectFactory.createStoreHardTokenDataRequest();
        payload.setTokenSerial(tokenSerial);
        payload.setRelatedCredentialSerialNumber(relatedCredentialSerialNumber);
        payload.setRelatedCredentialIssuerId(relatedCredentialIssuerId);
        payload.setEncryptedData(encryptedData);
        PKIMessage pkiMessage = this.genPKIMessage(this.defaultVersion, requestId, destinationId, organisation, originator, payload);
        return this.marshallAndSignPKIMessage(pkiMessage);
    }

    @Override
    public PKIMessageResponseData genStoreHardTokenDataResponse(String relatedEndEntity, PKIMessage request) throws IllegalArgumentException, MessageException {
        StoreHardTokenDataRequest storeHardTokenDataRequest = request.getPayload().getStoreHardTokenDataRequest();
        if (storeHardTokenDataRequest == null) {
            throw new IllegalArgumentException("Error StoreHardTokenDataResponse requires a StoreHardTokenDataRequest in request payload.");
        }
        StoreHardTokenDataResponse payload = this.objectFactory.createStoreHardTokenDataResponse();
        this.populateSuccessfulResponse(payload, request);
        PKIMessage pkiMessage = this.genPKIMessage(request.getVersion(), request.getName(), null, request.getSourceId(), request.getOrganisation(), DefaultPKIMessageParser.getOriginatorFromRequest(request), payload);
        byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
        return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData);
    }

    @Override
    public PKIMessageResponseData genPKIResponse(String relatedEndEntity, byte[] request, RequestStatus status, String failureMessage, Credential originator) throws IllegalArgumentException, MessageException {
        return this.genPKIResponse(relatedEndEntity, request, status, failureMessage, null, originator);
    }

    @Override
    public PKIMessageResponseData genPKIResponse(String relatedEndEntity, byte[] request, RequestStatus status, String failureMessage, String destinationID, Credential originator) throws IllegalArgumentException, MessageException {
        try {
            XPathExpression expr;
            Object result;
            Node versionNode;
            DocumentBuilder builder = XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(request));
            Node pkiMessageNode = doc.getFirstChild();
            String version = null;
            if (pkiMessageNode != null && (versionNode = pkiMessageNode.getAttributes().getNamedItem("version")) != null) {
                version = versionNode.getNodeValue();
            }
            if (version == null || version.trim().equals("")) {
                throw new IllegalArgumentException("Error unsupported protocol version when generating PKIResponse, version: " + version);
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            if (destinationID == null && (result = (String)(expr = xpath.compile("//*[local-name()='sourceId']/text()")).evaluate(doc, XPathConstants.STRING)) != null) {
                destinationID = result;
            }
            expr = xpath.compile("//*[local-name()='PKIMessage']/@ID");
            result = expr.evaluate(doc, XPathConstants.STRING);
            String responseToRequestID = (String)result;
            expr = xpath.compile("//*[local-name()='organisation']/text()");
            result = expr.evaluate(doc, XPathConstants.STRING);
            String organisation = (String)result;
            expr = xpath.compile("//*[local-name()='name']/text()");
            result = expr.evaluate(doc, XPathConstants.STRING);
            String requestName = (String)result;
            if (organisation == null || responseToRequestID == null || destinationID == null || requestName == null) {
                throw new IllegalArgumentException("Error generating PKI Message Response from request, due to missing fields organisation, sourceId, name or ID in request.");
            }
            PKIResponse payload = this.objectFactory.createPKIResponse();
            payload.setStatus(status);
            payload.setFailureMessage(failureMessage);
            payload.setInResponseTo(responseToRequestID);
            PKIMessage pkiMessage = this.genPKIMessage(version, requestName, null, (String)destinationID, organisation, originator, payload);
            byte[] responseData = this.marshallAndSignPKIMessage(pkiMessage);
            return new PKIMessageResponseData(pkiMessage.getID(), pkiMessage.getName(), relatedEndEntity, pkiMessage.getDestinationId(), responseData, false);
        }
        catch (ParserConfigurationException e) {
            throw new MessageException("Error configuring the XML SAX Parser : " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Error parsing request XML message: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MessageException("Error reading the XML request data : " + e.getMessage());
        }
        catch (XPathExpressionException e) {
            throw new MessageException("Error constructing XPath expression when generating PKI Message responses : " + e.getMessage());
        }
    }

    @Override
    public X509Certificate getSigningCertificate(byte[] request) throws IllegalArgumentException, MessageException {
        X509Certificate retval = null;
        if (this.requireSignature()) {
            try {
                DocumentBuilder builder = XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(request));
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                XPathExpression expr = xpath.compile("//*[local-name()='KeyInfo']/*[local-name()='X509Data']/*[local-name()='X509Certificate']/text()");
                String result = (String)expr.evaluate(doc, XPathConstants.STRING);
                if (result != null && !result.equals("")) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    retval = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.decode((byte[])result.getBytes())));
                }
            }
            catch (CertificateException builder) {
            }
            catch (ParserConfigurationException e) {
                throw new MessageException("Error building XPath Expression when fetching signing certificate: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new IllegalArgumentException("Error reading signing certificate found in PKI Message request: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error reading signing certificate found in PKI Message request: " + e.getMessage(), e);
            }
            catch (XPathExpressionException e) {
                throw new MessageException("Error building XPath Expression when fetching signing certificate: " + e.getMessage(), e);
            }
            catch (Base64DecodingException e) {
                throw new MessageException("Error reading signing certificate base 64 decoding exception: " + e.getMessage(), e);
            }
            if (retval == null) {
                throw new IllegalArgumentException("Error, no signing certificate found in PKI Message request.");
            }
        }
        return retval;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    private PKIMessage genPKIMessage(String version, String messageId, String destinationID, String organisation, Credential originator, Object payload) throws IllegalArgumentException, MessageException {
        return this.genPKIMessage(version, null, messageId, destinationID, organisation, originator, payload);
    }

    private PKIMessage genPKIMessage(String version, String requestName, String messageId, String destinationID, String organisation, Credential originator, Object payload) throws IllegalArgumentException, MessageException {
        PKIMessage retval = this.objectFactory.createPKIMessage();
        retval.setVersion(version);
        if (messageId == null) {
            retval.setID(MessageGenerateUtils.generateRandomUUID());
        } else {
            retval.setID(messageId);
        }
        retval.setTimeStamp(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date()));
        retval.setName(this.messageNameCatalogue.lookupName(requestName, payload));
        retval.setDestinationId(destinationID);
        retval.setSourceId(this.sourceId);
        retval.setOrganisation(organisation);
        if (originator != null) {
            Originator originatorElement = this.objectFactory.createOriginator();
            originatorElement.setCredential(originator);
            retval.setOriginator(originatorElement);
        }
        retval.setPayload(this.getPayLoadObject(payload));
        return retval;
    }

    private PKIMessage.Payload getPayLoadObject(Object payload) throws MessageException, IllegalArgumentException {
        try {
            PKIMessage.Payload retval = new PKIMessage.Payload();
            if (payload.getClass().getSimpleName().equals("PKIResponse")) {
                retval.setFailureResponse((PKIResponse)payload);
            } else {
                Method m = retval.getClass().getMethod("set" + payload.getClass().getSimpleName(), payload.getClass());
                m.invoke((Object)retval, payload);
            }
            return retval;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid payload object: " + payload.getClass().getSimpleName() + ", " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageException("Internal error populating payload object: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new MessageException("Internal error populating payload object: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new MessageException("Internal error populating payload object: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized byte[] marshallAndSignPKIMessage(PKIMessage pkiMessage) throws MessageException {
        if (pkiMessage == null) {
            throw new MessageException("Error marshalling PKI Message, message cannot be null.");
        }
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            String version = pkiMessage.getVersion();
            this.getPKIMessageMarshaller(version).marshal((Object)pkiMessage, (Node)doc);
            if (this.signMessages()) {
                XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
                DigestMethod digestMethod = fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
                ArrayList<Transform> transFormList = new ArrayList<Transform>();
                transFormList.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                Reference ref = fac.newReference("#" + pkiMessage.getID(), digestMethod, transFormList, null, null);
                ArrayList<Reference> refList = new ArrayList<Reference>();
                refList.add(ref);
                CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
                SignatureMethod sm = fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
                SignedInfo signedInfo = fac.newSignedInfo(cm, sm, refList);
                DOMSignContext signContext = null;
                signContext = new DOMSignContext(this.securityProvider.getSigningKey(), (Node)doc.getDocumentElement());
                signContext.setIdAttributeNS(doc.getDocumentElement(), null, "ID");
                KeyInfoFactory kif = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                X509Certificate cert = this.securityProvider.getSigningCertificate();
                certs.add(cert);
                X509Data x509Data = kif.newX509Data(certs);
                KeyInfo ki = kif.newKeyInfo(Collections.singletonList(x509Data));
                XMLSignature signature = fac.newXMLSignature(signedInfo, ki);
                signature.sign(signContext);
                Node signatureElement = doc.getElementsByTagName("Signature").item(0);
                signatureElement.setPrefix("ds");
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (MessageProcessingException e) {
            throw new MessageException("Error marshalling PKI Message, " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageException("Error marshalling PKI Message, " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageException("Error marshalling PKI Message, " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageException("Error marshalling PKI Message, " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageException("Error marshalling PKI Message, " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MessageException("Error signing the PKI Message, " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MessageException("Error signing the PKI Message, " + e.getMessage(), e);
        }
        catch (MarshalException e) {
            throw new MessageException("Error signing the PKI Message, " + e.getMessage(), e);
        }
        catch (XMLSignatureException e) {
            throw new MessageException("Error signing the PKI Message, " + e.getMessage(), e);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
    }

    private boolean signMessages() throws MessageException {
        if (this.signMessages == null) {
            this.signMessages = PKISettingsUtils.parseBooleanWithDefault(this.properties, SETTING_SIGN, true);
        }
        return this.signMessages;
    }

    private boolean requireSignature() throws MessageException {
        if (this.requireSignature == null) {
            this.requireSignature = PKISettingsUtils.parseBooleanWithDefault(this.properties, SETTING_REQUIRESIGNATURE, true);
        }
        return this.requireSignature;
    }

    private void populateSuccessfulResponse(PKIResponse response, PKIMessage request) {
        response.setFailureMessage(null);
        response.setStatus(RequestStatus.SUCCESS);
        response.setInResponseTo(request.getID());
    }

    private MessageNameCatalogue getMessageNameCatalogue(Properties config) throws MessageException {
        try {
            MessageNameCatalogue retval = (MessageNameCatalogue)this.getClass().getClassLoader().loadClass(config.getProperty(SETTING_MESSAGE_NAME_CATALOGUE_IMPL, DEFAULT_MESSAGE_NAME_CATALOGUE_IMPL)).newInstance();
            retval.init(config);
            return retval;
        }
        catch (Exception e) {
            throw new MessageException("Error creating creating name catalogue " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private String getVersionFromMessage(byte[] messageData) throws IllegalArgumentException, MessageException {
        String retval = null;
        try {
            Node versionNode;
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(messageData));
            Node pkiMessage = doc.getFirstChild();
            if (pkiMessage != null && (versionNode = pkiMessage.getAttributes().getNamedItem("version")) != null) {
                retval = versionNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing XML data: " + e.getMessage(), e);
        }
        if (retval == null || retval.trim().equals("")) {
            throw new IllegalArgumentException("Error no version attribute found in PKI Message.");
        }
        return retval;
    }

    private Marshaller getPKIMessageMarshaller(String version) throws MessageException {
        if (version == null) {
            throw new IllegalArgumentException("Invalid PKI Message, version is missing.");
        }
        Marshaller retval = this.pkixMessageMarshallers.get(version);
        if (retval == null) {
            String schemaURL = pkiMessageSchemaUriMap.get(version);
            try {
                retval = this.createMarshaller(this.getJAXBContext(), schemaURL);
                retval.setSchema(this.generatePKIMessageSchema(version));
                this.pkixMessageMarshallers.put(version, retval);
            }
            catch (Exception e) {
                throw new MessageException("Error creating XML Marshaller for PKI Message version: " + version, e);
            }
        }
        return retval;
    }

    public static Credential getOriginatorFromRequest(PKIMessage request) {
        Credential retval = null;
        if (request != null && request.getOriginator() != null) {
            retval = request.getOriginator().getCredential();
        }
        return retval;
    }

    private Unmarshaller getPKIMessageUnmarshaller(String version) throws MessageException {
        if (version == null) {
            throw new IllegalArgumentException("Invalid PKI Message, version is missing.");
        }
        Unmarshaller retval = this.pkixMessageUnmarshallers.get(version);
        if (retval == null) {
            try {
                retval = this.jaxbContext.createUnmarshaller();
                retval.setSchema(this.generatePKIMessageSchema(version));
                this.pkixMessageUnmarshallers.put(version, retval);
            }
            catch (Exception e) {
                throw new MessageException("Error creating XML Unmarshaller for PKI Message version: " + version);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema generatePKIMessageSchema(String version) throws IllegalArgumentException, SAXException, MessageException {
        String schemaLocation = pkiMessageSchemaMap.get(version);
        URL xsdURL = this.getClass().getResource(schemaLocation);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL xsdURL2 = this.getClass().getResource(XMLDSIG_XSD_SCHEMA_RESOURCE_LOCATION);
        String xsdContent = null;
        try {
            InputStream resourceAsStream;
            InputStream inputStream = resourceAsStream = xsdURL2.openStream();
            synchronized (inputStream) {
                byte[] i = new byte[resourceAsStream.available()];
                resourceAsStream.read(i);
                xsdContent = new String(i);
            }
        }
        catch (IOException e) {
            throw new MessageException("Error reading DigSig XSD config");
        }
        final String digSigXSD = xsdContent;
        schemaFactory.setResourceResolver(new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                if (systemId.contains("xmldsig-core-schema.xsd")) {
                    return new XSDLSInput(publicId, systemId, digSigXSD);
                }
                return null;
            }
        });
        Schema schema = schemaFactory.newSchema(xsdURL);
        return schema;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)"org.certificateservices.messages.pkimessages.jaxb");
        }
        return this.jaxbContext;
    }

    static {
        pkiMessageSchemaMap.put(PKIMESSAGE_VERSION_1_0, PKIMESSAGE_XSD_SCHEMA_1_0_RESOURCE_LOCATION);
        pkiMessageSchemaMap.put(PKIMESSAGE_VERSION_1_1, PKIMESSAGE_XSD_SCHEMA_1_1_RESOURCE_LOCATION);
        pkiMessageSchemaUriMap = new HashMap<String, String>();
        pkiMessageSchemaUriMap.put(PKIMESSAGE_VERSION_1_0, PKIMESSAGE_XSD_SCHEMA_1_0_URI);
        pkiMessageSchemaUriMap.put(PKIMESSAGE_VERSION_1_1, PKIMESSAGE_XSD_SCHEMA_1_0_URI);
        SUPPORTED_PKIMESSAGE_VERSIONS = new String[]{PKIMESSAGE_VERSION_1_0, PKIMESSAGE_VERSION_1_1};
    }
}

