/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.util.Properties;
import org.certificateservices.messages.MessageProcessingException;

public class SettingsUtils {
    public static Boolean parseBoolean(Properties config, String setting, boolean required) throws MessageProcessingException {
        return SettingsUtils.parseBoolean(config, setting, null, required);
    }

    public static Boolean parseBoolean(Properties config, String setting, String alternativeSetting, boolean required) throws MessageProcessingException {
        String value = config.getProperty(setting, alternativeSetting != null ? config.getProperty(alternativeSetting, "") : "");
        if (value == null || value.trim().equals("")) {
            if (required) {
                throw new MessageProcessingException("Error parsing setting " + setting + ", a value must be set to either TRUE or FALSE");
            }
            return null;
        }
        if ((value = value.trim().toUpperCase()).equals("TRUE")) {
            return true;
        }
        if (value.equals("FALSE")) {
            return false;
        }
        throw new MessageProcessingException("Error parsing setting " + setting + ", value must be either TRUE or FALSE");
    }

    public static boolean parseBooleanWithDefault(Properties config, String setting, boolean defaultValue) throws MessageProcessingException {
        return SettingsUtils.parseBooleanWithDefault(config, setting, null, defaultValue);
    }

    public static boolean parseBooleanWithDefault(Properties config, String setting, String alternativeSetting, boolean defaultValue) throws MessageProcessingException {
        Boolean retval = SettingsUtils.parseBoolean(config, setting, alternativeSetting, false);
        if (retval == null) {
            return defaultValue;
        }
        return retval;
    }

    public static String[] parseStringArray(Properties config, String setting, String deliminator, String[] defaulValue) {
        return SettingsUtils.parseStringArray(config, setting, null, deliminator, defaulValue);
    }

    public static String[] parseStringArray(Properties config, String setting, String alternativeSetting, String deliminator, String[] defaulValue) {
        String value = config.getProperty(setting);
        if (value == null && alternativeSetting != null) {
            value = config.getProperty(alternativeSetting);
        }
        if (value == null || value.trim().equals("")) {
            return defaulValue;
        }
        String[] values = value.split(deliminator);
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public static String[] parseStringArray(Properties config, String setting, String deliminator, boolean required) throws MessageProcessingException {
        return SettingsUtils.parseStringArray(config, setting, null, deliminator, required);
    }

    public static String[] parseStringArray(Properties config, String setting, String alternativeSetting, String deliminator, boolean required) throws MessageProcessingException {
        String value = config.getProperty(setting);
        if (value == null && alternativeSetting != null) {
            value = config.getProperty(alternativeSetting);
        }
        if (value == null || value.trim().equals("")) {
            if (required) {
                throw new MessageProcessingException("Required setting " + setting + " not set.");
            }
            return new String[0];
        }
        String[] values = value.split(deliminator);
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public static String getRequiredProperty(Properties config, String key) throws MessageProcessingException {
        return SettingsUtils.getRequiredProperty(config, key, null);
    }

    public static String getRequiredProperty(Properties config, String key, String alternativeSettings) throws MessageProcessingException {
        String value = config.getProperty(key, alternativeSettings != null ? config.getProperty(alternativeSettings, "") : "");
        if (value.trim().equals("")) {
            throw new MessageProcessingException("Error required configuration property " + key + " not set.");
        }
        return value;
    }

    public static String getProperty(Properties config, String key, String alternativeSettings) {
        return config.getProperty(key, alternativeSettings != null ? config.getProperty(alternativeSettings, null) : null);
    }
}

