/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.assertion;

import jakarta.xml.bind.JAXBElement;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.AttributeQueryTypeEnum;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.saml2.protocol.jaxb.AttributeQueryType;

public class AttributeQueryData {
    protected String id;
    protected AttributeQueryTypeEnum type;
    protected String subjectId;
    protected String tokenType;

    public void parse(JAXBElement<AttributeQueryType> attributeQuery) throws MessageContentException, MessageProcessingException {
        try {
            this.id = ((AttributeQueryType)attributeQuery.getValue()).getID();
            for (JAXBElement<?> jAXBElement : ((AttributeQueryType)attributeQuery.getValue()).getSubject().getContent()) {
                if (!(jAXBElement instanceof JAXBElement) || !(jAXBElement.getValue() instanceof NameIDType)) continue;
                this.subjectId = ((NameIDType)jAXBElement.getValue()).getValue();
            }
            for (Object object : ((AttributeQueryType)attributeQuery.getValue()).getAttribute()) {
                if (!(object instanceof AttributeType)) continue;
                for (AttributeQueryTypeEnum t : AttributeQueryTypeEnum.values()) {
                    if (!((AttributeType)object).getName().equals(t.getAttributeValue())) continue;
                    this.type = t;
                    break;
                }
                if (!((AttributeType)object).getName().equals("TokenType") || ((AttributeType)object).getAttributeValue().size() <= 0) continue;
                this.tokenType = ((AttributeType)object).getAttributeValue().get(0).toString();
                break;
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing Attribute Query: " + e.getMessage(), e);
        }
        if (this.type == null) {
            throw new MessageContentException("Error parsing Attribute Query: couldn't determine type of attribute query");
        }
        if (this.subjectId == null || this.subjectId.trim().equals("")) {
            throw new MessageContentException("Error parsing Attribute Query: couldn't parse related subject Id");
        }
    }

    public String getID() {
        return this.id;
    }

    public AttributeQueryTypeEnum getType() {
        return this.type;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeQueryData other = (AttributeQueryData)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AttributeQueryData [id=" + this.id + ", type=" + (Object)((Object)this.type) + ", subjectId=" + this.subjectId + "]";
    }
}

