/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import jakarta.xml.bind.JAXBElement;
import java.util.Properties;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.MessageNameCatalogue;
import org.certificateservices.messages.utils.SettingsUtils;

public class DefaultMessageNameCatalogue
implements MessageNameCatalogue {
    private Properties properties;
    public static final String SETTING_MESSAGE_NAME_PREFIX = "csmessage.name.";
    public static final String OLD_SETTING_MESSAGE_NAME_PREFIX = "pkimessage.name.";

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String lookupName(String requestName, Object payLoadObject) throws MessageProcessingException, IllegalArgumentException {
        String altSetting;
        String setting;
        String configuredValue;
        if (payLoadObject == null) {
            throw new MessageProcessingException("Payload element cannot be null.");
        }
        String retval = payLoadObject.getClass().getSimpleName();
        if (payLoadObject instanceof JAXBElement) {
            retval = ((JAXBElement)payLoadObject).getName().getLocalPart();
        }
        if (retval.equals("CSResponse")) {
            retval = "FailureResponse";
        }
        if ((configuredValue = SettingsUtils.getProperty(this.properties, setting = SETTING_MESSAGE_NAME_PREFIX + payLoadObject.getClass().getSimpleName().toLowerCase(), altSetting = OLD_SETTING_MESSAGE_NAME_PREFIX + payLoadObject.getClass().getSimpleName().toLowerCase())) != null) {
            retval = configuredValue;
        }
        return retval;
    }
}

