/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.saml2.metadata;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.saml2.BaseSAMLMessageParser;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeType;
import org.certificateservices.messages.saml2.metadata.attr.jaxb.EntityAttributesType;
import org.certificateservices.messages.saml2.metadata.jaxb.AdditionalMetadataLocationType;
import org.certificateservices.messages.saml2.metadata.jaxb.AffiliationDescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.AttributeConsumingServiceType;
import org.certificateservices.messages.saml2.metadata.jaxb.ContactType;
import org.certificateservices.messages.saml2.metadata.jaxb.ContactTypeType;
import org.certificateservices.messages.saml2.metadata.jaxb.EndpointType;
import org.certificateservices.messages.saml2.metadata.jaxb.EntitiesDescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.EntityDescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.ExtensionsType;
import org.certificateservices.messages.saml2.metadata.jaxb.IDPSSODescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.IndexedEndpointType;
import org.certificateservices.messages.saml2.metadata.jaxb.KeyDescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.KeyTypes;
import org.certificateservices.messages.saml2.metadata.jaxb.LocalizedNameType;
import org.certificateservices.messages.saml2.metadata.jaxb.LocalizedURIType;
import org.certificateservices.messages.saml2.metadata.jaxb.ObjectFactory;
import org.certificateservices.messages.saml2.metadata.jaxb.OrganizationType;
import org.certificateservices.messages.saml2.metadata.jaxb.RequestedAttributeType;
import org.certificateservices.messages.saml2.metadata.jaxb.RoleDescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.SPSSODescriptorType;
import org.certificateservices.messages.saml2.metadata.jaxb.SSODescriptorType;
import org.certificateservices.messages.saml2.metadata.ui.jaxb.DiscoHintsType;
import org.certificateservices.messages.saml2.metadata.ui.jaxb.KeywordsType;
import org.certificateservices.messages.saml2.metadata.ui.jaxb.LogoType;
import org.certificateservices.messages.saml2.metadata.ui.jaxb.UIInfoType;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.XMLSigner;
import org.certificateservices.messages.xenc.jaxb.EncryptionMethodType;
import org.certificateservices.messages.xmldsig.jaxb.KeyInfoType;
import org.certificateservices.messages.xmldsig.jaxb.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAMLMetaDataMessageParser
extends BaseSAMLMessageParser {
    public static final String NAMESPACE = "urn:oasis:names:tc:SAML:2.0:metadata";
    private static final String BASE_JAXB_CONTEXT = "org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.saml2.metadata.jaxb:org.certificateservices.messages.saml2.metadata.ui.jaxb:org.certificateservices.messages.saml2.metadata.attr.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb:org.certificateservices.messages.sweeid2.pricipalselection1_0.jaxb";
    protected static final String METADATA_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs-message-saml-schema-metadata-2.0.xsd";
    private SAML2MetaDataSignatureLocationFinder signatureLocationFinder = new SAML2MetaDataSignatureLocationFinder();
    private static ObjectFactory mdOf = new ObjectFactory();
    private static org.certificateservices.messages.saml2.metadata.ui.jaxb.ObjectFactory uiOf = new org.certificateservices.messages.saml2.metadata.ui.jaxb.ObjectFactory();
    private static org.certificateservices.messages.saml2.metadata.attr.jaxb.ObjectFactory attrOf = new org.certificateservices.messages.saml2.metadata.attr.jaxb.ObjectFactory();

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public String getJAXBPackages() {
        return BASE_JAXB_CONTEXT;
    }

    @Override
    public String[] getDefaultSchemaLocations() throws SAXException {
        return new String[]{"/xmldsig-core-schema.xsd", "/xenc-schema.xsd", "/cs-message-saml-schema-assertion-2.0.xsd", METADATA_XSD_SCHEMA_2_0_RESOURCE_LOCATION};
    }

    @Override
    protected String lookupSchemaForElement(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (namespaceURI != null) {
            if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                return "/xmldsig-core-schema.xsd";
            }
            if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                return "/xenc-schema.xsd";
            }
            if (namespaceURI.equals(NAMESPACE)) {
                return METADATA_XSD_SCHEMA_2_0_RESOURCE_LOCATION;
            }
            if (namespaceURI.equals(ASSERTION_NAMESPACE)) {
                return "/cs-message-saml-schema-assertion-2.0.xsd";
            }
            if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                return "/xml.xsd";
            }
        }
        return null;
    }

    public EntityDescriptorType genEntityDescriptor(String entityID, Date validUntil, Duration cacheDuration, ExtensionsType extensions, List<Object> descriptors, OrganizationType organisation, List<ContactType> contactPersons, List<AdditionalMetadataLocationType> additionalMetadataLocations, Map<QName, String> otherAttributes) throws MessageProcessingException, MessageContentException {
        EntityDescriptorType edt = mdOf.createEntityDescriptorType();
        if (entityID == null) {
            throw new MessageContentException("Error a entityID must be set to a Entity Descriptor.");
        }
        edt.setEntityID(entityID);
        edt.setID("_" + MessageGenerateUtils.generateRandomUUID());
        edt.setValidUntil(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(validUntil));
        edt.setCacheDuration(cacheDuration);
        edt.setExtensions(extensions);
        if (descriptors != null) {
            if (descriptors.size() == 1 && descriptors.get(0) instanceof AffiliationDescriptorType) {
                edt.setAffiliationDescriptor((AffiliationDescriptorType)descriptors.get(0));
            } else {
                for (Object descriptor : descriptors) {
                    if (descriptor instanceof RoleDescriptorType) {
                        edt.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add((RoleDescriptorType)descriptor);
                    }
                    if (!(descriptor instanceof AffiliationDescriptorType)) continue;
                    throw new MessageContentException("Error in Entity Descriptor data, cannot mix AffiliationDescriptorType with other types.");
                }
            }
        }
        if (edt.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().size() == 0 && edt.getAffiliationDescriptor() == null) {
            throw new MessageContentException("Error in Entity Descriptor data, at least one descriptor must exist.");
        }
        edt.setOrganization(organisation);
        if (contactPersons != null) {
            edt.getContactPerson().addAll(contactPersons);
        }
        if (additionalMetadataLocations != null) {
            edt.getAdditionalMetadataLocation().addAll(additionalMetadataLocations);
        }
        if (otherAttributes != null) {
            edt.getOtherAttributes().putAll(otherAttributes);
        }
        return edt;
    }

    public byte[] genEntityDescriptor(ContextMessageSecurityProvider.Context context, String entityID, Date validUntil, Duration cacheDuration, ExtensionsType extensions, List<Object> descriptors, OrganizationType organisation, List<ContactType> contactPersons, List<AdditionalMetadataLocationType> additionalMetadataLocations, Map<QName, String> otherAttributes, boolean sign) throws MessageProcessingException, MessageContentException {
        EntityDescriptorType edt = this.genEntityDescriptor(entityID, validUntil, cacheDuration, extensions, descriptors, organisation, contactPersons, additionalMetadataLocations, otherAttributes);
        JAXBElement<EntityDescriptorType> ed = mdOf.createEntityDescriptor(edt);
        if (sign) {
            return this.marshallAndSign(context, ed);
        }
        return this.marshall(ed);
    }

    public EntitiesDescriptorType genEntitiesDescriptor(Date validUntil, Duration cacheDuration, String name, ExtensionsType extensions, List<Object> entityDescriptors) throws MessageProcessingException {
        EntitiesDescriptorType edt = mdOf.createEntitiesDescriptorType();
        edt.setID("_" + MessageGenerateUtils.generateRandomUUID());
        edt.setValidUntil(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(validUntil));
        edt.setCacheDuration(cacheDuration);
        edt.setExtensions(extensions);
        edt.setName(name);
        if (entityDescriptors != null) {
            edt.getEntityDescriptorOrEntitiesDescriptor().addAll(entityDescriptors);
        }
        return edt;
    }

    public byte[] genEntitiesDescriptor(ContextMessageSecurityProvider.Context context, Date validUntil, Duration cacheDuration, String name, ExtensionsType extensions, List<Object> entityDescriptors, boolean sign) throws MessageProcessingException, MessageContentException {
        EntitiesDescriptorType edt = this.genEntitiesDescriptor(validUntil, cacheDuration, name, extensions, entityDescriptors);
        JAXBElement<EntitiesDescriptorType> ed = mdOf.createEntitiesDescriptor(edt);
        if (sign) {
            return this.marshallAndSign(context, ed);
        }
        return this.marshall(ed);
    }

    public OrganizationType genOrganization(ExtensionsType extensions, List<LocalizedNameType> organizationName, List<LocalizedNameType> organizationDisplayName, List<LocalizedURIType> organizationURL, Map<QName, String> otherAttributes) throws MessageContentException {
        this.checkAtLeastOneInList(organizationName, "Organisation", "OrganizationName");
        this.checkAtLeastOneInList(organizationDisplayName, "Organisation", "OrganizationDisplayName");
        this.checkAtLeastOneInList(organizationURL, "Organisation", "OrganizationURL");
        OrganizationType o = mdOf.createOrganizationType();
        o.setExtensions(extensions);
        o.getOrganizationName().addAll(organizationName);
        o.getOrganizationDisplayName().addAll(organizationDisplayName);
        o.getOrganizationURL().addAll(organizationURL);
        if (otherAttributes != null) {
            o.getOtherAttributes().putAll(otherAttributes);
        }
        return o;
    }

    public ContactType genContactType(ContactTypeType contactType, ExtensionsType extensions, String company, String givenName, String surName, List<String> emailAddresses, List<String> telephoneNumbers, Map<QName, String> otherAttributes) {
        ContactType ct = mdOf.createContactType();
        ct.setExtensions(extensions);
        ct.setContactType(contactType);
        ct.setCompany(company);
        ct.setGivenName(givenName);
        ct.setSurName(surName);
        if (emailAddresses != null) {
            ct.getEmailAddress().addAll(emailAddresses);
        }
        if (telephoneNumbers != null) {
            ct.getTelephoneNumber().addAll(telephoneNumbers);
        }
        if (otherAttributes != null) {
            ct.getOtherAttributes().putAll(otherAttributes);
        }
        return ct;
    }

    public KeyDescriptorType genKeyDescriptor(KeyTypes use, KeyInfoType keyInfo, List<EncryptionMethodType> encryptionMethods) {
        KeyDescriptorType kdt = mdOf.createKeyDescriptorType();
        kdt.setUse(use);
        kdt.setKeyInfo(keyInfo);
        kdt.getEncryptionMethod().addAll(encryptionMethods);
        return kdt;
    }

    public KeyDescriptorType genKeyDescriptor(KeyTypes use, X509Certificate certificate, List<EncryptionMethodType> encryptionMethods) throws MessageContentException {
        X509DataType x509DataType = this.dsigOf.createX509DataType();
        try {
            x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(this.dsigOf.createX509DataTypeX509Certificate(certificate.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw new MessageContentException("Error encoding certificate when generating SAML Metadata: " + e.getMessage(), e);
        }
        KeyInfoType kit = this.dsigOf.createKeyInfoType();
        kit.getContent().add(this.dsigOf.createX509Data(x509DataType));
        return this.genKeyDescriptor(use, kit, encryptionMethods);
    }

    public EndpointType genEndpoint(String binding, String location, String responseLocation, List<Object> anyXML, Map<QName, String> otherAttributes) {
        EndpointType et = mdOf.createEndpointType();
        this.populateEndpointType(et, binding, location, responseLocation, anyXML, otherAttributes);
        return et;
    }

    public IndexedEndpointType genIndexedEndpoint(String binding, String location, String responseLocation, int index, Boolean isDefault, List<Object> anyXML, Map<QName, String> otherAttributes) {
        IndexedEndpointType et = mdOf.createIndexedEndpointType();
        this.populateEndpointType(et, binding, location, responseLocation, anyXML, otherAttributes);
        et.setIndex(index);
        et.setIsDefault(isDefault);
        return et;
    }

    public IDPSSODescriptorType genIDPSSODescriptor(Date validUntil, Duration cacheDuration, List<String> protocolSupportEnumeration, String errorURL, ExtensionsType extensions, List<KeyDescriptorType> keyDescriptorTypes, OrganizationType organisation, List<ContactType> contactPersons, Map<QName, String> otherAttributes, List<IndexedEndpointType> artifactResolutionService, List<EndpointType> singleLogoutService, List<EndpointType> manageNameIDService, List<String> nameIDFormat, Boolean wantAuthnRequestsSigned, List<EndpointType> singleSignOnServices, List<EndpointType> nameIDMappingServices, List<EndpointType> assertionIDRequestServices, List<String> attributeProfiles, List<AttributeType> attributes) throws MessageProcessingException, MessageContentException {
        IDPSSODescriptorType dt = mdOf.createIDPSSODescriptorType();
        this.populateRoleDescriptor(dt, validUntil, cacheDuration, protocolSupportEnumeration, errorURL, extensions, keyDescriptorTypes, organisation, contactPersons, otherAttributes);
        this.populateSSODescriptor(dt, artifactResolutionService, singleLogoutService, manageNameIDService, nameIDFormat);
        dt.setWantAuthnRequestsSigned(wantAuthnRequestsSigned);
        if (singleSignOnServices != null) {
            dt.getSingleSignOnService().addAll(singleSignOnServices);
        }
        if (nameIDMappingServices != null) {
            dt.getNameIDMappingService().addAll(nameIDMappingServices);
        }
        if (assertionIDRequestServices != null) {
            dt.getAssertionIDRequestService().addAll(assertionIDRequestServices);
        }
        if (attributeProfiles != null) {
            dt.getAttributeProfile().addAll(attributeProfiles);
        }
        if (attributes != null) {
            dt.getAttribute().addAll(attributes);
        }
        return dt;
    }

    public SPSSODescriptorType genSPSSODescriptor(Date validUntil, Duration cacheDuration, List<String> protocolSupportEnumeration, String errorURL, ExtensionsType extensions, List<KeyDescriptorType> keyDescriptorTypes, OrganizationType organisation, List<ContactType> contactPersons, Map<QName, String> otherAttributes, List<IndexedEndpointType> artifactResolutionService, List<EndpointType> singleLogoutService, List<EndpointType> manageNameIDService, List<String> nameIDFormat, Boolean authnRequestsSigned, Boolean wantAssertionsSigned, List<IndexedEndpointType> assertionConsumerServices, List<AttributeConsumingServiceType> attributeConsumingServices) throws MessageProcessingException, MessageContentException {
        SPSSODescriptorType dt = mdOf.createSPSSODescriptorType();
        this.populateRoleDescriptor(dt, validUntil, cacheDuration, protocolSupportEnumeration, errorURL, extensions, keyDescriptorTypes, organisation, contactPersons, otherAttributes);
        this.populateSSODescriptor(dt, artifactResolutionService, singleLogoutService, manageNameIDService, nameIDFormat);
        dt.setAuthnRequestsSigned(authnRequestsSigned);
        dt.setWantAssertionsSigned(wantAssertionsSigned);
        if (assertionConsumerServices != null) {
            dt.getAssertionConsumerService().addAll(assertionConsumerServices);
        }
        if (attributeConsumingServices != null) {
            dt.getAttributeConsumingService().addAll(attributeConsumingServices);
        }
        return dt;
    }

    public AttributeConsumingServiceType genAttributeConsumingService(int index, Boolean isDefault, List<LocalizedNameType> serviceNames, List<LocalizedNameType> serviceDescriptions, List<RequestedAttributeType> requestedAttributes) {
        AttributeConsumingServiceType t = mdOf.createAttributeConsumingServiceType();
        t.setIndex(index);
        t.setIsDefault(isDefault);
        if (serviceNames != null) {
            t.getServiceName().addAll(serviceNames);
        }
        if (serviceDescriptions != null) {
            t.getServiceDescription().addAll(serviceDescriptions);
        }
        if (requestedAttributes != null) {
            t.getRequestedAttribute().addAll(requestedAttributes);
        }
        return t;
    }

    public ExtensionsType genExtensions(List<Object> extentionObjects) {
        ExtensionsType extensions = mdOf.createExtensionsType();
        extensions.getAny().addAll(extentionObjects);
        return extensions;
    }

    public JAXBElement<UIInfoType> genUIInfo(List<JAXBElement<?>> childElements) throws MessageContentException {
        if (childElements == null || childElements.size() == 0) {
            throw new MessageContentException("Error constructing UIInfo, at least one child element must exist.");
        }
        UIInfoType uiInfoType = uiOf.createUIInfoType();
        uiInfoType.getDisplayNameOrDescriptionOrKeywords().addAll(childElements);
        return uiOf.createUIInfo(uiInfoType);
    }

    public JAXBElement<DiscoHintsType> genUIDiscoHints(List<JAXBElement<?>> childElements) throws MessageContentException {
        if (childElements == null || childElements.size() == 0) {
            throw new MessageContentException("Error constructing DiscoHints, at least one child element must exist.");
        }
        DiscoHintsType discoHintsType = uiOf.createDiscoHintsType();
        discoHintsType.getIPHintOrDomainHintOrGeolocationHint().addAll(childElements);
        return uiOf.createDiscoHints(discoHintsType);
    }

    public JAXBElement<LogoType> genUILogo(int width, int heigth, String uri, String lang) {
        LogoType l = uiOf.createLogoType();
        l.setWidth(BigInteger.valueOf(width));
        l.setHeight(BigInteger.valueOf(heigth));
        l.setValue(uri);
        l.setLang(lang);
        return uiOf.createLogo(l);
    }

    public JAXBElement<LocalizedNameType> genUIDisplayName(String name, String lang) throws MessageContentException {
        this.isSet(lang, "lang attribute is required for MD UI DisplayName");
        LocalizedNameType n = mdOf.createLocalizedNameType();
        n.setValue(name);
        n.setLang(lang);
        return uiOf.createDisplayName(n);
    }

    public JAXBElement<LocalizedNameType> genUIDescription(String description, String lang) throws MessageContentException {
        this.isSet(lang, "lang attribute is required for MD UI Description");
        LocalizedNameType d = mdOf.createLocalizedNameType();
        d.setValue(description);
        d.setLang(lang);
        return uiOf.createDescription(d);
    }

    public JAXBElement<LocalizedURIType> genUIInformationURL(String url, String lang) throws MessageContentException {
        this.isSet(lang, "lang attribute is required for MD UI InformationURL");
        LocalizedURIType u = mdOf.createLocalizedURIType();
        u.setValue(url);
        u.setLang(lang);
        return uiOf.createInformationURL(u);
    }

    public JAXBElement<LocalizedURIType> genUIPrivacyStatementURL(String url, String lang) throws MessageContentException {
        this.isSet(lang, "lang attribute is required for MD UI PrivacyStatementURL");
        LocalizedURIType u = mdOf.createLocalizedURIType();
        u.setValue(url);
        u.setLang(lang);
        return uiOf.createPrivacyStatementURL(u);
    }

    public JAXBElement<KeywordsType> genUIKeywords(List<String> keywords, String lang) throws MessageContentException {
        this.isSet(lang, "lang attribute is required for MD UI Keywords");
        KeywordsType k = uiOf.createKeywordsType();
        for (String keyword : keywords) {
            k.getValue().add(keyword.replaceAll(" ", "+"));
        }
        k.setLang(lang);
        return uiOf.createKeywords(k);
    }

    public JAXBElement<String> genUIIPHint(String value) {
        return uiOf.createIPHint(value);
    }

    public JAXBElement<String> genUIDomainHint(String value) {
        return uiOf.createDomainHint(value);
    }

    public JAXBElement<String> genUIGeolocationHint(String value) {
        return uiOf.createGeolocationHint(value);
    }

    public JAXBElement<EntityAttributesType> genMDEntityAttributes(List<Object> attributeOrAssertion) throws MessageContentException {
        EntityAttributesType entityAttributes = attrOf.createEntityAttributesType();
        for (Object o : attributeOrAssertion) {
            if (o instanceof AttributeType || o instanceof AssertionType) {
                entityAttributes.getAttributeOrAssertion().add(o);
                continue;
            }
            throw new MessageContentException("Error constructing MDAttr EntityAttributes, only AttributeType or AssertionType is allowed as attributes.");
        }
        return attrOf.createEntityAttributes(entityAttributes);
    }

    protected void isSet(String value, String errorMessage) throws MessageContentException {
        if (value == null || value.trim().equals("")) {
            throw new MessageContentException(errorMessage);
        }
    }

    protected void populateRoleDescriptor(RoleDescriptorType roleDescriptor, Date validUntil, Duration cacheDuration, List<String> protocolSupportEnumeration, String errorURL, ExtensionsType extensions, List<KeyDescriptorType> keyDescriptorTypes, OrganizationType organisation, List<ContactType> contactPersons, Map<QName, String> otherAttributes) throws MessageContentException, MessageProcessingException {
        roleDescriptor.setID("_" + MessageGenerateUtils.generateRandomUUID());
        roleDescriptor.setValidUntil(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(validUntil));
        roleDescriptor.setCacheDuration(cacheDuration);
        if (protocolSupportEnumeration != null) {
            roleDescriptor.getProtocolSupportEnumeration().addAll(protocolSupportEnumeration);
        }
        roleDescriptor.setErrorURL(errorURL);
        roleDescriptor.setExtensions(extensions);
        if (keyDescriptorTypes != null) {
            roleDescriptor.getKeyDescriptor().addAll(keyDescriptorTypes);
        }
        roleDescriptor.setOrganization(organisation);
        if (contactPersons != null) {
            roleDescriptor.getContactPerson().addAll(contactPersons);
        }
        if (otherAttributes != null) {
            roleDescriptor.getOtherAttributes().putAll(otherAttributes);
        }
    }

    protected void populateSSODescriptor(SSODescriptorType ssoDescriptorType, List<IndexedEndpointType> artifactResolutionService, List<EndpointType> singleLogoutService, List<EndpointType> manageNameIDService, List<String> nameIDFormat) {
        if (artifactResolutionService != null) {
            ssoDescriptorType.getArtifactResolutionService().addAll(artifactResolutionService);
        }
        if (singleLogoutService != null) {
            ssoDescriptorType.getSingleLogoutService().addAll(singleLogoutService);
        }
        if (manageNameIDService != null) {
            ssoDescriptorType.getManageNameIDService().addAll(manageNameIDService);
        }
        if (nameIDFormat != null) {
            ssoDescriptorType.getNameIDFormat().addAll(nameIDFormat);
        }
    }

    protected void populateEndpointType(EndpointType endpointType, String binding, String location, String responseLocation, List<Object> anyXML, Map<QName, String> otherAttributes) {
        endpointType.setBinding(binding);
        endpointType.setLocation(location);
        endpointType.setResponseLocation(responseLocation);
        if (anyXML != null) {
            endpointType.getAny().addAll(anyXML);
        }
        if (otherAttributes != null) {
            endpointType.getOtherAttributes().putAll(otherAttributes);
        }
    }

    @Override
    public XMLSigner.SignatureLocationFinder getSignatureLocationFinder() {
        return this.signatureLocationFinder;
    }

    @Override
    public XMLSigner.OrganisationLookup getOrganisationLookup() {
        return null;
    }

    private void checkAtLeastOneInList(List<?> list, String objectType, String fieldName) throws MessageContentException {
        if (list == null || list.size() == 0) {
            throw new MessageContentException("Error constructing meta data " + objectType + ", at least on " + fieldName + " must be specified");
        }
    }

    public static class SAML2MetaDataSignatureLocationFinder
    implements XMLSigner.SignatureLocationFinder {
        @Override
        public Element[] getSignatureLocations(Document doc) throws MessageContentException {
            try {
                if (doc.getDocumentElement().getNamespaceURI().equals(SAMLMetaDataMessageParser.NAMESPACE)) {
                    return new Element[]{doc.getDocumentElement()};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageContentException("Invalid SAMLP message type sent for signature.");
        }

        @Override
        public String getIDAttribute() {
            return "ID";
        }

        @Override
        public String getIDValue(Element signedElement) throws MessageContentException {
            return signedElement.getAttribute(this.getIDAttribute());
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            ArrayList<QName> retval = null;
            if (element.getLocalName().equals("EntitiesDescriptor")) {
                retval = new ArrayList<QName>();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "EntitiesDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "EntityDescriptor"));
            }
            if (element.getLocalName().equals("EntityDescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "RoleDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "IDPSSODescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SPSSODescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AuthnAuthorityDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AttributeAuthorityDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "PDPDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AffiliationDescriptor"));
            }
            if (element.getLocalName().equals("IDPSSODescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "KeyDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Organization"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ContactPerson"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ArtifactResolutionService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SingleLogoutService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ManageNameIDService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "NameIDFormat"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SingleSignOnService"));
            }
            if (element.getLocalName().equals("SPSSODescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "KeyDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Organization"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ContactPerson"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ArtifactResolutionService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SingleLogoutService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ManageNameIDService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "NameIDFormat"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AssertionConsumerService"));
            }
            if (element.getLocalName().equals("AuthnAuthorityDescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "KeyDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Organization"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ContactPerson"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ArtifactResolutionService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SingleLogoutService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ManageNameIDService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "NameIDFormat"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AuthnQueryService"));
            }
            if (element.getLocalName().equals("AuthnAuthorityDescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "KeyDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Organization"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ContactPerson"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ArtifactResolutionService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SingleLogoutService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ManageNameIDService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "NameIDFormat"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AuthzService"));
            }
            if (element.getLocalName().equals("AttributeAuthorityDescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "KeyDescriptor"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Organization"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ContactPerson"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ArtifactResolutionService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "SingleLogoutService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "ManageNameIDService"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "NameIDFormat"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AttributeService"));
            }
            if (element.getLocalName().equals("AffiliationDescriptor")) {
                retval = new ArrayList();
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "Extensions"));
                retval.add(new QName(SAMLMetaDataMessageParser.NAMESPACE, "AffiliateMember"));
            }
            return retval;
        }
    }
}

