/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.security.cert.X509Certificate;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.GetApprovalRequest;
import org.certificateservices.messages.utils.CertUtils;
import org.xml.sax.SAXParseException;

public class CSMessageUtils {
    public static Object getPayload(CSMessage csMessage) {
        if (csMessage == null) {
            return null;
        }
        Object o = csMessage.getPayload().getAny();
        if (o instanceof JAXBElement) {
            return ((JAXBElement)o).getValue();
        }
        return o;
    }

    public static String getPayloadName(CSMessage csMessage) throws MessageContentException {
        Object payload = CSMessageUtils.getPayload(csMessage);
        if (payload == null) {
            throw new MessageContentException("Error no payload name could be found in CS Message");
        }
        return payload.getClass().getSimpleName();
    }

    public static Object getRelatedPayload(CSMessage csMessage) throws MessageContentException {
        Object payload = CSMessageUtils.getPayload(csMessage);
        if (payload instanceof GetApprovalRequest) {
            return ((GetApprovalRequest)payload).getRequestPayload().getAny();
        }
        throw new MessageContentException("Error fetching related payload object from CS Message, message didn't contain any GetApprovalRequest payload.");
    }

    public static String getRelatedPayloadName(CSMessage csMessage) throws MessageContentException {
        Object payload = CSMessageUtils.getPayload(csMessage);
        if (payload instanceof GetApprovalRequest) {
            return ((GetApprovalRequest)payload).getRequestPayload().getAny().getClass().getSimpleName();
        }
        throw new MessageContentException("Error fetching related payload name from CS Message, message didn't contain any GetApprovalRequest payload.");
    }

    public static String getMarshallingExceptionMessage(Exception e) {
        if (e.getMessage() == null && e.getCause() != null) {
            if (e.getCause().getMessage() == null) {
                JAXBException je;
                if (e instanceof JAXBException && ((JAXBException)e).getLinkedException() != null && ((JAXBException)e).getLinkedException().getMessage() != null) {
                    return ((JAXBException)e).getLinkedException().getMessage();
                }
                if (e instanceof SAXParseException && ((SAXParseException)e).getException() instanceof JAXBException && (je = (JAXBException)((SAXParseException)e).getException()).getLinkedException() != null && je.getLinkedException().getMessage() != null) {
                    return je.getLinkedException().getMessage();
                }
            }
            return e.getCause().getMessage();
        }
        return e.getMessage();
    }

    public static String getRequesterUniqueId(CSMessageParser parser, byte[] messageData) throws MessageContentException, MessageProcessingException {
        X509Certificate signingCert = parser.getSigningCertificate(messageData);
        if (signingCert == null) {
            throw new MessageContentException("Error, no signing certificate found in CS Message Request");
        }
        try {
            return CertUtils.getCertificateUniqueId(CertUtils.getCertfromByteArray(signingCert.getEncoded()));
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing certificate from CS Message: " + e.getMessage());
        }
    }
}

