/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.authcontsaci1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.authcontsaci1.jaxb.AttributeMappingType;
import org.certificateservices.messages.authcontsaci1.jaxb.AuthContextInfoType;
import org.certificateservices.messages.authcontsaci1.jaxb.ObjectFactory;
import org.certificateservices.messages.authcontsaci1.jaxb.SAMLAuthContextType;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.saml2.assertion.SAMLAssertionMessageParser;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.ContextInfoType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class AuthContSaciMessageParser {
    private static final String BASE_JAXB_CONTEXT = "org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.authcontsaci1.jaxb";
    public static final String NAMESPACE = "http://id.elegnamnden.se/auth-cont/1.0/saci";
    private static final String SCHEMA_LOCATION = "/auth-cont-1_0-saci.xsd";
    ObjectFactory of = new ObjectFactory();
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private JAXBContext jaxbContext = null;
    private Transformer transformer = null;

    public SAMLAuthContextType parse(byte[] data) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(data));
            return (SAMLAuthContextType)((JAXBElement)this.getUnmarshaller().unmarshal((Node)doc)).getValue();
        }
        catch (SAXException e) {
            throw new MessageContentException("Message content error when parsing auth cont saci data: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Message content error when parsing auth cont saci data: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when parsing auth cont saci data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when parsing auth cont saci data: " + e.getMessage(), e);
        }
    }

    public byte[] genSAMLAuthContext(ContextInfoType contextInfo, List<AttributeMappingType> attributeMappings) throws MessageProcessingException {
        try {
            SAMLAuthContextType samlAuthContext = this.of.createSAMLAuthContextType();
            samlAuthContext.setAuthContextInfo(this.convertContextInfoType(contextInfo));
            samlAuthContext.setIdAttributes(this.of.createIdAttributesType());
            samlAuthContext.getIdAttributes().getAttributeMapping().addAll(attributeMappings);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMarshaller().marshal(this.of.createSAMLAuthContext(samlAuthContext), (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error generating genSAMLAuthContext message: " + e.getMessage(), e);
        }
    }

    private AuthContextInfoType convertContextInfoType(ContextInfoType contextInfo) {
        AuthContextInfoType authContextInfo = this.of.createAuthContextInfoType();
        authContextInfo.setAssertionRef(contextInfo.getAssertionRef());
        authContextInfo.setAuthenticationInstant(contextInfo.getAuthenticationInstant());
        authContextInfo.setAuthnContextClassRef(contextInfo.getAuthnContextClassRef());
        authContextInfo.setIdentityProvider(contextInfo.getIdentityProvider().getValue());
        authContextInfo.setServiceID(contextInfo.getServiceID());
        return authContextInfo;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.marshaller = this.getJAXBContext().createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        return this.marshaller;
    }

    Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.getJAXBContext().createUnmarshaller();
            this.unmarshaller.setSchema(this.generateSchema());
        }
        return this.unmarshaller;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)BASE_JAXB_CONTEXT);
        }
        return this.jaxbContext;
    }

    private Schema generateSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new AuthContentSaciLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/xenc-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/cs-message-saml-schema-assertion-2.0.xsd")), new StreamSource(this.getClass().getResourceAsStream(SCHEMA_LOCATION))};
        Schema schema = schemaFactory.newSchema(sources);
        return schema;
    }

    private Transformer getTransformer() throws MessageProcessingException {
        if (this.transformer == null) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                this.transformer = tf.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new MessageProcessingException("Error instanciating Transformer for XMLSigner: " + e.getMessage(), e);
            }
        }
        return this.transformer;
    }

    public class AuthContentSaciLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals(SAMLAssertionMessageParser.ASSERTION_NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/cs-message-saml-schema-assertion-2.0.xsd"));
                    }
                    if (namespaceURI.equals(AuthContSaciMessageParser.NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(AuthContSaciMessageParser.SCHEMA_LOCATION));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

