/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages.manager;

import java.util.Properties;
import org.certificateservices.messages.DummyMessageSecurityProvider;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.SimpleMessageSecurityProvider;

public class MessageSecurityProviderManager {
    public static final String SETTING_MESSAGESECURITYPROVIDER_IMPL = "messagesecurityprovider.impl";
    private static final String DEFAULT_IMPLEMENTATION = SimpleMessageSecurityProvider.class.getName();
    private static MessageSecurityProvider secProv = null;

    public static MessageSecurityProvider initMessageSecurityProvider(MessageSecurityProvider messageSecurityProvider) throws MessageProcessingException {
        secProv = messageSecurityProvider;
        return secProv;
    }

    public static MessageSecurityProvider initMessageSecurityProvider(Properties config) throws MessageProcessingException {
        String cp = config.getProperty(SETTING_MESSAGESECURITYPROVIDER_IMPL, DEFAULT_IMPLEMENTATION).trim();
        try {
            if (cp.equalsIgnoreCase(SimpleMessageSecurityProvider.class.getName())) {
                secProv = new SimpleMessageSecurityProvider(config);
            }
            if (cp.equalsIgnoreCase(DummyMessageSecurityProvider.class.getName())) {
                secProv = new DummyMessageSecurityProvider();
            }
            if (secProv == null) {
                throw new MessageProcessingException("Error unsupported message security provider: " + cp);
            }
            return secProv;
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error creating JMS Message Handler: " + e.getMessage(), e);
        }
    }

    public static boolean isInitialized() {
        return secProv != null;
    }

    public static MessageSecurityProvider getMessageSecurityProvider() throws MessageProcessingException {
        if (secProv == null) {
            throw new MessageProcessingException("Error Message Security Provider haven't been initialized, make sure initMessageSecurityProvider() is called before getMessageSecurityProvider");
        }
        return secProv;
    }
}

