/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.hardtoken;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.hardtoken.jaxb.HardTokenData;
import org.certificateservices.messages.hardtoken.jaxb.ObjectFactory;
import org.certificateservices.messages.hardtoken.jaxb.PINData;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class HardTokenDataParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/hardtoken";
    public static String DEFAULT_VERSION = "2.0";
    private static final String HARDTOKEN_XSD_SCHEMA_RESOURCE_LOCATION = "/hardtoken_schema.xsd";
    private ObjectFactory of = new ObjectFactory();
    private XMLEncrypter xmlEncrypter;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private JAXBContext jaxbContext = null;
    private Transformer transformer = null;

    public HardTokenDataParser(MessageSecurityProvider securityProvider) throws MessageProcessingException {
        try {
            this.xmlEncrypter = new XMLEncrypter(securityProvider, this.getDocumentBuilder(), this.getMarshaller(), this.getUnmarshaller());
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initializing HardTokenDataParser: " + e.getMessage(), e);
        }
    }

    public HardTokenData parse(byte[] data) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(data));
            return (HardTokenData)this.getUnmarshaller().unmarshal((Node)doc);
        }
        catch (SAXException e) {
            throw new MessageContentException("Message content error when parsing hard token data: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Message content error when parsing hard token data: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when parsing hard token data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when parsing hard token data: " + e.getMessage(), e);
        }
    }

    public HardTokenData decryptAndParse(byte[] encryptedData) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(encryptedData));
            return (HardTokenData)this.xmlEncrypter.decryptDocument(doc);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error parsing encrypted hard token data: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new MessageContentException("Internal content encrypted hard token data: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Internal content encrypted hard token data: " + e.getMessage(), e);
        }
    }

    public HardTokenData genHardTokenData(String tokenType, String tokenClass, String serialNumber, boolean supportsRemoteUnblock, Date createTime, Date modifyTime, List<PINData> pins) throws MessageProcessingException {
        HardTokenData htd = this.of.createHardTokenData();
        htd.setVersion(DEFAULT_VERSION);
        htd.setTokenType(tokenType);
        htd.setTokenClass(tokenClass);
        htd.setSerialNumber(serialNumber);
        htd.setCreateTime(MessageGenerateUtils.dateToXMLGregorianCalendar(createTime));
        htd.setModifyTime(MessageGenerateUtils.dateToXMLGregorianCalendar(modifyTime));
        htd.setSupportsRemoteUnblock(supportsRemoteUnblock);
        htd.setPinDatas(this.of.createHardTokenDataPinDatas());
        for (PINData pin : pins) {
            htd.getPinDatas().getPin().add(pin);
        }
        return htd;
    }

    public byte[] marshall(HardTokenData hardTokenData) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal((Object)hardTokenData, (Node)doc);
            StringWriter writer = new StringWriter();
            this.getTransformer().transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when generating hard token data: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageProcessingException("Internal error when generating hard token data: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageProcessingException("Internal error when generating hard token data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when generating hard token data: " + e.getMessage(), e);
        }
    }

    public byte[] encryptAndMarshall(HardTokenData hardTokenData, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal((Object)hardTokenData, (Node)doc);
            Document encDoc = this.xmlEncrypter.encryptElement(doc, receipients, false);
            StringWriter writer = new StringWriter();
            this.getTransformer().transform(new DOMSource(encDoc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (JAXBException e) {
            throw new MessageContentException("Message content error when generating hard token data: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageProcessingException("Internal error when generating hard token data: " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageProcessingException("Internal error when generating hard token data: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error when generating hard token data: " + e.getMessage(), e);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.marshaller = this.getJAXBContext().createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        return this.marshaller;
    }

    Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.getJAXBContext().createUnmarshaller();
            this.unmarshaller.setSchema(this.generateSchema());
        }
        return this.unmarshaller;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            String jaxbClassPath = "org.certificateservices.messages.hardtoken.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb";
            this.jaxbContext = JAXBContext.newInstance((String)jaxbClassPath);
        }
        return this.jaxbContext;
    }

    private Schema generateSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new HardTokenParserLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/xenc-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(HARDTOKEN_XSD_SCHEMA_RESOURCE_LOCATION))};
        Schema schema = schemaFactory.newSchema(sources);
        return schema;
    }

    private Transformer getTransformer() throws MessageProcessingException {
        if (this.transformer == null) {
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                this.transformer = tf.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new MessageProcessingException("Error instanciating Transformer for XMLSigner: " + e.getMessage(), e);
            }
        }
        return this.transformer;
    }

    public class HardTokenParserLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xmldsig-core-schema.xsd"));
                    }
                    if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xenc-schema.xsd"));
                    }
                    if (namespaceURI.equals(NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(HardTokenDataParser.HARDTOKEN_XSD_SCHEMA_RESOURCE_LOCATION));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

