/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.sweeid2.dssextenstions1_1;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.dss1.core.DSS1CoreMessageParser;
import org.certificateservices.messages.dss1.core.jaxb.InputDocuments;
import org.certificateservices.messages.dss1.core.jaxb.Result;
import org.certificateservices.messages.dss1.core.jaxb.SignRequest;
import org.certificateservices.messages.dss1.core.jaxb.SignResponse;
import org.certificateservices.messages.dss1.core.jaxb.SignatureObject;
import org.certificateservices.messages.saml2.BaseSAMLMessageParser;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeStatementType;
import org.certificateservices.messages.saml2.assertion.jaxb.AudienceRestrictionType;
import org.certificateservices.messages.saml2.assertion.jaxb.ConditionsType;
import org.certificateservices.messages.saml2.assertion.jaxb.EncryptedElementType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.AdESType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.CertNameType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.CertType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.SigType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.SignMessageMimeType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.AdESObjectType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.AnyType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.Base64SignatureType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.CertRequestPropertiesType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.CertificateChainType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.ContextInfoType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.MappedAttributeType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.ObjectFactory;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.PreferredSAMLAttributeNameType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.RequestedAttributesType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SAMLAssertionsType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SignMessageType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SignRequestExtensionType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SignResponseExtensionType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SignTaskDataType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SignTasksType;
import org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb.SignerAssertionInfoType;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.xenc.jaxb.EncryptedDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SweEID2DSSExtensionsMessageParser
extends DSS1CoreMessageParser {
    public static final String NAMESPACE = "http://id.elegnamnden.se/csig/1.1/dss-ext/ns";
    private static final String BASE_JAXB_CONTEXT = "org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb:org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.xenc.jaxb";
    private static final String SWEEID_DSS_EXTENSTIONS_XSD_SCHEMA_1_1_RESOURCE_LOCATION = "/eid-dss-extensions-1.1.2.xsd";
    protected ObjectFactory eid2Of = new ObjectFactory();
    protected SignMessageXMLConverter signMessageXMLConverter = new SignMessageXMLConverter();
    private static Map<String, String> NAMESPACETOPREFIXMAP = new HashMap<String, String>();
    private static Map<String, String> PREFIXTONAMESPACEMAP = new HashMap<String, String>();
    private Marshaller dssMarshaller = null;
    private JAXBContext dssJaxbContext = null;
    private Marshaller sweEID2Marshaller = null;
    private JAXBContext sweEID2JaxbContext = null;

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public String getJAXBPackages() {
        return "org.certificateservices.messages.sweeid2.dssextenstions1_1.jaxb:org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.xenc.jaxb:" + super.getJAXBPackages();
    }

    @Override
    public String[] getDefaultSchemaLocations() throws SAXException {
        return new String[]{"/xmldsig-core-schema.xsd", "/cs-message-oasis-dss-core-schema-v1.0-os.xsd", SWEEID_DSS_EXTENSTIONS_XSD_SCHEMA_1_1_RESOURCE_LOCATION, "/cs-message-saml-schema-assertion-2.0.xsd", "/xenc-schema.xsd", "/cs-message-oasis-sstc-saml-schema-protocol-1.1.xsd"};
    }

    @Override
    protected String lookupSchemaForElement(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (namespaceURI != null) {
            if (namespaceURI.equals(NAMESPACE)) {
                return SWEEID_DSS_EXTENSTIONS_XSD_SCHEMA_1_1_RESOURCE_LOCATION;
            }
            if (namespaceURI.equals(ASSERTION_NAMESPACE)) {
                return "/cs-message-saml-schema-assertion-2.0.xsd";
            }
            if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                return "/xenc-schema.xsd";
            }
        }
        return super.lookupSchemaForElement(type, namespaceURI, publicId, systemId, baseURI);
    }

    public byte[] genSignRequest(ContextMessageSecurityProvider.Context context, String requestID, String profile, JAXBElement<SignRequestExtensionType> signRequestExtension, JAXBElement<SignTasksType> signTasks, boolean sign) throws MessageProcessingException, MessageContentException {
        Document optionalInputContent = this.marshallToSweEID2ExtensionDoc(signRequestExtension);
        Document inputDocumentContent = this.marshallToSweEID2ExtensionDoc(signTasks);
        org.certificateservices.messages.dss1.core.jaxb.AnyType at = this.dssOf.createAnyType();
        InputDocuments inputDocuments = this.dssOf.createInputDocuments();
        inputDocuments.getDocumentOrTransformedDataOrDocumentHash().add(at);
        SignRequest signRequest = this.genSignRequest(requestID, profile, new ArrayList<Object>(), inputDocuments);
        Document doc = this.marshallToDSSDoc(signRequest);
        Element OptionalInputsElement = (Element)doc.getElementsByTagNameNS("urn:oasis:names:tc:dss:1.0:core:schema", "OptionalInputs").item(0);
        OptionalInputsElement.appendChild(doc.importNode(optionalInputContent.getDocumentElement(), true));
        Element OtherElement = (Element)doc.getElementsByTagNameNS("urn:oasis:names:tc:dss:1.0:core:schema", "Other").item(0);
        OtherElement.appendChild(doc.importNode(inputDocumentContent.getDocumentElement(), true));
        if (sign) {
            return this.xmlSigner.marshallAndSign(context, doc, this.getSignatureLocationFinder());
        }
        return this.xmlSigner.marshallDoc(doc);
    }

    public byte[] genSignResponse(ContextMessageSecurityProvider.Context context, String requestID, String profile, Result result, JAXBElement<SignResponseExtensionType> signResponseExtension, JAXBElement<SignTasksType> signTasks, boolean sign) throws MessageProcessingException, MessageContentException {
        Document optionalInputContent = this.marshallToSweEID2ExtensionDoc(signResponseExtension);
        Document signatureObjectContent = this.marshallToSweEID2ExtensionDoc(signTasks);
        SignatureObject signatureObject = this.dssOf.createSignatureObject();
        signatureObject.setOther(this.dssOf.createAnyType());
        SignResponse signResponse = this.genSignResponse(requestID, profile, result, new ArrayList<Object>(), signatureObject);
        Document doc = this.marshallToDSSDoc(signResponse);
        Element OptionalOutputsElement = (Element)doc.getElementsByTagNameNS("urn:oasis:names:tc:dss:1.0:core:schema", "OptionalOutputs").item(0);
        OptionalOutputsElement.appendChild(doc.importNode(optionalInputContent.getDocumentElement(), true));
        Element OtherElement = (Element)doc.getElementsByTagNameNS("urn:oasis:names:tc:dss:1.0:core:schema", "Other").item(0);
        OtherElement.appendChild(doc.importNode(signatureObjectContent.getDocumentElement(), true));
        if (sign) {
            return this.xmlSigner.marshallAndSign(context, doc, this.getSignatureLocationFinder());
        }
        return this.xmlSigner.marshallDoc(doc);
    }

    public JAXBElement<SignRequestExtensionType> genSignRequestExtension(String version, Date requestTime, ConditionsType conditionsType, AttributeStatementType signer, String identityProvider, String signRequester, String signService, String requestedSignatureAlgorithm, SignMessageType signMessage, CertRequestPropertiesType certRequestProperties, List<Object> otherRequestInfo) throws MessageProcessingException {
        return this.genSignRequestExtension(version, requestTime, conditionsType, signer, this.genNameIdWithEntityFormat(identityProvider), this.genNameIdWithEntityFormat(signRequester), this.genNameIdWithEntityFormat(signService), requestedSignatureAlgorithm, signMessage, certRequestProperties, otherRequestInfo);
    }

    public JAXBElement<SignRequestExtensionType> genSignRequestExtension(String version, Date requestTime, ConditionsType conditionsType, AttributeStatementType signer, String identityProvider, String authnProfile, String signRequester, String signService, String requestedSignatureAlgorithm, SignMessageType signMessage, CertRequestPropertiesType certRequestProperties, List<Object> otherRequestInfo) throws MessageProcessingException {
        return this.genSignRequestExtension(version, requestTime, conditionsType, signer, this.genNameIdWithEntityFormat(identityProvider), authnProfile, this.genNameIdWithEntityFormat(signRequester), this.genNameIdWithEntityFormat(signService), requestedSignatureAlgorithm, signMessage, certRequestProperties, otherRequestInfo);
    }

    public JAXBElement<SignRequestExtensionType> genSignRequestExtension(String version, Date requestTime, ConditionsType conditionsType, AttributeStatementType signer, NameIDType identityProvider, NameIDType signRequester, NameIDType signService, String requestedSignatureAlgorithm, SignMessageType signMessage, CertRequestPropertiesType certRequestProperties, List<Object> otherRequestInfo) throws MessageProcessingException {
        return this.genSignRequestExtension(version, requestTime, conditionsType, signer, identityProvider, null, signRequester, signService, requestedSignatureAlgorithm, signMessage, certRequestProperties, otherRequestInfo);
    }

    public JAXBElement<SignRequestExtensionType> genSignRequestExtension(String version, Date requestTime, ConditionsType conditionsType, AttributeStatementType signer, NameIDType identityProvider, String authnProfile, NameIDType signRequester, NameIDType signService, String requestedSignatureAlgorithm, SignMessageType signMessage, CertRequestPropertiesType certRequestProperties, List<Object> otherRequestInfo) throws MessageProcessingException {
        SignRequestExtensionType t = this.eid2Of.createSignRequestExtensionType();
        t.setVersion(version);
        t.setRequestTime(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(requestTime));
        t.setConditions(conditionsType);
        t.setSigner(signer);
        t.setIdentityProvider(identityProvider);
        t.setAuthnProfile(authnProfile);
        t.setSignRequester(signRequester);
        t.setSignService(signService);
        t.setRequestedSignatureAlgorithm(requestedSignatureAlgorithm);
        t.setSignMessage(signMessage);
        t.setCertRequestProperties(certRequestProperties);
        if (otherRequestInfo != null) {
            AnyType at = this.eid2Of.createAnyType();
            at.getAny().addAll(otherRequestInfo);
            t.setOtherRequestInfo(at);
        }
        return this.eid2Of.createSignRequestExtension(t);
    }

    public ConditionsType genBasicConditions(Date notBefore, Date notOnOrAfter, String audience) throws MessageProcessingException {
        ConditionsType conditionsType = this.of.createConditionsType();
        conditionsType.setNotBefore(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(notBefore));
        conditionsType.setNotOnOrAfter(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(notOnOrAfter));
        AudienceRestrictionType art = this.of.createAudienceRestrictionType();
        art.getAudience().add(audience);
        conditionsType.getConditionOrAudienceRestrictionOrOneTimeUse().add(art);
        return conditionsType;
    }

    public CertRequestPropertiesType genCertRequestProperties(CertType certType, String authnContextClassRef, List<MappedAttributeType> requestedCertAttributes, List<Object> otherProperties) {
        ArrayList<String> authContextClassRefs = null;
        if (authnContextClassRef != null) {
            authContextClassRefs = new ArrayList<String>();
            authContextClassRefs.add(authnContextClassRef);
        }
        return this.genCertRequestProperties(certType, authContextClassRefs, requestedCertAttributes, otherProperties);
    }

    public CertRequestPropertiesType genCertRequestProperties(CertType certType, List<String> authnContextClassRefs, List<MappedAttributeType> requestedCertAttributes, List<Object> otherProperties) {
        CertRequestPropertiesType t = this.eid2Of.createCertRequestPropertiesType();
        if (certType != null) {
            t.setCertType(certType.getValue());
        }
        if (authnContextClassRefs != null) {
            t.getAuthnContextClassRef().addAll(authnContextClassRefs);
        }
        if (requestedCertAttributes != null) {
            RequestedAttributesType rat = this.eid2Of.createRequestedAttributesType();
            rat.getRequestedCertAttribute().addAll(requestedCertAttributes);
            t.setRequestedCertAttributes(rat);
        }
        if (otherProperties != null) {
            AnyType at = this.eid2Of.createAnyType();
            at.getAny().addAll(otherProperties);
            t.setOtherProperties(at);
        }
        return t;
    }

    public MappedAttributeType genMappedAttribute(String certAttributeRef, CertNameType certNameType, String friendlyName, String defaultValue, Boolean required, List<NameIDType> attributeAuthorities, List<PreferredSAMLAttributeNameType> samlAttributeNames) {
        MappedAttributeType t = this.eid2Of.createMappedAttributeType();
        t.setCertAttributeRef(certAttributeRef);
        if (certNameType != null) {
            t.setCertNameType(certNameType.name());
        }
        t.setFriendlyName(friendlyName);
        t.setDefaultValue(defaultValue);
        t.setRequired(required);
        if (attributeAuthorities != null) {
            t.getAttributeAuthority().addAll(attributeAuthorities);
        }
        if (samlAttributeNames != null) {
            t.getSamlAttributeName().addAll(samlAttributeNames);
        }
        return t;
    }

    public PreferredSAMLAttributeNameType genPreferredSAMLAttributeName(Integer order, String value) {
        PreferredSAMLAttributeNameType t = this.eid2Of.createPreferredSAMLAttributeNameType();
        t.setOrder(order);
        t.setValue(value);
        return t;
    }

    public SignMessageType genSignMessage(Boolean mustShow, String displayEntity, SignMessageMimeType mimeType, byte[] message, Map<QName, String> otherAttributes) {
        SignMessageType t = this.eid2Of.createSignMessageType();
        this.populateSignMessage(t, mustShow, displayEntity, mimeType, otherAttributes);
        t.setMessage(message);
        return t;
    }

    public SignMessageType genSignEncryptedMessage(ContextMessageSecurityProvider.Context context, Boolean mustShow, String displayEntity, SignMessageMimeType mimeType, byte[] messageToEncrypt, Map<QName, String> otherAttributes, List<X509Certificate> recipients) throws MessageProcessingException {
        SignMessageType t = this.eid2Of.createSignMessageType();
        this.populateSignMessage(t, mustShow, displayEntity, mimeType, otherAttributes);
        JAXBElement<byte[]> message = this.eid2Of.createMessage(messageToEncrypt);
        Document encryptedDoc = this.xmlEncrypter.encryptElement(context, message, recipients, false);
        EncryptedElementType encryptedElementType = null;
        try {
            EncryptedDataType encryptedDataType = (EncryptedDataType)((JAXBElement)this.getUnmarshaller().unmarshal((Node)encryptedDoc)).getValue();
            encryptedElementType = this.of.createEncryptedElementType();
            encryptedElementType.setEncryptedData(encryptedDataType);
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error parsing generated encrypted message: " + e.getMessage(), e);
        }
        t.setEncryptedMessage(encryptedElementType);
        return t;
    }

    public SignMessageType decryptSignMessageData(ContextMessageSecurityProvider.Context context, SignMessageType signMessage) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal(this.eid2Of.createSignMessage(signMessage), (Node)doc);
            JAXBElement decryptedSignMessage = (JAXBElement)this.xmlEncrypter.decryptDocument(context, doc, this.signMessageXMLConverter);
            this.schemaValidate(decryptedSignMessage);
            return (SignMessageType)decryptedSignMessage.getValue();
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error parsing SignMessage : " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageProcessingException("Internal error parsing SignMessage: " + e.getMessage(), e);
        }
    }

    private void populateSignMessage(SignMessageType signMessageType, Boolean mustShow, String displayEntity, SignMessageMimeType mimeType, Map<QName, String> otherAttributes) {
        signMessageType.setMustShow(mustShow);
        signMessageType.setDisplayEntity(displayEntity);
        if (mimeType != null) {
            signMessageType.setMimeType(mimeType.getMimeType());
        }
        if (otherAttributes != null) {
            signMessageType.getOtherAttributes().putAll(otherAttributes);
        }
    }

    public JAXBElement<SignResponseExtensionType> genSignResponseExtension(String version, Date responseTime, SignRequest request, SignerAssertionInfoType signerAssertionInfo, List<X509Certificate> signatureCertificateChain, List<Object> otherResponseInfo) throws MessageProcessingException {
        byte[] requestData = null;
        if (request != null) {
            requestData = this.marshall(request);
        }
        return this.genSignResponseExtension(version, responseTime, requestData, signerAssertionInfo, signatureCertificateChain, otherResponseInfo);
    }

    public JAXBElement<SignResponseExtensionType> genSignResponseExtension(String version, Date responseTime, byte[] requestData, SignerAssertionInfoType signerAssertionInfo, List<X509Certificate> signatureCertificateChain, List<Object> otherResponseInfo) throws MessageProcessingException {
        SignResponseExtensionType t = this.eid2Of.createSignResponseExtensionType();
        t.setVersion(version);
        t.setResponseTime(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(responseTime));
        t.setSignerAssertionInfo(signerAssertionInfo);
        t.setRequest(requestData);
        if (signatureCertificateChain != null) {
            CertificateChainType certificateChainType = this.eid2Of.createCertificateChainType();
            for (X509Certificate cert : signatureCertificateChain) {
                try {
                    certificateChainType.getX509Certificate().add(cert.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new MessageProcessingException("Error decoding signature certificate certificates : " + e.getMessage());
                }
            }
            t.setSignatureCertificateChain(certificateChainType);
        }
        if (otherResponseInfo != null) {
            AnyType anyType = this.eid2Of.createAnyType();
            anyType.getAny().addAll(otherResponseInfo);
            t.setOtherResponseInfo(anyType);
        }
        return this.eid2Of.createSignResponseExtension(t);
    }

    public SignerAssertionInfoType genSignerAssertionInfo(ContextInfoType contextInfo, AttributeStatementType attributeStatement, List<JAXBElement<AssertionType>> assertions) throws MessageProcessingException {
        ArrayList<byte[]> assertionDatas = null;
        if (assertions != null) {
            assertionDatas = new ArrayList<byte[]>();
            for (JAXBElement<AssertionType> assertion : assertions) {
                assertionDatas.add(this.marshall(assertion));
            }
        }
        return this.genSignerAssertionInfoFromAssertionData(contextInfo, attributeStatement, assertionDatas);
    }

    public SignerAssertionInfoType genSignerAssertionInfoFromAssertionData(ContextInfoType contextInfo, AttributeStatementType attributeStatement, List<byte[]> assertionDatas) {
        SignerAssertionInfoType t = this.eid2Of.createSignerAssertionInfoType();
        t.setContextInfo(contextInfo);
        t.setAttributeStatement(attributeStatement);
        if (assertionDatas != null) {
            SAMLAssertionsType sat = this.eid2Of.createSAMLAssertionsType();
            for (byte[] assertion : assertionDatas) {
                sat.getAssertion().add(assertion);
            }
            t.setSamlAssertions(sat);
        }
        return t;
    }

    public ContextInfoType genContextInfo(NameIDType identityProvider, Date authenticationInstant, String authnContextClassRef, String serviceID, String authType, String assertionRef) throws MessageProcessingException {
        ContextInfoType t = this.eid2Of.createContextInfoType();
        t.setIdentityProvider(identityProvider);
        t.setAuthenticationInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(authenticationInstant));
        t.setAuthnContextClassRef(authnContextClassRef);
        t.setServiceID(serviceID);
        t.setAuthType(authType);
        t.setAssertionRef(assertionRef);
        return t;
    }

    public SignTaskDataType genSignTaskData(String signTaskId, SigType sigType, AdESType adESType, String processingRules, byte[] toBeSignedBytes, AdESObjectType adESObject, byte[] base64Signature, String base64SignatureType, List<Object> otherSignTaskData) throws MessageContentException {
        SignTaskDataType t = this.eid2Of.createSignTaskDataType();
        t.setSignTaskId(signTaskId);
        t.setSigType(sigType.name());
        if (adESType != null) {
            t.setAdESType(adESType.name());
        }
        t.setProcessingRules(processingRules);
        t.setToBeSignedBytes(toBeSignedBytes);
        t.setAdESObject(adESObject);
        if (base64Signature != null) {
            if (base64SignatureType == null) {
                throw new MessageContentException("Error base64Signature must have a defined type");
            }
            Base64SignatureType bt = this.eid2Of.createBase64SignatureType();
            bt.setType(base64SignatureType);
            bt.setValue(base64Signature);
            t.setBase64Signature(bt);
        }
        if (otherSignTaskData != null) {
            AnyType at = this.eid2Of.createAnyType();
            at.getAny().addAll(otherSignTaskData);
            t.setOtherSignTaskData(at);
        }
        return t;
    }

    public JAXBElement<SignTasksType> genSignTasks(List<SignTaskDataType> signTasks) {
        SignTasksType t = this.eid2Of.createSignTasksType();
        t.getSignTaskData().addAll(signTasks);
        return this.eid2Of.createSignTasks(t);
    }

    protected NameIDType genNameIdWithEntityFormat(String value) {
        if (value == null) {
            return null;
        }
        NameIDType t = this.of.createNameIDType();
        t.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        t.setValue(value);
        return t;
    }

    protected Document marshallToDSSDoc(Object object) throws MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getDSSMarshaller().marshal(object, (Node)doc);
            return doc;
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling object: " + e.getMessage(), e);
        }
    }

    protected Marshaller getDSSMarshaller() throws JAXBException {
        if (this.dssMarshaller == null) {
            this.dssMarshaller = this.getDSSJAXBContext().createMarshaller();
            this.dssMarshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        return this.dssMarshaller;
    }

    protected JAXBContext getDSSJAXBContext() throws JAXBException {
        if (this.dssJaxbContext == null) {
            this.dssJaxbContext = JAXBContext.newInstance((String)"org.certificateservices.messages.saml1_1.assertions.jaxb:org.certificateservices.messages.dss1.core.jaxb:org.certificateservices.messages.xmldsig.jaxb");
        }
        return this.dssJaxbContext;
    }

    protected Document marshallToSweEID2ExtensionDoc(Object object) throws MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getSweEID2ExtensionMarshaller().marshal(object, (Node)doc);
            return doc;
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling object: " + e.getMessage(), e);
        }
    }

    protected Marshaller getSweEID2ExtensionMarshaller() throws JAXBException {
        if (this.sweEID2Marshaller == null) {
            this.sweEID2Marshaller = this.getSweEID2ExtensionJAXBContext().createMarshaller();
            this.sweEID2Marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        return this.sweEID2Marshaller;
    }

    protected JAXBContext getSweEID2ExtensionJAXBContext() throws JAXBException {
        if (this.sweEID2JaxbContext == null) {
            this.sweEID2JaxbContext = JAXBContext.newInstance((String)BASE_JAXB_CONTEXT);
        }
        return this.sweEID2JaxbContext;
    }

    static {
        NAMESPACETOPREFIXMAP.put(NAMESPACE, "csig");
        NAMESPACETOPREFIXMAP.put("urn:oasis:names:tc:dss:1.0:core:schema", "dss");
        NAMESPACETOPREFIXMAP.put(BaseSAMLMessageParser.ASSERTION_NAMESPACE, "saml");
        NAMESPACETOPREFIXMAP.put("http://www.w3.org/2000/09/xmldsig#", "ds");
        NAMESPACETOPREFIXMAP.put("http://www.w3.org/2001/04/xmlenc#", "xenc");
        for (String k : NAMESPACETOPREFIXMAP.keySet()) {
            PREFIXTONAMESPACEMAP.put(NAMESPACETOPREFIXMAP.get(k), k);
        }
    }

    public static class SignMessageXMLConverter
    implements XMLEncrypter.DecryptedXMLConverter {
        @Override
        public Document convert(Document doc) throws MessageContentException {
            NodeList nodeList = doc.getElementsByTagNameNS(SweEID2DSSExtensionsMessageParser.NAMESPACE, "EncryptedMessage");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element encMessage = (Element)nodeList.item(i);
                Node message = encMessage.getFirstChild();
                Element parent = (Element)encMessage.getParentNode();
                if (!parent.getLocalName().equals("SignMessage") || !parent.getNamespaceURI().equals(SweEID2DSSExtensionsMessageParser.NAMESPACE)) continue;
                parent.appendChild(message);
                parent.removeChild(encMessage);
            }
            return doc;
        }
    }
}

