/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.EncryptionAlgorithmScheme;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.SigningAlgorithmScheme;
import org.certificateservices.messages.utils.XMLEncrypter;

public class DummyMessageSecurityProvider
implements ContextMessageSecurityProvider {
    private KeyStore dummyKS = null;
    private KeyStore encKeyStore = null;
    private String defaultEncKeyId;
    private Map<String, String> encKeyIdToAlias = new HashMap<String, String>();
    private boolean validCallDone = false;
    private String organisationCalled = null;

    private KeyStore getDummyKeystore() throws MessageProcessingException {
        if (this.dummyKS == null) {
            try {
                this.dummyKS = KeyStore.getInstance("JKS");
                this.dummyKS.load(this.getClass().getResourceAsStream("/dummykeystore.jks"), "tGidBq0Eep".toCharArray());
            }
            catch (Exception e) {
                throw new MessageProcessingException("Error loading dummy key store: " + e.getMessage(), e);
            }
        }
        return this.dummyKS;
    }

    private KeyStore getEncKeystore() throws MessageProcessingException {
        if (this.encKeyStore == null) {
            try {
                this.encKeyStore = KeyStore.getInstance("JKS");
                this.encKeyStore.load(this.getClass().getResourceAsStream("/decryptionks.jks"), "password".toCharArray());
                this.defaultEncKeyId = XMLEncrypter.generateKeyId(this.encKeyStore.getCertificate("key1").getPublicKey());
                this.encKeyIdToAlias.put(this.defaultEncKeyId, "key1");
                this.encKeyIdToAlias.put(XMLEncrypter.generateKeyId(this.encKeyStore.getCertificate("key2").getPublicKey()), "key2");
                this.encKeyIdToAlias.put(XMLEncrypter.generateKeyId(this.encKeyStore.getCertificate("key3").getPublicKey()), "key3");
            }
            catch (Exception e) {
                throw new MessageProcessingException("Error loading dummy enc key store: " + e.getMessage(), e);
            }
        }
        return this.encKeyStore;
    }

    @Override
    public PrivateKey getSigningKey() throws MessageProcessingException {
        return this.getSigningKey(DEFAULT_CONTEXT);
    }

    @Override
    public PrivateKey getSigningKey(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        try {
            return (PrivateKey)this.getDummyKeystore().getKey("test", "tGidBq0Eep".toCharArray());
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error fetching dummy signing key: " + e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate getSigningCertificate() throws IllegalArgumentException, MessageProcessingException {
        return this.getSigningCertificate(DEFAULT_CONTEXT);
    }

    @Override
    public X509Certificate getSigningCertificate(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        try {
            return (X509Certificate)this.getDummyKeystore().getCertificate("test");
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error fetching dummy signing certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isValidAndAuthorized(X509Certificate signCertificate, String organisation) throws IllegalArgumentException, MessageProcessingException {
        return this.isValidAndAuthorized(DEFAULT_CONTEXT, signCertificate, organisation);
    }

    @Override
    public boolean isValidAndAuthorized(ContextMessageSecurityProvider.Context context, X509Certificate signCertificate, String organisation) throws IllegalArgumentException, MessageProcessingException {
        if (signCertificate == null) {
            throw new IllegalArgumentException("Error sign certificate cannot be null when validating.");
        }
        boolean[] keyUsage = signCertificate.getKeyUsage();
        if (!keyUsage[0]) {
            return false;
        }
        this.validCallDone = true;
        this.organisationCalled = organisation;
        return true;
    }

    public void resetCounters() {
        this.validCallDone = false;
        this.organisationCalled = null;
    }

    public boolean getValidCallDone() {
        return this.validCallDone;
    }

    public String getOrganisationCalled() {
        return this.organisationCalled;
    }

    @Override
    public PrivateKey getDecryptionKey(String keyId) throws MessageProcessingException {
        return this.getDecryptionKey(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public PrivateKey getDecryptionKey(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        String alias;
        KeyStore encKeyStore = this.getEncKeystore();
        if (keyId == DEFAULT_DECRYPTIONKEY) {
            keyId = this.defaultEncKeyId;
        }
        if ((alias = this.encKeyIdToAlias.get(keyId)) == null) {
            throw new MessageProcessingException("Error no decryption key with key id; " + keyId + " found in message security provider");
        }
        try {
            return (PrivateKey)encKeyStore.getKey(alias, "password".toCharArray());
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error no decryption key with key id; " + keyId + " found in message security provider");
        }
    }

    @Override
    public X509Certificate getDecryptionCertificate(String keyId) throws MessageProcessingException {
        return this.getDecryptionCertificate(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public X509Certificate getDecryptionCertificate(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        String alias;
        KeyStore encKeyStore = this.getEncKeystore();
        if (keyId == DEFAULT_DECRYPTIONKEY) {
            keyId = this.defaultEncKeyId;
        }
        if ((alias = this.encKeyIdToAlias.get(keyId)) == null) {
            throw new MessageProcessingException("Error no decryption key with key id; " + keyId + " found in message security provider");
        }
        try {
            return (X509Certificate)encKeyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error no decryption key with key id; " + keyId + " found in message security provider");
        }
    }

    @Override
    public X509Certificate[] getDecryptionCertificateChain(String keyId) throws MessageProcessingException {
        return this.getDecryptionCertificateChain(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public X509Certificate[] getDecryptionCertificateChain(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        String alias;
        KeyStore encKeyStore = this.getEncKeystore();
        if (keyId == DEFAULT_DECRYPTIONKEY) {
            keyId = this.defaultEncKeyId;
        }
        if ((alias = this.encKeyIdToAlias.get(keyId)) == null) {
            throw new MessageProcessingException("Error no decryption key with key id; " + keyId + " found in message security provider");
        }
        try {
            Certificate[] certChain = encKeyStore.getCertificateChain(alias);
            return (X509Certificate[])Arrays.copyOf(certChain, certChain.length, X509Certificate[].class);
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error no decryption key with key id; " + keyId + " found in message security provider");
        }
    }

    @Override
    public Set<String> getDecryptionKeyIds() throws MessageProcessingException {
        return this.getDecryptionKeyIds(DEFAULT_CONTEXT);
    }

    @Override
    public Set<String> getDecryptionKeyIds(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        this.getEncKeystore();
        return this.encKeyIdToAlias.keySet();
    }

    @Override
    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme() throws MessageProcessingException {
        return this.getEncryptionAlgorithmScheme(DEFAULT_CONTEXT);
    }

    @Override
    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return EncryptionAlgorithmScheme.RSA_OAEP_WITH_AES256;
    }

    @Override
    public SigningAlgorithmScheme getSigningAlgorithmScheme() throws MessageProcessingException {
        return this.getSigningAlgorithmScheme(DEFAULT_CONTEXT);
    }

    @Override
    public SigningAlgorithmScheme getSigningAlgorithmScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return SigningAlgorithmScheme.RSAWithSHA256;
    }
}

