/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

public enum EncryptionAlgorithmScheme {
    RSA_PKCS1_5_WITH_AES128("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5"),
    RSA_OAEP_WITH_AES128("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"),
    RSA_PKCS1_5_WITH_AES192("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5"),
    RSA_OAEP_WITH_AES192("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"),
    RSA_PKCS1_5_WITH_AES256("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5"),
    RSA_OAEP_WITH_AES256("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");

    String dataEncryptionAlgorithmURI;
    String keyEncryptionAlgorithmURI;

    private EncryptionAlgorithmScheme(String dataEncryptionAlgorithmURI, String keyEncryptionAlgorithmURI) {
        this.dataEncryptionAlgorithmURI = dataEncryptionAlgorithmURI;
        this.keyEncryptionAlgorithmURI = keyEncryptionAlgorithmURI;
    }

    public String getDataEncryptionAlgorithmURI() {
        return this.dataEncryptionAlgorithmURI;
    }

    public String getKeyEncryptionAlgorithmURI() {
        return this.keyEncryptionAlgorithmURI;
    }

    public static EncryptionAlgorithmScheme getByName(String name) {
        if (name != null) {
            for (EncryptionAlgorithmScheme e : EncryptionAlgorithmScheme.values()) {
                if (!e.name().equalsIgnoreCase(name.trim())) continue;
                return e;
            }
        }
        return null;
    }
}

