/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.CSMessageParserManager;
import org.certificateservices.messages.csmessages.PayloadParser;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.CSResponse;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.IsApprovedResponseType;
import org.certificateservices.messages.csmessages.jaxb.ObjectFactory;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;

public abstract class BasePayloadParser
implements PayloadParser {
    protected Properties config;
    protected MessageSecurityProvider secProv;
    protected CSMessageParser customCSMessageParser;
    protected ObjectFactory csMessageObjectFactory = new ObjectFactory();
    protected String payloadVersion = this.getDefaultPayloadVersion();

    @Override
    public void init(Properties config, MessageSecurityProvider secProv) throws MessageProcessingException {
        this.config = config;
        this.secProv = secProv;
    }

    public void init(Properties config, MessageSecurityProvider secProv, CSMessageParser customCSMessageParser) throws MessageProcessingException {
        this.config = config;
        this.secProv = secProv;
        this.customCSMessageParser = customCSMessageParser;
    }

    protected CSMessageParser getCSMessageParser() throws MessageProcessingException {
        if (this.customCSMessageParser != null) {
            return this.customCSMessageParser;
        }
        return CSMessageParserManager.getCSMessageParser();
    }

    public CSMessage parseMessage(byte[] messageData) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().parseMessage(messageData);
    }

    public CSMessage parseMessage(byte[] messageData, boolean performValidation) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().parseMessage(messageData, performValidation);
    }

    public CSMessage parseMessage(byte[] messageData, boolean performValidation, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().parseMessage(messageData, performValidation, requireSignature);
    }

    public RequestStatus getResponseStatus(CSMessage csMessage) throws MessageContentException {
        try {
            Object responsePayload = csMessage.getPayload().getAny();
            if (responsePayload instanceof JAXBElement && ((JAXBElement)responsePayload).getValue() instanceof CSResponse) {
                return ((CSResponse)((JAXBElement)responsePayload).getValue()).getStatus();
            }
            if (responsePayload instanceof CSResponse) {
                return ((CSResponse)responsePayload).getStatus();
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing CSResponse status from message: " + e.getMessage(), e);
        }
        throw new MessageContentException("Error parsing CSResponse status from message, make sure it is a CSResponse.");
    }

    public Object getPayload(CSMessage csMessage) throws MessageContentException {
        try {
            Object responsePayload = csMessage.getPayload().getAny();
            if (responsePayload instanceof JAXBElement) {
                return ((JAXBElement)csMessage.getPayload().getAny()).getValue();
            }
            return responsePayload;
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing payload from message: " + e.getMessage(), e);
        }
    }

    public List<Object> getAssertions(IsApprovedResponseType isApprovedResponse) {
        if (isApprovedResponse.getAssertions() != null && isApprovedResponse.getAssertions().size() > 0) {
            return isApprovedResponse.getAssertions().get(0).getAny();
        }
        return null;
    }

    public byte[] generateGetApprovalRequest(String requestId, String destinationId, String organisation, byte[] requestMessage, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateGetApprovalRequest(requestId, destinationId, organisation, requestMessage, originator, assertions);
    }

    public byte[] generateIsApprovedRequest(String requestId, String destinationId, String organisation, String approvalId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.getCSMessageParser().generateIsApprovedRequest(requestId, destinationId, organisation, approvalId, originator, assertions);
    }

    protected abstract String[] getSupportedVersions();

    protected abstract String getDefaultPayloadVersion();

    protected void isPayloadVersionSupported(String payloadVersion) throws MessageContentException {
        for (String supportedVersion : this.getSupportedVersions()) {
            if (!supportedVersion.equals(payloadVersion)) continue;
            return;
        }
        throw new MessageContentException("Unsupported Payload version: " + payloadVersion + " for PayLoadParser " + this.getClass().getSimpleName());
    }

    public String getPayloadVersion() {
        return this.payloadVersion;
    }

    public void setPayloadVersion(String payloadVersion) {
        this.payloadVersion = payloadVersion;
    }

    @Override
    public String[] getRelatedSchemas(String payloadVersion) {
        return new String[0];
    }
}

