/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.saml2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.assertion.ResponseStatusCodes;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.saml2.SAMLParserCustomisations;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AudienceRestrictionType;
import org.certificateservices.messages.saml2.assertion.jaxb.ConditionAbstractType;
import org.certificateservices.messages.saml2.assertion.jaxb.ConditionsType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.saml2.assertion.jaxb.ObjectFactory;
import org.certificateservices.messages.saml2.assertion.jaxb.OneTimeUseType;
import org.certificateservices.messages.saml2.protocol.jaxb.ExtensionsType;
import org.certificateservices.messages.saml2.protocol.jaxb.ResponseType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusCodeType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusType;
import org.certificateservices.messages.utils.CSMessageUtils;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.SystemTime;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.utils.XMLSigner;
import org.certificateservices.messages.xmldsig.jaxb.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public abstract class BaseSAMLMessageParser {
    public static String SETTING_CUSTOM_JAXBCLASSPATH = "jaxb.customclasspath";
    public static String SETTING_CUSTOM_SCHEMALOCATIONS = "jaxb.customschemas";
    public static String ASSERTION_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:assertion";
    public static String PROTOCOL_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:protocol";
    public static String DEFAULT_SAML_VERSION = "2.0";
    public static final String ASSERTION_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs-message-saml-schema-assertion-2.0.xsd";
    public static final String SAMLP_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs-message-saml-schema-protocol-2.0.xsd";
    protected String customJAXBClasspath = null;
    protected String[] customSchemaLocations = new String[0];
    protected ObjectFactory of = new ObjectFactory();
    protected org.certificateservices.messages.saml2.protocol.jaxb.ObjectFactory samlpOf = new org.certificateservices.messages.saml2.protocol.jaxb.ObjectFactory();
    protected org.certificateservices.messages.xmldsig.jaxb.ObjectFactory dsigOf = new org.certificateservices.messages.xmldsig.jaxb.ObjectFactory();
    protected SystemTime systemTime = new DefaultSystemTime();
    protected XMLEncrypter xmlEncrypter;
    EncryptedAttributeXMLConverter encryptedAttributeXMLConverter = new EncryptedAttributeXMLConverter();
    protected XMLSigner xmlSigner;
    protected CertificateFactory cf;
    protected SAMLParserCustomisations customisations;
    protected MessageSecurityProvider messageSecurityProvider;
    protected Validator schemaValidator;
    protected AssertionSignatureLocationFinder assertionSignatureLocationFinder = new AssertionSignatureLocationFinder();
    protected SAMLPSignatureLocationFinder samlpSignatureLocationFinder = new SAMLPSignatureLocationFinder();
    private Schema schema = null;
    private JAXBContext jaxbContext = null;

    public void init(MessageSecurityProvider secProv) throws MessageProcessingException {
        this.init(secProv, null);
    }

    public void init(MessageSecurityProvider secProv, SAMLParserCustomisations customisations) throws MessageProcessingException {
        try {
            this.customisations = customisations;
            if (customisations != null) {
                this.customJAXBClasspath = customisations.getCustomJAXBClasspath();
                this.customSchemaLocations = customisations.getCustomSchemaLocations();
            }
            this.messageSecurityProvider = secProv;
            this.xmlEncrypter = new XMLEncrypter(secProv, this.getDocumentBuilder(), this.getMarshaller(), this.getUnmarshaller());
            this.xmlSigner = new XMLSigner(secProv, this.getDocumentBuilder(), true, this.getSignatureLocationFinder(), this.getOrganisationLookup());
            this.cf = CertificateFactory.getInstance("X.509");
            this.schemaValidator = this.generateSchema().newValidator();
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initializing JAXB in SAMLMessageParser: " + e.getMessage(), e);
        }
    }

    public abstract String getNameSpace();

    protected abstract String getJAXBPackages();

    protected abstract String[] getDefaultSchemaLocations() throws SAXException;

    protected abstract XMLSigner.SignatureLocationFinder getSignatureLocationFinder();

    protected abstract XMLSigner.OrganisationLookup getOrganisationLookup();

    protected abstract String lookupSchemaForElement(String var1, String var2, String var3, String var4, String var5);

    private Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = this.generateSchema();
        }
        return this.schema;
    }

    public Schema generateSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new BaseLSResourceResolver(this.customisations));
        String[] defaultSchemaLocations = this.getDefaultSchemaLocations();
        int index = 0;
        Source[] sources = new Source[defaultSchemaLocations.length + (this.customSchemaLocations != null ? this.customSchemaLocations.length : 0)];
        for (String schemaLocation : defaultSchemaLocations) {
            sources[index++] = new StreamSource(this.getClass().getResourceAsStream(schemaLocation));
        }
        if (this.customSchemaLocations != null) {
            for (String schemaLocation : this.customSchemaLocations) {
                sources[index++] = new StreamSource(this.getClass().getResourceAsStream(schemaLocation));
            }
        }
        return schemaFactory.newSchema(sources);
    }

    public void schemaValidate(Object message) throws MessageContentException {
        try {
            this.schemaValidator.validate((Source)new JAXBSource(this.getJAXBContext(), message));
        }
        catch (Exception e) {
            throw new MessageContentException("Error validating Assertion agains schema: " + e.getMessage(), e);
        }
    }

    public Object parseMessage(ContextMessageSecurityProvider.Context context, byte[] message, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        try {
            if (requireSignature) {
                this.xmlSigner.verifyEnvelopedSignature(context, message, this.getSignatureLocationFinder(), this.getOrganisationLookup());
            }
            return this.unmarshall(message);
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error parsing SAML Message Data: " + e.getMessage(), e);
        }
    }

    public byte[] genFailureMessage(ContextMessageSecurityProvider.Context context, String inResponseTo, ResponseStatusCodes statusCode, String failureMessage) throws MessageContentException, MessageProcessingException {
        return this.genFailureMessage(context, inResponseTo, null, null, null, null, statusCode, failureMessage, false);
    }

    public byte[] genFailureMessage(ContextMessageSecurityProvider.Context context, String inResponseTo, NameIDType issuer, String destination, String consent, ExtensionsType extensions, ResponseStatusCodes statusCode, String failureMessage, boolean signSAMLPResponse) throws MessageContentException, MessageProcessingException {
        try {
            StatusCodeType statusCodeType = this.samlpOf.createStatusCodeType();
            statusCodeType.setValue(statusCode.getURIValue());
            StatusType statusType = this.samlpOf.createStatusType();
            statusType.setStatusCode(statusCodeType);
            if (failureMessage != null) {
                statusType.setStatusMessage(failureMessage);
            }
            ResponseType responseType = this.samlpOf.createResponseType();
            responseType.setID("_" + MessageGenerateUtils.generateRandomUUID());
            responseType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
            responseType.setVersion(DEFAULT_SAML_VERSION);
            responseType.setInResponseTo(inResponseTo);
            responseType.setStatus(statusType);
            responseType.setIssuer(issuer);
            responseType.setDestination(destination);
            responseType.setConsent(consent);
            responseType.setExtensions(extensions);
            JAXBElement<ResponseType> response = this.samlpOf.createResponse(responseType);
            if (signSAMLPResponse) {
                return this.marshallAndSignSAMLPOrAssertion(context, response, false, true);
            }
            return this.marshall(response);
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error generation SAMLP Failure Message: " + e.getMessage(), e);
        }
    }

    public X509Certificate getCertificateFromAssertion(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        for (Object next : ((AssertionType)assertion.getValue()).getSignature().getKeyInfo().getContent()) {
            if (!(next instanceof JAXBElement) || !(((JAXBElement)next).getValue() instanceof X509DataType)) continue;
            for (Object nextX509Data : ((X509DataType)((JAXBElement)next).getValue()).getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                JAXBElement jaxbElement;
                if (!(nextX509Data instanceof JAXBElement) || !(jaxbElement = (JAXBElement)nextX509Data).getName().getLocalPart().equals("X509Certificate") || !jaxbElement.getName().getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
                try {
                    return (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream((byte[])jaxbElement.getValue()));
                }
                catch (CertificateException e) {
                    throw new MessageContentException("Error parsing certificate from digital signature: " + e.getMessage(), e);
                }
            }
        }
        throw new MessageContentException("Error parsing certificate from digital signature, no certificate found in KeyInfo data,");
    }

    public JAXBElement<AssertionType> getAssertionFromResponseType(ResponseType responseType) {
        if (responseType.getAssertionOrEncryptedAssertion().size() == 0) {
            return null;
        }
        return this.of.createAssertion((AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0));
    }

    public JAXBElement<AssertionType> decryptAssertion(ContextMessageSecurityProvider.Context context, JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getMarshaller().marshal(assertion, (Node)doc);
            JAXBElement decryptedAssertion = (JAXBElement)this.xmlEncrypter.decryptDocument(context, doc, this.encryptedAttributeXMLConverter);
            this.schemaValidate(decryptedAssertion);
            return decryptedAssertion;
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error parsing assertion : " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
    }

    public void verifyAssertionConditions(AssertionType assertionType, ConditionLookup conditionLookup) throws MessageContentException {
        try {
            ConditionsType conditionsType = assertionType.getConditions();
            if (conditionsType != null) {
                this.verifyConditions(conditionsType, "Assertion", assertionType.getID(), conditionLookup);
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            throw new MessageContentException("Error verifying conditions on assertion ticket: " + e.getMessage(), e);
        }
    }

    public void verifyConditions(ConditionsType conditions, String type, String messageId, ConditionLookup conditionLookup) throws MessageContentException {
        try {
            long clockSkew = conditionLookup.acceptedClockSkew();
            Date notBefore = new Date(MessageGenerateUtils.xMLGregorianCalendarToDate(conditions.getNotBefore()).getTime() - clockSkew);
            Date notOnOrAfter = new Date(MessageGenerateUtils.xMLGregorianCalendarToDate(conditions.getNotOnOrAfter()).getTime() + clockSkew);
            Date currentTime = this.systemTime.getSystemTime();
            if (notBefore.after(currentTime)) {
                throw new MessageContentException("Error " + type + " not yet valid, not valid until: " + notBefore);
            }
            if (notOnOrAfter.before(currentTime) || notOnOrAfter.equals(currentTime)) {
                throw new MessageContentException("Error " + type + " has expired on: " + notOnOrAfter);
            }
            for (ConditionAbstractType cat : conditions.getConditionOrAudienceRestrictionOrOneTimeUse()) {
                if (cat instanceof OneTimeUseType && conditionLookup.usedBefore(messageId)) {
                    throw new MessageContentException("Error " + type + " has been used before and contains OneTime condition");
                }
                if (!(cat instanceof AudienceRestrictionType)) continue;
                AudienceRestrictionType art = (AudienceRestrictionType)cat;
                String thisAudienceId = conditionLookup.getThisAudienceId();
                boolean foundMatch = false;
                for (String audience : art.getAudience()) {
                    if (!audience.equals(thisAudienceId)) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                throw new MessageContentException("Error " + type + " not did not fullfill audience restriction condition");
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            throw new MessageContentException("Error verifying conditions on assertion ticket: " + e.getMessage(), e);
        }
    }

    public JAXBElement<ResponseType> genSuccessfulSAMLPResponse(String inResponseTo, JAXBElement<AssertionType> assertion) throws MessageProcessingException {
        StatusCodeType statusCodeType = this.samlpOf.createStatusCodeType();
        statusCodeType.setValue(ResponseStatusCodes.SUCCESS.getURIValue());
        StatusType statusType = this.samlpOf.createStatusType();
        statusType.setStatusCode(statusCodeType);
        ResponseType responseType = this.samlpOf.createResponseType();
        responseType.setID("_" + MessageGenerateUtils.generateRandomUUID());
        responseType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
        responseType.setVersion(DEFAULT_SAML_VERSION);
        responseType.setInResponseTo(inResponseTo);
        responseType.setStatus(statusType);
        responseType.getAssertionOrEncryptedAssertion().add(assertion.getValue());
        return this.samlpOf.createResponse(responseType);
    }

    protected JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((String)(this.getJAXBPackages() + (this.customJAXBClasspath == null ? "" : ":" + this.customJAXBClasspath)));
        }
        return this.jaxbContext;
    }

    public byte[] marshall(Object message) throws MessageProcessingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMarshaller().marshal(message, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error occurred marshalling object: " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
    }

    protected Object unmarshall(byte[] message) throws MessageProcessingException, MessageContentException {
        try {
            Object object = this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(message));
            if (object instanceof JAXBElement) {
                return ((JAXBElement)object).getValue();
            }
            return object;
        }
        catch (SAXException e) {
            throw new MessageContentException("Error occurred during SAML unmarshaller: " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error occurred during SAML unmarshaller: " + CSMessageUtils.getMarshallingExceptionMessage((Exception)((Object)e)), e);
        }
    }

    public byte[] marshallAndSign(ContextMessageSecurityProvider.Context context, Object message) throws MessageProcessingException, MessageContentException {
        if (message == null) {
            throw new MessageProcessingException("Error marshalling assertion, message cannot be null.");
        }
        Document doc = this.getDocumentBuilder().newDocument();
        try {
            this.getMarshaller().marshal(message, (Node)doc);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling message " + e.getMessage(), e);
        }
        this.xmlSigner.sign(context, doc, this.getSignatureLocationFinder());
        return this.xmlSigner.marshallDoc(doc);
    }

    public byte[] marshallDoc(Document doc) throws MessageProcessingException, MessageContentException {
        return this.xmlSigner.marshallDoc(doc);
    }

    public Document unmarshallDoc(byte[] message) throws MessageContentException, MessageProcessingException {
        try {
            return this.getDocumentBuilder().parse(new ByteArrayInputStream(message));
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error converting message into Document: " + e.getMessage(), e);
        }
    }

    protected byte[] marshallAndSignSAMLPOrAssertion(ContextMessageSecurityProvider.Context context, JAXBElement<?> message, boolean signAssertion, boolean signSAMLP) throws MessageProcessingException, MessageContentException {
        if (message == null) {
            throw new MessageProcessingException("Error marshalling assertion, message cannot be null.");
        }
        Document doc = this.getDocumentBuilder().newDocument();
        try {
            this.getMarshaller().marshal(message, (Node)doc);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling message " + e.getMessage(), e);
        }
        if (signAssertion) {
            this.xmlSigner.sign(context, doc, this.assertionSignatureLocationFinder);
        }
        if (signSAMLP) {
            this.xmlSigner.sign(context, doc, this.samlpSignatureLocationFinder);
        }
        return this.xmlSigner.marshallDoc(doc);
    }

    protected DocumentBuilder getDocumentBuilder() throws MessageProcessingException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error creating Documentbuilder, ParserConfigurationException: " + e.getMessage());
        }
    }

    protected Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    protected Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setSchema(this.getSchema());
        return unmarshaller;
    }

    public static class SimpleConditionLookup
    implements ConditionLookup {
        long clockSkew = 0L;

        public SimpleConditionLookup() {
        }

        public SimpleConditionLookup(long clockSkew) {
            this.clockSkew = clockSkew;
        }

        @Override
        public boolean usedBefore(String messageId) throws MessageContentException, MessageProcessingException {
            throw new MessageContentException("OneTime Condition is not supported.");
        }

        @Override
        public String getThisAudienceId() throws MessageContentException, MessageProcessingException {
            throw new MessageContentException("AudienceRestriction Condition is not supported.");
        }

        @Override
        public long acceptedClockSkew() throws MessageProcessingException {
            return this.clockSkew;
        }
    }

    public static interface ConditionLookup {
        public boolean usedBefore(String var1) throws MessageContentException, MessageProcessingException;

        public String getThisAudienceId() throws MessageContentException, MessageProcessingException;

        public long acceptedClockSkew() throws MessageProcessingException;
    }

    protected class BaseLSResourceResolver
    implements LSResourceResolver {
        private SAMLParserCustomisations customizations;

        public BaseLSResourceResolver(SAMLParserCustomisations customizations) {
            this.customizations = customizations;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                String retval = null;
                if (this.customizations != null) {
                    retval = this.customizations.lookupSchemaForElement(type, namespaceURI, publicId, systemId, baseURI);
                }
                if (retval == null) {
                    retval = BaseSAMLMessageParser.this.lookupSchemaForElement(type, namespaceURI, publicId, systemId, baseURI);
                }
                if (retval != null) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(retval));
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }

    public static class SAMLPSignatureLocationFinder
    implements XMLSigner.SignatureLocationFinder {
        @Override
        public Element[] getSignatureLocations(Document doc) throws MessageContentException {
            try {
                if (doc.getDocumentElement().getNamespaceURI().equals(PROTOCOL_NAMESPACE)) {
                    return new Element[]{doc.getDocumentElement()};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageContentException("Invalid SAMLP message type sent for signature.");
        }

        @Override
        public String getIDAttribute() {
            return "ID";
        }

        @Override
        public String getIDValue(Element signedElement) throws MessageContentException {
            return signedElement.getAttribute(this.getIDAttribute());
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            ArrayList<QName> beforeSiblings = new ArrayList<QName>();
            beforeSiblings.add(new QName(PROTOCOL_NAMESPACE, "Extensions"));
            beforeSiblings.add(new QName(PROTOCOL_NAMESPACE, "Status"));
            return beforeSiblings;
        }
    }

    public static class AssertionSignatureLocationFinder
    implements XMLSigner.SignatureLocationFinder {
        @Override
        public Element[] getSignatureLocations(Document doc) throws MessageContentException {
            try {
                if (doc.getDocumentElement().getLocalName().equals("Assertion")) {
                    return new Element[]{doc.getDocumentElement()};
                }
                if (doc.getDocumentElement().getLocalName().equals("Response")) {
                    NodeList nl = doc.getElementsByTagNameNS(ASSERTION_NAMESPACE, "Assertion");
                    if (nl.getLength() == 0) {
                        throw new MessageContentException("No assertion was found in response.");
                    }
                    Element[] result = new Element[nl.getLength()];
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = (Element)nl.item(i);
                    }
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageContentException("Invalid assertion message type sent for signature.");
        }

        @Override
        public String getIDAttribute() {
            return "ID";
        }

        @Override
        public String getIDValue(Element signedElement) throws MessageContentException {
            return signedElement.getAttribute(this.getIDAttribute());
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            ArrayList<QName> beforeSiblings = new ArrayList<QName>();
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "Subject"));
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "Conditions"));
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "Advice"));
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "Statement"));
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "AuthnStatement"));
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "AuthzDecisionStatement"));
            beforeSiblings.add(new QName(ASSERTION_NAMESPACE, "AttributeStatement"));
            return beforeSiblings;
        }
    }

    public static class EncryptedAttributeXMLConverter
    implements XMLEncrypter.DecryptedXMLConverter {
        @Override
        public Document convert(Document doc) throws MessageContentException {
            NodeList nodeList = doc.getElementsByTagNameNS(ASSERTION_NAMESPACE, "Attribute");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element attribute = (Element)nodeList.item(i);
                Element parent = (Element)attribute.getParentNode();
                if (!parent.getLocalName().equals("EncryptedAttribute") || !parent.getNamespaceURI().equals(ASSERTION_NAMESPACE)) continue;
                parent.getParentNode().replaceChild(attribute, parent);
            }
            return doc;
        }
    }
}

