/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.sysconfig;

import java.io.InputStream;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.sysconfig.jaxb.GetActiveConfigurationRequest;
import org.certificateservices.messages.sysconfig.jaxb.GetActiveConfigurationResponse;
import org.certificateservices.messages.sysconfig.jaxb.ObjectFactory;
import org.certificateservices.messages.sysconfig.jaxb.PublishConfigurationRequest;
import org.certificateservices.messages.sysconfig.jaxb.PublishConfigurationResponse;
import org.certificateservices.messages.sysconfig.jaxb.SystemConfiguration;

public class SysConfigPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/sysconfig2_0";
    private static final String SYSCONFIG_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/sysconfig_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_SYSCONFIG_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_SYSCONFIG_VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.sysconfig.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_SYSCONFIG_VERSION)) {
            return this.getClass().getResourceAsStream(SYSCONFIG_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported SysConfig Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_SYSCONFIG_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_SYSCONFIG_VERSION;
    }

    public byte[] generateGetActiveConfigurationRequest(String requestId, String destinationId, String organisation, String application, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetActiveConfigurationRequest payload = this.of.createGetActiveConfigurationRequest();
        payload.setApplication(application);
        payload.setOrganisationShortName(organisation);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateGetActiveConfigurationResponse(String relatedEndEntity, CSMessage request, SystemConfiguration systemConfiguration, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetActiveConfigurationResponse response = this.of.createGetActiveConfigurationResponse();
        response.setSystemConfiguration(systemConfiguration);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] generatePublishConfigurationRequest(String requestId, String destinationId, String organisation, SystemConfiguration systemConfiguration, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        PublishConfigurationRequest payload = this.of.createPublishConfigurationRequest();
        payload.setSystemConfiguration(systemConfiguration);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generatePublishConfigurationResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        PublishConfigurationResponse response = this.of.createPublishConfigurationResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }
}

