/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.certificateservices.messages.EncryptionAlgorithmScheme;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.SigningAlgorithmScheme;

public interface ContextMessageSecurityProvider
extends MessageSecurityProvider {
    public static final Context DEFAULT_CONTEXT = null;

    public PrivateKey getSigningKey(Context var1) throws MessageProcessingException;

    public X509Certificate getSigningCertificate(Context var1) throws MessageProcessingException;

    public PrivateKey getDecryptionKey(Context var1, String var2) throws MessageProcessingException;

    public X509Certificate getDecryptionCertificate(Context var1, String var2) throws MessageProcessingException;

    public X509Certificate[] getDecryptionCertificateChain(Context var1, String var2) throws MessageProcessingException;

    public Set<String> getDecryptionKeyIds(Context var1) throws MessageProcessingException;

    public boolean isValidAndAuthorized(Context var1, X509Certificate var2, String var3) throws IllegalArgumentException, MessageProcessingException;

    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme(Context var1) throws MessageProcessingException;

    public SigningAlgorithmScheme getSigningAlgorithmScheme(Context var1) throws MessageProcessingException;

    public String getProvider(Context var1);

    public static class Context {
        private String usage;
        private String relatedOrganisation;
        private Map<String, Object> properties;

        public Context(String usage) {
            this.usage = usage;
        }

        public Context(String usage, String relatedOrganisation) {
            this.relatedOrganisation = relatedOrganisation;
            this.usage = usage;
        }

        public Context(String usage, String relatedOrganisation, Map<String, Object> properties) {
            this.usage = usage;
            this.relatedOrganisation = relatedOrganisation;
            this.properties = properties;
        }

        public String getUsage() {
            return this.usage;
        }

        public void setUsage(String usage) {
            this.usage = usage;
        }

        public String getRelatedOrganisation() {
            return this.relatedOrganisation;
        }

        public void setRelatedOrganisation(String relatedOrganisation) {
            this.relatedOrganisation = relatedOrganisation;
        }

        public Map<String, Object> getProperties() {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            if (this.usage != null ? !this.usage.equals(context.usage) : context.usage != null) {
                return false;
            }
            if (this.relatedOrganisation != null ? !this.relatedOrganisation.equals(context.relatedOrganisation) : context.relatedOrganisation != null) {
                return false;
            }
            return this.properties != null ? this.properties.equals(context.properties) : context.properties == null;
        }

        public int hashCode() {
            int result = this.usage != null ? this.usage.hashCode() : 0;
            result = 31 * result + (this.relatedOrganisation != null ? this.relatedOrganisation.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Context{usage='" + this.usage + '\'' + ", relatedOrganisation='" + this.relatedOrganisation + '\'' + ", properties=" + this.properties + '}';
        }
    }
}

