/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import org.certificateservices.messages.PKCS11ProviderManager;

public class DefaultPKCS11ProviderManager
implements PKCS11ProviderManager {
    private Provider pkcs11Provider = null;

    public static Provider createPKCS11Provider(InputStream config) throws SecurityException, NullPointerException, ProviderException {
        try {
            if (DefaultPKCS11ProviderManager.isJavaVersion9OrHigher()) {
                Provider prototypeProvider = Security.getProvider("SunPKCS11");
                String configString = DefaultPKCS11ProviderManager.readInputStream(config);
                Method configureMethod = prototypeProvider.getClass().getDeclaredMethod("configure", String.class);
                return (Provider)configureMethod.invoke((Object)prototypeProvider, "--" + configString);
            }
            Class<?> SunPKCS11 = DefaultPKCS11ProviderManager.class.getClassLoader().loadClass("sun.security.pkcs11.SunPKCS11");
            Constructor<?> constructor = SunPKCS11.getConstructor(InputStream.class);
            return (Provider)constructor.newInstance(config);
        }
        catch (Exception e) {
            throw new ProviderException("Failed to create instance of SunPKCS11: " + e.getMessage(), e);
        }
    }

    @Override
    public String addPKCS11Provider(InputStream config) throws SecurityException, NullPointerException, ProviderException {
        try {
            this.pkcs11Provider = DefaultPKCS11ProviderManager.createPKCS11Provider(config);
        }
        catch (Exception e) {
            throw new ProviderException("Failed to create instance of SunPKCS11: " + e.getMessage(), e);
        }
        if (this.pkcs11Provider != null) {
            Security.addProvider(this.pkcs11Provider);
            return this.pkcs11Provider.getName();
        }
        return null;
    }

    @Override
    public KeyStore loadPKCS11Keystore(char[] password) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS11", this.pkcs11Provider);
        keyStore.load(null, password);
        return keyStore;
    }

    private static boolean isJavaVersion9OrHigher() {
        String version = System.getProperty("java.version");
        return Integer.parseInt(version.split("\\.")[0]) >= 9;
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

