/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.DefaultPKCS11ProviderManager;
import org.certificateservices.messages.EncryptionAlgorithmScheme;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.PKCS11ProviderManager;
import org.certificateservices.messages.SigningAlgorithmScheme;
import org.certificateservices.messages.TruststoreHelper;
import org.certificateservices.messages.utils.SettingsUtils;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.utils.XMLSigner;

public class PKCS11MessageSecurityProvider
implements ContextMessageSecurityProvider {
    Logger log = Logger.getLogger(PKCS11MessageSecurityProvider.class.getName());
    public static final String SETTING_PREFIX = "pkcs11securityprovider";
    static final String SETTING_PKCS11_LIBRARY = "pkcs11securityprovider.library.path";
    static final String SETTING_PKCS11_SLOT = "pkcs11securityprovider.slot";
    static final String SETTING_PKCS11_SLOT_PASSWORD = "pkcs11securityprovider.password";
    static final String SETTING_SIGNINGKEY_ALIAS = "pkcs11securityprovider.signingkey.alias";
    static final String SETTING_DECRYPTKEY_DEFAULT_ALIAS = "pkcs11securityprovider.decryptkey.default.alias";
    public static final String SETTING_TRUSTSTORE_PATH = "pkcs11securityprovider.trustkeystore.path";
    public static final String SETTING_TRUSTSTORE_PASSWORD = "pkcs11securityprovider.trustkeystore.password";
    static final String SETTING_SIGNATURE_ALGORITHM_SCHEME = "pkcs11securityprovider.signature.algorithm";
    static final SigningAlgorithmScheme DEFAULT_SIGNATURE_ALGORITHM_SCHEME = SigningAlgorithmScheme.RSAWithSHA256;
    static final String SETTING_ENCRYPTION_ALGORITHM_SCHEME = "pkcs11securityprovider.encryption.algorithm";
    static final EncryptionAlgorithmScheme DEFAULT_ENCRYPTION_ALGORITHM_SCHEME = EncryptionAlgorithmScheme.RSA_OAEP_WITH_AES256;
    private KeyStore pkcs11Keystore;
    private KeyStore trustStore;
    private String pkcs11Password;
    private String pkcs11Provider;
    private SigningAlgorithmScheme signingAlgorithmScheme;
    private EncryptionAlgorithmScheme encryptionAlgorithmScheme;
    private X509Certificate signingCertificate;
    private PrivateKey signingKey;
    private Map<String, X509Certificate[]> decryptionCertificates = new HashMap<String, X509Certificate[]>();
    private Map<String, PrivateKey> decryptionKeys = new HashMap<String, PrivateKey>();
    private String defaultDecryptionKeyId = null;
    private PKCS11ProviderManager providerManager = null;
    protected TruststoreHelper truststoreHelper;

    public PKCS11MessageSecurityProvider(Properties config) throws MessageProcessingException {
        this(config, new DefaultPKCS11ProviderManager());
    }

    public PKCS11MessageSecurityProvider(Properties config, PKCS11ProviderManager providerManager) throws MessageProcessingException {
        String alias;
        Enumeration<String> aliases;
        String pkcs11Library = SettingsUtils.getRequiredProperty(config, SETTING_PKCS11_LIBRARY);
        int pkcs11Slot = Integer.parseInt(SettingsUtils.getRequiredProperty(config, SETTING_PKCS11_SLOT));
        this.pkcs11Password = SettingsUtils.getRequiredProperty(config, SETTING_PKCS11_SLOT_PASSWORD);
        String signingKeyAlias = config.getProperty(SETTING_SIGNINGKEY_ALIAS);
        String decryptKeyDefaultAlias = config.getProperty(SETTING_DECRYPTKEY_DEFAULT_ALIAS);
        String trustStorePath = config.getProperty(SETTING_TRUSTSTORE_PATH);
        String trustStorePassword = config.getProperty(SETTING_TRUSTSTORE_PASSWORD);
        try {
            this.providerManager = providerManager;
            this.pkcs11Keystore = this.getPKCS11Keystore(pkcs11Library, pkcs11Slot, this.pkcs11Password);
            if (signingKeyAlias == null) {
                this.log.fine("Signing key alias not specified. Trying to find available key.");
                aliases = this.pkcs11Keystore.aliases();
                while (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                    if (!this.pkcs11Keystore.isKeyEntry(alias) || signingKeyAlias != null) continue;
                    this.log.fine("Using signing key alias: " + alias);
                    signingKeyAlias = alias;
                }
            }
            this.signingCertificate = (X509Certificate)this.pkcs11Keystore.getCertificate(signingKeyAlias);
            this.signingKey = (PrivateKey)this.pkcs11Keystore.getKey(signingKeyAlias, this.pkcs11Password.toCharArray());
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error loading signing keystore: " + e.getMessage(), e);
        }
        if (this.signingCertificate == null || this.signingKey == null) {
            throw new MessageProcessingException("Error finding signing certificate and key for alias: " + signingKeyAlias + ", in PKCS#11 slot: " + pkcs11Slot);
        }
        if (decryptKeyDefaultAlias == null) {
            this.log.fine("Default decryption key alias not specified, using signing key alias: " + signingKeyAlias);
            decryptKeyDefaultAlias = signingKeyAlias;
        }
        try {
            aliases = this.pkcs11Keystore.aliases();
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                Key key = this.pkcs11Keystore.getKey(alias, this.pkcs11Password.toCharArray());
                Certificate[] certChain = this.pkcs11Keystore.getCertificateChain(alias);
                if (key == null || !(key instanceof PrivateKey) || certChain == null || certChain.length <= 0) continue;
                X509Certificate[] x509CertChain = (X509Certificate[])Arrays.copyOf(certChain, certChain.length, X509Certificate[].class);
                String keyId = XMLEncrypter.generateKeyId(x509CertChain[0].getPublicKey());
                this.decryptionKeys.put(keyId, (PrivateKey)key);
                this.decryptionCertificates.put(keyId, x509CertChain);
            }
            Certificate defaultDecryptCert = this.pkcs11Keystore.getCertificate(decryptKeyDefaultAlias);
            if (defaultDecryptCert != null) {
                this.defaultDecryptionKeyId = XMLEncrypter.generateKeyId(defaultDecryptCert.getPublicKey());
            }
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Unable to read decryption keys and certificates from token: " + e.getMessage(), e);
        }
        if (this.decryptionKeys.size() == 0) {
            throw new MessageProcessingException("No decryption keys found in token");
        }
        if (this.decryptionKeys.get(this.defaultDecryptionKeyId) == null) {
            throw new MessageProcessingException("Error no default decryption key with alias:" + decryptKeyDefaultAlias + " found in token");
        }
        this.signingAlgorithmScheme = SigningAlgorithmScheme.getByName(config.getProperty(SETTING_SIGNATURE_ALGORITHM_SCHEME));
        if (this.signingAlgorithmScheme == null) {
            this.signingAlgorithmScheme = DEFAULT_SIGNATURE_ALGORITHM_SCHEME;
        }
        this.encryptionAlgorithmScheme = EncryptionAlgorithmScheme.getByName(config.getProperty(SETTING_ENCRYPTION_ALGORITHM_SCHEME));
        if (this.encryptionAlgorithmScheme == null) {
            this.encryptionAlgorithmScheme = DEFAULT_ENCRYPTION_ALGORITHM_SCHEME;
        }
        if (trustStorePath != null) {
            try {
                this.log.fine("Using truststore: " + trustStorePath);
                this.trustStore = KeyStore.getInstance("JKS");
                this.trustStore.load(new FileInputStream(trustStorePath), trustStorePassword.toCharArray());
            }
            catch (Exception e) {
                this.log.log(Level.FINE, "Failed to load truststore: " + trustStorePath, e);
            }
        }
        this.truststoreHelper = new TruststoreHelper(config, this.trustStore != null ? this.trustStore : this.pkcs11Keystore, SETTING_PREFIX);
    }

    @Override
    public PrivateKey getSigningKey() throws MessageProcessingException {
        return this.getSigningKey(DEFAULT_CONTEXT);
    }

    @Override
    public PrivateKey getSigningKey(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.signingKey;
    }

    @Override
    public X509Certificate getSigningCertificate() throws MessageProcessingException {
        return this.getSigningCertificate(DEFAULT_CONTEXT);
    }

    @Override
    public X509Certificate getSigningCertificate(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.signingCertificate;
    }

    @Override
    public PrivateKey getDecryptionKey(String keyId) throws MessageProcessingException {
        return this.getDecryptionKey(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public PrivateKey getDecryptionKey(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        return this.decryptionKeys.get(keyId == null ? this.defaultDecryptionKeyId : keyId);
    }

    @Override
    public X509Certificate getDecryptionCertificate(String keyId) throws MessageProcessingException {
        return this.getDecryptionCertificate(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public X509Certificate getDecryptionCertificate(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        return this.decryptionCertificates.get(keyId == null ? this.defaultDecryptionKeyId : keyId)[0];
    }

    @Override
    public X509Certificate[] getDecryptionCertificateChain(String keyId) throws MessageProcessingException {
        return this.getDecryptionCertificateChain(DEFAULT_CONTEXT, keyId);
    }

    @Override
    public X509Certificate[] getDecryptionCertificateChain(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        return this.decryptionCertificates.get(keyId == null ? this.defaultDecryptionKeyId : keyId);
    }

    @Override
    public Set<String> getDecryptionKeyIds() throws MessageProcessingException {
        return this.getDecryptionKeyIds(DEFAULT_CONTEXT);
    }

    @Override
    public Set<String> getDecryptionKeyIds(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.decryptionKeys.keySet();
    }

    @Override
    public boolean isValidAndAuthorized(X509Certificate signCertificate, String organisation) throws IllegalArgumentException, MessageProcessingException {
        return this.isValidAndAuthorized(DEFAULT_CONTEXT, signCertificate, organisation);
    }

    @Override
    public boolean isValidAndAuthorized(ContextMessageSecurityProvider.Context context, X509Certificate signCertificate, String organisation) throws IllegalArgumentException, MessageProcessingException {
        this.log.fine("Checking if valid and authorized: " + signCertificate.getSubjectDN().getName());
        if (!XMLSigner.checkBasicCertificateValidation(signCertificate)) {
            return false;
        }
        return this.truststoreHelper.isTrusted(context, signCertificate);
    }

    @Override
    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme() throws MessageProcessingException {
        return this.getEncryptionAlgorithmScheme(DEFAULT_CONTEXT);
    }

    @Override
    public EncryptionAlgorithmScheme getEncryptionAlgorithmScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.encryptionAlgorithmScheme;
    }

    @Override
    public SigningAlgorithmScheme getSigningAlgorithmScheme() throws MessageProcessingException {
        return this.getSigningAlgorithmScheme(DEFAULT_CONTEXT);
    }

    @Override
    public String getProvider() {
        return this.pkcs11Provider;
    }

    @Override
    public SigningAlgorithmScheme getSigningAlgorithmScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        return this.signingAlgorithmScheme;
    }

    @Override
    public String getProvider(ContextMessageSecurityProvider.Context context) {
        return this.getProvider();
    }

    static boolean isEqual(X509Certificate certificate, X509Certificate anotherCertificate) throws CertificateEncodingException {
        return certificate != null && anotherCertificate != null && Arrays.equals(certificate.getEncoded(), anotherCertificate.getEncoded());
    }

    protected KeyStore getPKCS11Keystore(String pkcs11Library, int slot, String slotPassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!new File(pkcs11Library).exists()) {
            throw new IOException("PKCS#11 library does not exist: " + pkcs11Library);
        }
        StringBuffer pkcs11Config = new StringBuffer();
        pkcs11Config.append("name = CSMsgSecProv\n");
        pkcs11Config.append("library = " + pkcs11Library + "\n");
        pkcs11Config.append("slot = " + slot + "\n");
        this.log.fine("Using PKCS#11 configuration: " + pkcs11Config.toString());
        ByteArrayInputStream configStream = new ByteArrayInputStream(pkcs11Config.toString().getBytes("UTF-8"));
        this.pkcs11Provider = this.providerManager.addPKCS11Provider(configStream);
        KeyStore keyStore = this.providerManager.loadPKCS11Keystore(slotPassword == null ? null : slotPassword.toCharArray());
        this.log.fine("PKCS#11 Keystore successfully loaded");
        if (this.log.isLoggable(Level.FINE)) {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.log.fine("Found keystore alias: " + alias);
            }
        }
        return keyStore;
    }

    @Deprecated
    public String getPKCS11Provider() {
        return this.getProvider();
    }
}

