/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;

public class CSMessageResponseData {
    protected String messageId;
    protected String messageName;
    protected String relatedEndEntity;
    protected String destination;
    protected byte[] responseData;
    protected boolean isForwardableResponse = false;
    protected CSMessage responseMessage;
    protected Map<String, String> messageProperties = new HashMap<String, String>();

    public CSMessageResponseData() {
    }

    public CSMessageResponseData(CSMessage responseMessage, String relatedEndEntity, byte[] responseData, boolean isForwardableResponse) {
        this.responseMessage = responseMessage;
        this.messageId = responseMessage.getID();
        this.setMessageName(responseMessage.getName());
        this.setRelatedEndEntity(relatedEndEntity);
        this.destination = responseMessage.getDestinationId();
        this.responseData = responseData;
        this.isForwardableResponse = isForwardableResponse;
    }

    public CSMessageResponseData(String messageId, String messageName, String relatedEndEntity, String destination, byte[] responseData) {
        this.messageId = messageId;
        this.setMessageName(messageName);
        this.setRelatedEndEntity(relatedEndEntity);
        this.destination = destination;
        this.responseData = responseData;
    }

    public CSMessageResponseData(String messageId, String messageName, String relatedEndEntity, String destination, byte[] responseData, boolean isForwardableResponse) {
        this.messageId = messageId;
        this.setMessageName(messageName);
        this.setRelatedEndEntity(relatedEndEntity);
        this.destination = destination;
        this.responseData = responseData;
        this.isForwardableResponse = isForwardableResponse;
    }

    public boolean isForwardable(Set<String> excludedDestinations) {
        boolean excluded = excludedDestinations.contains(this.destination.toUpperCase().trim());
        return this.isForwardableResponse && !excluded;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public void setResponseData(byte[] responseData) {
        this.responseData = responseData;
    }

    public boolean getIsForwardableResponse() {
        return this.isForwardableResponse;
    }

    public void setIsForwardableResponse(boolean isForwardableResponse) {
        this.isForwardableResponse = isForwardableResponse;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getRelatedEndEntity() {
        return this.relatedEndEntity != null ? this.relatedEndEntity : "UNKNOWN";
    }

    public void setRelatedEndEntity(String relatedEndEntity) {
        this.relatedEndEntity = relatedEndEntity;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public CSMessage getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(CSMessage responseMessage) {
        this.responseMessage = responseMessage;
    }

    public Map<String, String> getMessageProperties() {
        return this.messageProperties;
    }

    public String toString() {
        return "CSMessageProcessResult [messageId=" + this.messageId + ", destination=" + this.destination + ", responseData=" + Arrays.toString(this.responseData) + ", isForwardableResponse=" + this.isForwardableResponse + "]";
    }
}

