/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages.manager;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.credmanagement.CredManagementPayloadParser;
import org.certificateservices.messages.credmanagement.jaxb.IssueTokenCredentialsResponse;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;
import org.certificateservices.messages.csmessages.manager.DefaultReqRespManager;
import org.certificateservices.messages.csmessages.manager.MessageHandler;
import org.certificateservices.messages.utils.MessageGenerateUtils;

public class AutoRevokeReqRespManager
extends DefaultReqRespManager {
    private static Logger log = Logger.getLogger(AutoRevokeReqRespManager.class.getName());
    protected CSMessageParser csMessageParser;
    protected CredManagementPayloadParser credManagementPayloadParser;
    protected static String REVOKE_REASON_REASONINFORMATION_CESSATIONOFOPERATION = "5";

    public AutoRevokeReqRespManager(CSMessageParser csMessageParser, CredManagementPayloadParser credManagementPayloadParser, long timeOut, MessageHandler messageHandler, String messageSenderName, String messageListenerName) throws MessageProcessingException {
        super(timeOut, messageHandler, messageSenderName, messageListenerName);
        this.csMessageParser = csMessageParser;
        this.credManagementPayloadParser = credManagementPayloadParser;
    }

    @Override
    public void responseReceived(byte[] requestData, CSMessage responseMessage, Map<String, String> messageAttributes) {
        IssueTokenCredentialsResponse itcr;
        boolean stillWaiting;
        String requestId = this.findRequestId(responseMessage);
        if (requestId != null && !(stillWaiting = this.populateResponseMapIfStillExist(requestId, responseMessage)) && responseMessage.getPayload().getAny() instanceof IssueTokenCredentialsResponse && (itcr = (IssueTokenCredentialsResponse)responseMessage.getPayload().getAny()).getStatus() == RequestStatus.SUCCESS && itcr.getCredentials() != null && itcr.getCredentials().getCredential() != null) {
            for (Credential c : itcr.getCredentials().getCredential()) {
                try {
                    String messageId = MessageGenerateUtils.generateRandomUUID();
                    byte[] revokeMessage = this.credManagementPayloadParser.genChangeCredentialStatusRequest(messageId, responseMessage.getSourceId(), responseMessage.getOrganisation(), c.getIssuerId(), c.getSerialNumber(), 160, REVOKE_REASON_REASONINFORMATION_CESSATIONOFOPERATION, this.csMessageParser.getOriginatorFromRequest(responseMessage), null);
                    this.messageHandler.sendMessage(this.messageSenderName, messageId, revokeMessage, messageAttributes);
                }
                catch (IOException e) {
                    log.severe("Error revoking timed-out certificate, io exception: " + e.getMessage());
                }
                catch (MessageProcessingException e) {
                    log.severe("Error revoking timed-out certificate, internal error: " + e.getMessage());
                }
                catch (MessageContentException e) {
                    log.severe("Error revoking timed-out certificate, illegal message: " + e.getMessage());
                }
            }
        }
    }
}

