/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages.manager;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.CSResponse;
import org.certificateservices.messages.csmessages.manager.MessageHandler;
import org.certificateservices.messages.csmessages.manager.MessageResponseCallback;
import org.certificateservices.messages.csmessages.manager.ReqRespManager;

public class DefaultReqRespManager
implements ReqRespManager,
MessageResponseCallback {
    private static Logger log = Logger.getLogger(DefaultReqRespManager.class.getName());
    protected Map<String, RequestEntry> responseMap = new HashMap<String, RequestEntry>();
    protected long timeOut;
    protected MessageHandler messageHandler;
    protected String messageListenerName;
    protected String messageSenderName;
    protected static long SLEEP_INTERVAL_MILLIS = 100L;
    public static final String CALLBACK_ALIAS = "DefaultReqRespManager";

    public DefaultReqRespManager(long timeOut, MessageHandler messageHandler, String messageSenderName, String messageListenerName) throws MessageProcessingException {
        this.timeOut = timeOut;
        this.messageHandler = messageHandler;
        this.messageSenderName = messageSenderName;
        this.messageListenerName = messageListenerName;
        this.messageHandler.getMessageListener(messageListenerName).registerCallback(CALLBACK_ALIAS, this);
    }

    @Override
    public CSMessage sendRequest(String requestId, byte[] request) throws IllegalArgumentException, IOException, MessageProcessingException {
        return this.sendRequest(requestId, request, null);
    }

    @Override
    public CSMessage sendRequest(String requestId, byte[] request, Map<String, String> requestAttributes) throws IllegalArgumentException, IOException, MessageProcessingException {
        CSMessage retval = null;
        this.registerWaitForRequestId(requestId);
        this.messageHandler.sendMessage(this.messageSenderName, requestId, request, requestAttributes);
        for (long waitTime = 0L; waitTime < this.timeOut && (retval = this.checkIfResponseIsReady(requestId)) == null; waitTime += SLEEP_INTERVAL_MILLIS) {
            try {
                Thread.sleep(SLEEP_INTERVAL_MILLIS);
                continue;
            }
            catch (InterruptedException e) {
                log.severe("waiting process interupted while waiting for MQ response: " + e.getMessage());
            }
        }
        if (retval == null) {
            this.cancelWaitForResponse(requestId);
            throw new IOException("Error: Timeout exception after waiting for message with request id: " + requestId);
        }
        return retval;
    }

    @Override
    public void responseReceived(byte[] requestData, CSMessage responseMessage, Map<String, String> messageAttributes) {
        String requestId = this.findRequestId(responseMessage);
        if (requestId != null) {
            this.populateResponseMapIfStillExist(requestId, responseMessage);
        }
    }

    protected synchronized void registerWaitForRequestId(String requestId) {
        this.responseMap.put(requestId, new RequestEntry());
    }

    protected synchronized CSMessage checkIfResponseIsReady(String requestId) {
        CSMessage retval = null;
        RequestEntry entry = this.responseMap.get(requestId);
        if (entry != null && entry.getResponse() != null) {
            retval = entry.getResponse();
            this.responseMap.remove(requestId);
        }
        return retval;
    }

    protected synchronized void cancelWaitForResponse(String requestId) {
        this.responseMap.remove(requestId);
    }

    protected synchronized boolean populateResponseMapIfStillExist(String requestId, CSMessage responseMessage) {
        boolean retval = false;
        RequestEntry entry = this.responseMap.get(requestId);
        if (entry != null) {
            entry.setResponse(responseMessage);
            retval = true;
        }
        return retval;
    }

    protected String findRequestId(CSMessage responseMessage) {
        String retval = null;
        CSResponse response = this.findResponsePayload(responseMessage);
        if (response != null) {
            retval = response.getInResponseTo();
        }
        if (retval != null) {
            retval = retval.trim();
        }
        return retval;
    }

    protected CSResponse findResponsePayload(CSMessage responseMessage) {
        Object innerPayload;
        Object payload = responseMessage.getPayload().getAny();
        if (payload instanceof CSResponse) {
            return (CSResponse)payload;
        }
        if (payload instanceof JAXBElement && (innerPayload = ((JAXBElement)payload).getValue()) instanceof CSResponse) {
            return (CSResponse)innerPayload;
        }
        return null;
    }

    protected class RequestEntry {
        private CSMessage response;

        protected RequestEntry() {
        }

        public CSMessage getResponse() {
            return this.response;
        }

        public void setResponse(CSMessage response) {
            this.response = response;
        }
    }
}

