/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.credmanagement.CredManagementPayloadParser;
import org.certificateservices.messages.credmanagement.jaxb.ChangeCredentialStatusRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialRequest;
import org.certificateservices.messages.credmanagement.jaxb.IssueTokenCredentialsRequest;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.PayloadParserRegistry;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.CredentialRequest;
import org.certificateservices.messages.csmessages.jaxb.ObjectFactory;
import org.certificateservices.messages.csmessages.manager.MessageComponent;
import org.certificateservices.messages.csmessages.manager.MessageHandler;
import org.certificateservices.messages.csmessages.manager.MessageListener;
import org.certificateservices.messages.csmessages.manager.MessageSender;
import org.certificateservices.messages.utils.MessageGenerateUtils;

public class DummyMessageHandler
implements MessageHandler {
    private CSMessageParser parser;
    private CredManagementPayloadParser credManagementPayloadParser;
    private ObjectFactory of = new ObjectFactory();
    private long waitTime;
    private HashMap<String, MessageComponent> components = new HashMap();
    public boolean revokeMessageRecieved = false;
    public static final String SETTING_WAITTIME = "dummy.waittime";
    public static byte[] base64Cert = "MIIDLTCCAhWgAwIBAgIIYmVP6xQ/t3QwDQYJKoZIhvcNAQEFBQAwJDETMBEGA1UEAwwKVGVzdCBlSURDQTENMAsGA1UECgwEVGVzdDAeFw0xMTEwMjExNDM2MzlaFw0zMTEwMjExNDM2MzlaMCQxEzARBgNVBAMMClRlc3QgZUlEQ0ExDTALBgNVBAoMBFRlc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDecUf5if2UdWbV/HIjh6U3XIymmh28wo8VVxPIbV1A8Yxz7QaMkP8vqaDwHnB1B6mHEjn4VyVogxWxI70IwPudUL+Oxkc9ZL7H7zkbi6l2d/n85PjyZvdarCwcBzpEqIRsc+Wa3bGFKBpdZjwLXjuuI4YWx+uUrQ96X+WusvFcb8C4Ru3w/K8Saf7yLJNvqmTJrgAOeKY49Jnp9V5x9dGe+xpHR3t2xhJ5HXhm+SeUsrH5fHXky7/OVKvLPOXSve+1KHpyp+eOxxgYozTh5k+viL0pP9G3AbEPp1mXtxCNzRjUgNlG0BDSIbowD5JciLkz8uYbamLzoUiz1KzZuCfXAgMBAAGjYzBhMB0GA1UdDgQWBBT6HyWgz7ykq9BxTCaULtOIjen3bDAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFPofJaDPvKSr0HFMJpQu04iN6fdsMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAbG7Y+rm82Gz1yIWVFKBfXxDee7UwX2pyKdDfvRf9lFLxXv4LKBnuM5Zlb2RPdAAe7tTMtnYDwOWs4Uniy57hYrCKU3v80u4uZoH8FNCG22APWQ+xa5UQtuq0yRf2xp2e4wjGZLQZlYUbePAZEjle0E2YIa/kOrlvy5Z62sj24yczBL9uHfWpQUefA1+R9JpbOj0WEk+rAV0xJ2knmC/RNzHWz92kL6UKUFzyBXBiBbY7TSVjO+bV/uPaTEVP7QhJk4Cahg1a7h8iMdF78ths+xMeZX1KyiL4Dpo2rocZAvdL/C8qkt/uEgOjwOTdmoRVxkFWcm+DRNa26cclBQ4tVw==".getBytes();

    @Override
    public void init(Properties config) throws MessageProcessingException {
        this.waitTime = Long.parseLong(config.getProperty(SETTING_WAITTIME));
        this.credManagementPayloadParser = (CredManagementPayloadParser)PayloadParserRegistry.getParser(CredManagementPayloadParser.NAMESPACE);
    }

    @Override
    public void connect() throws MessageProcessingException, IOException {
    }

    @Override
    public void sendMessage(String componentName, String messageId, byte[] messageData, Map<String, String> messageAttributes) throws MessageProcessingException, IOException {
        try {
            byte[] response = null;
            CSMessage request = this.parser.parseMessage(messageData);
            if (request.getPayload().getAny() instanceof GetCredentialRequest) {
                GetCredentialRequest gcr = (GetCredentialRequest)request.getPayload().getAny();
                Credential c = this.of.createCredential();
                c.setCredentialData(this.base64Decode(base64Cert));
                c.setCredentialSubType(gcr.getCredentialSubType());
                c.setCredentialType("x509certificate");
                c.setDisplayName("SomeDisplayName");
                c.setExpireDate(MessageGenerateUtils.dateToXMLGregorianCalendar(new Date(1L)));
                c.setIssueDate(MessageGenerateUtils.dateToXMLGregorianCalendar(new Date(2L)));
                c.setIssuerId("CN=SomeIssuerId");
                c.setSerialNumber("abc123");
                c.setStatus(100);
                c.setUniqueId("SomeUniqueId");
                c.setValidFromDate(MessageGenerateUtils.dateToXMLGregorianCalendar(new Date(3L)));
                response = this.credManagementPayloadParser.genGetCredentialResponse("UNKNOWN", request, c, null).getResponseData();
            }
            if (request.getPayload().getAny() instanceof IssueTokenCredentialsRequest) {
                IssueTokenCredentialsRequest itr = (IssueTokenCredentialsRequest)request.getPayload().getAny();
                CredentialRequest cr = itr.getTokenRequest().getCredentialRequests().getCredentialRequest().get(0);
                Credential c = this.of.createCredential();
                c.setCredentialData(this.base64Decode(base64Cert));
                c.setCredentialSubType(cr.getCredentialSubType());
                c.setCredentialType("x509certificate");
                c.setDisplayName("SomeDisplayName");
                c.setExpireDate(MessageGenerateUtils.dateToXMLGregorianCalendar(new Date(1L)));
                c.setIssueDate(MessageGenerateUtils.dateToXMLGregorianCalendar(new Date(2L)));
                c.setIssuerId("CN=SomeIssuerId");
                c.setSerialNumber("abc123");
                c.setStatus(100);
                c.setUniqueId("SomeUniqueId");
                c.setValidFromDate(MessageGenerateUtils.dateToXMLGregorianCalendar(new Date(3L)));
                ArrayList<Credential> credentials = new ArrayList<Credential>();
                credentials.add(c);
                response = this.credManagementPayloadParser.genIssueTokenCredentialsResponse("UNKNOWN", request, credentials, null, null).getResponseData();
            }
            if (request.getPayload().getAny() instanceof ChangeCredentialStatusRequest) {
                ChangeCredentialStatusRequest r = (ChangeCredentialStatusRequest)request.getPayload().getAny();
                if (r.getNewCredentialStatus() != 160) {
                    throw new IllegalArgumentException("Bad revoke status");
                }
                if (!r.getIssuerId().equals("CN=SomeIssuerId")) {
                    throw new IllegalArgumentException("Bad issuer id");
                }
                if (!r.getReasonInformation().equals("5")) {
                    throw new IllegalArgumentException("Bad reason information");
                }
                if (!r.getSerialNumber().equals("abc123")) {
                    throw new IllegalArgumentException("Bad serial number");
                }
                this.revokeMessageRecieved = true;
            }
            if (response != null) {
                Thread t = new Thread(new WaitAndSend(response));
                t.start();
            }
        }
        catch (MessageContentException e) {
            throw new MessageProcessingException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Object getConnectionFactory() throws MessageProcessingException, IOException {
        throw new MessageProcessingException("Not implemented");
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    private byte[] base64Decode(byte[] data) throws MessageProcessingException {
        try {
            return Base64.decode((byte[])base64Cert);
        }
        catch (Base64DecodingException e) {
            throw new MessageProcessingException("Base64 Decoding Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public void addSender(MessageSender sender) {
        this.components.put(sender.getName(), sender);
    }

    @Override
    public void addListener(MessageListener listener) {
        this.components.put(listener.getName(), listener);
    }

    @Override
    public MessageSender getMessageSender(String name) throws MessageProcessingException {
        MessageComponent retval = this.components.get(name);
        if (retval == null || !(retval instanceof MessageSender)) {
            throw new MessageProcessingException("");
        }
        return (MessageSender)retval;
    }

    @Override
    public MessageListener getMessageListener(String name) throws MessageProcessingException {
        MessageComponent retval = this.components.get(name);
        if (retval == null || !(retval instanceof MessageListener)) {
            throw new MessageProcessingException("");
        }
        return (MessageListener)retval;
    }

    private class WaitAndSend
    implements Runnable {
        private byte[] responseMessage;

        public WaitAndSend(byte[] responseMessage) {
            this.responseMessage = responseMessage;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(DummyMessageHandler.this.waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (MessageComponent mc : DummyMessageHandler.this.components.values()) {
                if (!(mc instanceof MessageListener)) continue;
                try {
                    ((MessageListener)mc).responseReceived(this.responseMessage, null);
                }
                catch (Exception e) {
                    assert (false);
                }
            }
        }
    }
}

