/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.heartbeat;

import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.heartbeat.HealthStatus;
import org.certificateservices.messages.heartbeat.MonitoringPoint;

public class HeartBeatMessage {
    private String systemId;
    private List<MonitoringPoint> monitoringPoints;
    private HealthStatus overallStatus;

    public HeartBeatMessage(String systemId, List<MonitoringPoint> monitoringPoints, HealthStatus overallStatus) throws MessageContentException {
        if (systemId == null || systemId.equals("")) {
            throw new MessageContentException("Error creating heart beat message, the system id cannot be null or empty");
        }
        if (monitoringPoints == null || monitoringPoints.size() < 1) {
            throw new MessageContentException("Error creating heart beat message, at least one monitoring point must exist in the message.");
        }
        if (overallStatus == null) {
            throw new MessageContentException("Error creating heart beat message, overall status cannot be null.");
        }
        this.systemId = systemId;
        this.monitoringPoints = monitoringPoints;
        this.overallStatus = overallStatus;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public List<MonitoringPoint> getMonitoringPoints() {
        return this.monitoringPoints;
    }

    public HealthStatus getOverallStatus() {
        return this.overallStatus;
    }
}

