/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.pkimessages;

import java.util.Properties;
import org.certificateservices.messages.MessageException;
import org.certificateservices.messages.pkimessages.MessageNameCatalogue;

public class DefaultMessageNameCatalogue
implements MessageNameCatalogue {
    private Properties properties;
    public static final String SETTING_MESSAGE_NAME_PREFIX = "pkimessage.name.";

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String lookupName(String requestName, Object payLoadObject) throws MessageException, IllegalArgumentException {
        String setting;
        if (payLoadObject == null) {
            throw new MessageException("Payload element cannot be null.");
        }
        String retval = payLoadObject.getClass().getSimpleName();
        if (retval.equals("PKIResponse")) {
            retval = "FailureResponse";
        }
        if (this.properties.getProperty(setting = SETTING_MESSAGE_NAME_PREFIX + payLoadObject.getClass().getSimpleName().toLowerCase()) != null) {
            retval = this.properties.getProperty(setting);
        }
        return retval;
    }
}

