/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.pkimessages;

import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.certificateservices.messages.MessageException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.pkimessages.PKIMessageResponseData;
import org.certificateservices.messages.pkimessages.jaxb.Credential;
import org.certificateservices.messages.pkimessages.jaxb.CredentialStatusList;
import org.certificateservices.messages.pkimessages.jaxb.PKIMessage;
import org.certificateservices.messages.pkimessages.jaxb.RequestStatus;
import org.certificateservices.messages.pkimessages.jaxb.TokenRequest;

public interface PKIMessageParser {
    public void init(MessageSecurityProvider var1, Properties var2) throws MessageException;

    public PKIMessage parseMessage(byte[] var1) throws IllegalArgumentException, MessageException;

    public byte[] genIssueTokenCredentialsRequest(String var1, String var2, String var3, TokenRequest var4, Credential var5) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genIssueTokenCredentialsResponse(String var1, PKIMessage var2, List<Credential> var3, List<Credential> var4) throws IllegalArgumentException, MessageException;

    public byte[] genChangeCredentialStatusRequest(String var1, String var2, String var3, String var4, String var5, int var6, String var7, Credential var8) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genChangeCredentialStatusResponse(String var1, PKIMessage var2, String var3, String var4, int var5, String var6, Date var7) throws IllegalArgumentException, MessageException;

    public byte[] genGetCredentialRequest(String var1, String var2, String var3, String var4, String var5, String var6, Credential var7) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genGetCredentialResponse(String var1, PKIMessage var2, Credential var3) throws IllegalArgumentException, MessageException;

    public byte[] genGetCredentialStatusListRequest(String var1, String var2, String var3, String var4, Long var5, String var6, Credential var7) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genGetCredentialStatusListResponse(String var1, PKIMessage var2, CredentialStatusList var3) throws IllegalArgumentException, MessageException;

    public byte[] genGetIssuerCredentialsRequest(String var1, String var2, String var3, String var4, Credential var5) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genGetIssuerCredentialsResponse(String var1, PKIMessage var2, Credential var3) throws IllegalArgumentException, MessageException;

    public byte[] genIsIssuerRequest(String var1, String var2, String var3, String var4, Credential var5) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genIsIssuerResponse(String var1, PKIMessage var2, boolean var3) throws IllegalArgumentException, MessageException;

    public byte[] genIssueCredentialStatusListRequest(String var1, String var2, String var3, String var4, String var5, Boolean var6, Date var7, Date var8, Credential var9) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genIssueCredentialStatusListResponse(String var1, PKIMessage var2, CredentialStatusList var3) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genIssueCredentialStatusListResponseWithoutRequest(String var1, String var2, String var3, String var4, CredentialStatusList var5, Credential var6) throws IllegalArgumentException, MessageException;

    public byte[] genRemoveCredentialRequest(String var1, String var2, String var3, String var4, String var5, Credential var6) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genRemoveCredentialResponse(String var1, PKIMessage var2) throws IllegalArgumentException, MessageException;

    public byte[] genFetchHardTokenDataRequest(String var1, String var2, String var3, String var4, String var5, String var6, Credential var7, Credential var8) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genFetchHardTokenDataResponse(String var1, PKIMessage var2, String var3, byte[] var4) throws IllegalArgumentException, MessageException;

    public byte[] genStoreHardTokenDataRequest(String var1, String var2, String var3, String var4, String var5, String var6, byte[] var7, Credential var8) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genStoreHardTokenDataResponse(String var1, PKIMessage var2) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genPKIResponse(String var1, byte[] var2, RequestStatus var3, String var4, Credential var5) throws IllegalArgumentException, MessageException;

    public PKIMessageResponseData genPKIResponse(String var1, byte[] var2, RequestStatus var3, String var4, String var5, Credential var6) throws IllegalArgumentException, MessageException;

    public X509Certificate getSigningCertificate(byte[] var1) throws IllegalArgumentException, MessageException;

    public byte[] marshallAndSignPKIMessage(PKIMessage var1) throws MessageException;
}

