/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.pkimessages.manager;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.certificateservices.messages.MessageException;
import org.certificateservices.messages.pkimessages.DefaultPKIMessageParser;
import org.certificateservices.messages.pkimessages.PKIMessageParser;
import org.certificateservices.messages.pkimessages.jaxb.Credential;
import org.certificateservices.messages.pkimessages.jaxb.IssueTokenCredentialsResponse;
import org.certificateservices.messages.pkimessages.jaxb.PKIMessage;
import org.certificateservices.messages.pkimessages.jaxb.PKIResponse;
import org.certificateservices.messages.pkimessages.jaxb.RequestStatus;
import org.certificateservices.messages.pkimessages.manager.MessageHandler;
import org.certificateservices.messages.pkimessages.manager.MessageManager;
import org.certificateservices.messages.pkimessages.manager.MessageResponseCallback;
import org.certificateservices.messages.utils.MessageGenerateUtils;

public class DefaultMessageManager
implements MessageManager,
MessageResponseCallback {
    private static Logger log = Logger.getLogger(DefaultMessageManager.class.getName());
    private Map<String, RequestEntry> responseMap = new HashMap<String, RequestEntry>();
    public static final String SETTING_MESSAGE_TIMEOUT_MILLIS = "mq.message.timeout";
    public static final String DEFAULT_MESSAGE_TIMEOUT_MILLIS = "60000";
    public static final String SETTING_MESSAGEHANDLER_CLASSPATH = "mq.messagehandler.impl";
    protected static String REVOKE_REASON_REASONINFORMATION_CESSATIONOFOPERATION = "5";
    protected static long SLEEP_INTERVAL_MILLIS = 100L;
    protected PKIMessageParser parser;
    protected String destination;
    protected MessageHandler messageHandler;
    protected long timeout;

    @Override
    public void init(Properties config, PKIMessageParser parser, String destination) throws IllegalArgumentException, IOException, MessageException {
        this.destination = destination;
        this.parser = parser;
        this.timeout = DefaultMessageManager.getTimeOutInMillis(config);
        this.messageHandler = this.getMessageHandler(config, parser);
    }

    @Override
    public PKIMessage sendMessage(String requestId, byte[] request) throws IllegalArgumentException, IOException, MessageException {
        PKIMessage retval = null;
        this.registerWaitForRequestId(requestId);
        this.messageHandler.sendMessage(requestId, request);
        for (long waitTime = 0L; waitTime < this.timeout && (retval = this.checkIfResponseIsReady(requestId)) == null; waitTime += SLEEP_INTERVAL_MILLIS) {
            try {
                Thread.sleep(SLEEP_INTERVAL_MILLIS);
                continue;
            }
            catch (InterruptedException e) {
                log.severe("waiting process interupted while waiting for MQ response: " + e.getMessage());
            }
        }
        if (retval == null) {
            this.cancelWaitForResponse(requestId);
            throw new IOException("Error: Timeout exception after waiting for message with request id: " + requestId);
        }
        return retval;
    }

    @Override
    public void responseReceived(PKIMessage responseMessage) {
        IssueTokenCredentialsResponse itcr;
        boolean stillWaiting;
        String requestId = this.findRequestId(responseMessage);
        if (requestId != null && !(stillWaiting = this.populateResponseMapIfStillExist(requestId, responseMessage)) && (itcr = responseMessage.getPayload().getIssueTokenCredentialsResponse()) != null && itcr.getStatus() == RequestStatus.SUCCESS && itcr.getCredentials() != null && itcr.getCredentials().getCredential() != null) {
            for (Credential c : itcr.getCredentials().getCredential()) {
                try {
                    String messageId = MessageGenerateUtils.generateRandomUUID();
                    byte[] revokeMessage = this.parser.genChangeCredentialStatusRequest(messageId, this.destination, responseMessage.getOrganisation(), c.getIssuerId(), c.getSerialNumber(), 160, REVOKE_REASON_REASONINFORMATION_CESSATIONOFOPERATION, DefaultPKIMessageParser.getOriginatorFromRequest(responseMessage));
                    this.messageHandler.sendMessage(messageId, revokeMessage);
                }
                catch (IOException e) {
                    log.severe("Error revoking timed-out certificate, io exception: " + e.getMessage());
                }
                catch (MessageException e) {
                    log.severe("Error revoking timed-out certificate, internal error: " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    log.severe("Error revoking timed-out certificate, illegal argument: " + e.getMessage());
                }
            }
        }
    }

    protected synchronized void registerWaitForRequestId(String requestId) {
        this.responseMap.put(requestId, new RequestEntry());
    }

    protected synchronized PKIMessage checkIfResponseIsReady(String requestId) {
        PKIMessage retval = null;
        RequestEntry entry = this.responseMap.get(requestId);
        if (entry != null && entry.getResponse() != null) {
            retval = entry.getResponse();
            this.responseMap.remove(requestId);
        }
        return retval;
    }

    protected synchronized void cancelWaitForResponse(String requestId) {
        this.responseMap.remove(requestId);
    }

    protected synchronized boolean populateResponseMapIfStillExist(String requestId, PKIMessage responseMessage) {
        boolean retval = false;
        RequestEntry entry = this.responseMap.get(requestId);
        if (entry != null) {
            entry.setResponse(responseMessage);
            retval = true;
        }
        return retval;
    }

    protected String findRequestId(PKIMessage responseMessage) {
        String retval = null;
        PKIResponse response = this.findResponsePayload(responseMessage);
        if (response != null) {
            retval = response.getInResponseTo();
        }
        if (retval != null) {
            retval = retval.trim();
        }
        return retval;
    }

    protected PKIResponse findResponsePayload(PKIMessage responseMessage) {
        if (responseMessage.getPayload().getGetCredentialResponse() != null) {
            return responseMessage.getPayload().getGetCredentialResponse();
        }
        if (responseMessage.getPayload().getFailureResponse() != null) {
            return responseMessage.getPayload().getFailureResponse();
        }
        if (responseMessage.getPayload().getIssueTokenCredentialsResponse() != null) {
            return responseMessage.getPayload().getIssueTokenCredentialsResponse();
        }
        if (responseMessage.getPayload().getChangeCredentialStatusResponse() != null) {
            return responseMessage.getPayload().getChangeCredentialStatusResponse();
        }
        if (responseMessage.getPayload().getFetchHardTokenDataResponse() != null) {
            return responseMessage.getPayload().getFetchHardTokenDataResponse();
        }
        if (responseMessage.getPayload().getGetCredentialStatusListResponse() != null) {
            return responseMessage.getPayload().getGetCredentialStatusListResponse();
        }
        if (responseMessage.getPayload().getGetIssuerCredentialsResponse() != null) {
            return responseMessage.getPayload().getGetIssuerCredentialsResponse();
        }
        if (responseMessage.getPayload().getIsIssuerResponse() != null) {
            return responseMessage.getPayload().getIsIssuerResponse();
        }
        if (responseMessage.getPayload().getIssueCredentialStatusListResponse() != null) {
            return responseMessage.getPayload().getIssueCredentialStatusListResponse();
        }
        if (responseMessage.getPayload().getRemoveCredentialResponse() != null) {
            return responseMessage.getPayload().getRemoveCredentialResponse();
        }
        if (responseMessage.getPayload().getStoreHardTokenDataResponse() != null) {
            return responseMessage.getPayload().getStoreHardTokenDataResponse();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.messageHandler.close();
    }

    protected MessageHandler getMessageHandler(Properties config, PKIMessageParser parser) throws MessageException, IllegalArgumentException, IOException {
        try {
            String classPath = config.getProperty(SETTING_MESSAGEHANDLER_CLASSPATH);
            if (classPath == null) {
                throw new MessageException("Error no message handler configured with setting: mq.messagehandler.impl");
            }
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(classPath);
            MessageHandler retval = (MessageHandler)c.newInstance();
            retval.init(config, parser, this);
            return retval;
        }
        catch (Exception e) {
            if (e instanceof MessageException) {
                throw (MessageException)e;
            }
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new MessageException("Error creating Message Handler: " + e.getMessage(), e);
        }
    }

    public static long getTimeOutInMillis(Properties config) throws MessageException {
        String timeout = config.getProperty(SETTING_MESSAGE_TIMEOUT_MILLIS, DEFAULT_MESSAGE_TIMEOUT_MILLIS);
        try {
            return Long.parseLong(timeout);
        }
        catch (Exception e) {
            throw new MessageException("Invalid timout value in configuration, check setting: mq.message.timeout");
        }
    }

    @Override
    public Object getConnectionFactory() throws MessageException, IOException {
        return this.messageHandler.getConnectionFactory();
    }

    @Override
    public void connect() throws MessageException, IOException {
        this.messageHandler.connect();
    }

    @Override
    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public boolean isConnected() {
        return this.messageHandler.isConnected();
    }

    protected class RequestEntry {
        private PKIMessage response;

        protected RequestEntry() {
        }

        public PKIMessage getResponse() {
            return this.response;
        }

        public void setResponse(PKIMessage response) {
            this.response = response;
        }
    }
}

