/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.signrequest;

import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.Attribute;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.signrequest.jaxb.BaseSignTask;
import org.certificateservices.messages.signrequest.jaxb.CertificateChainType;
import org.certificateservices.messages.signrequest.jaxb.GetPubKeyRequest;
import org.certificateservices.messages.signrequest.jaxb.GetPubKeyRequestTask;
import org.certificateservices.messages.signrequest.jaxb.GetPubKeyResponse;
import org.certificateservices.messages.signrequest.jaxb.GetPubKeyResponseTask;
import org.certificateservices.messages.signrequest.jaxb.ObjectFactory;
import org.certificateservices.messages.signrequest.jaxb.SignRequest;
import org.certificateservices.messages.signrequest.jaxb.SignRequestTask;
import org.certificateservices.messages.signrequest.jaxb.SignResponse;
import org.certificateservices.messages.signrequest.jaxb.SignResponseTask;

public class SignRequestPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/signrequest2_0";
    public static final String SIGNREQUEST_PROTOCOL_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/signrequest_schema2_0.xsd";
    public static final String SIGNREQUEST_PROTOCOL_XSD_SCHEMA_2_1_RESOURCE_LOCATION = "/signrequest_schema2_1.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_SIGNREQUEST_PROTOCOL_VERSIONS = new String[]{"2.0", "2.1"};
    private static final String DEFAULT_SIGNREQUEST_PROTOCOL_VERSION = "2.1";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.signrequest.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals("2.0")) {
            return this.getClass().getResourceAsStream(SIGNREQUEST_PROTOCOL_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals(DEFAULT_SIGNREQUEST_PROTOCOL_VERSION)) {
            return this.getClass().getResourceAsStream(SIGNREQUEST_PROTOCOL_XSD_SCHEMA_2_1_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported CS Sign Request Protocol Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_SIGNREQUEST_PROTOCOL_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_SIGNREQUEST_PROTOCOL_VERSION;
    }

    public byte[] genSignRequest(String requestId, String destinationId, String organisation, List<SignRequestTask> signRequestTasks, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        SignRequest payload = this.of.createSignRequest();
        SignRequest.SignRequestTasks tasksElement = this.of.createSignRequestSignRequestTasks();
        tasksElement.getSignRequestTask().addAll(signRequestTasks);
        payload.setSignRequestTasks(tasksElement);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public byte[] genGetPubKeyRequest(String requestId, String destinationId, String organisation, List<GetPubKeyRequestTask> getPukKeyRequestTasks, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetPubKeyRequest payload = this.of.createGetPubKeyRequest();
        GetPubKeyRequest.GetPubKeyRequestTasks tasksElement = this.of.createGetPubKeyRequestGetPubKeyRequestTasks();
        tasksElement.getGetPubKeyRequestTask().addAll(getPukKeyRequestTasks);
        payload.setGetPubKeyRequestTasks(tasksElement);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genSignResponse(String relatedEndEntity, CSMessage request, List<SignResponseTask> signResponseTasks) throws MessageContentException, MessageProcessingException {
        SignResponse response = this.of.createSignResponse();
        SignResponse.SignResponseTasks tasksElement = this.of.createSignResponseSignResponseTasks();
        tasksElement.getSignResponseTask().addAll(signResponseTasks);
        response.setSignResponseTasks(tasksElement);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, false);
    }

    public CSMessageResponseData genGetPubKeyResponse(String relatedEndEntity, CSMessage request, List<GetPubKeyResponseTask> getPubKeyResponseTasks) throws MessageContentException, MessageProcessingException {
        GetPubKeyResponse response = this.of.createGetPubKeyResponse();
        GetPubKeyResponse.GetPubKeyResponseTasks tasksElement = this.of.createGetPubKeyResponseGetPubKeyResponseTasks();
        tasksElement.getGetPubKeyResponseTask().addAll(getPubKeyResponseTasks);
        response.setGetPubKeyResponseTasks(tasksElement);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, false);
    }

    public SignRequestTask genSignRequestTask(String signTaskId, String signType, String keyId, List<Attribute> attributes, byte[] signRequestData) {
        SignRequestTask task = this.of.createSignRequestTask();
        this.populateBaseTask(task, signTaskId, signType, keyId, attributes);
        task.setSignRequestData(signRequestData);
        return task;
    }

    public GetPubKeyRequestTask genGetPubKeyRequestTask(String taskId, String signType, String keyId, List<Attribute> attributes) {
        GetPubKeyRequestTask task = this.of.createGetPubKeyRequestTask();
        task.setSignType(signType);
        task.setTaskId(taskId);
        task.setKeyId(keyId);
        if (attributes != null) {
            GetPubKeyRequestTask.Attributes attributesElement = this.of.createGetPubKeyRequestTaskAttributes();
            attributesElement.getAttribute().addAll(attributes);
            task.setAttributes(attributesElement);
        }
        return task;
    }

    public SignResponseTask genSignResponseTask(String signTaskId, String signType, String keyId, List<Attribute> attributes, byte[] signResponseData, List<Certificate> certificateChain, byte[] publicKey) throws MessageContentException {
        SignResponseTask task = this.of.createSignResponseTask();
        this.populateBaseTask(task, signTaskId, signType, keyId, attributes);
        task.setSignResponseData(signResponseData);
        if (certificateChain != null) {
            CertificateChainType certificateChainType = this.of.createCertificateChainType();
            for (Certificate cert : certificateChain) {
                try {
                    certificateChainType.getCertificateData().add(cert.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new MessageContentException("Error encoding certificate in given chain for sign task: " + e.getMessage(), e);
                }
            }
            task.setCertificateChain(certificateChainType);
        }
        task.setPublicKey(publicKey);
        return task;
    }

    public GetPubKeyResponseTask genGetPubKeyResponseTask(String taskId, String signType, String keyId, List<Attribute> attributes, List<Certificate> certificateChain, byte[] publicKey) throws MessageContentException {
        GetPubKeyResponseTask task = this.of.createGetPubKeyResponseTask();
        task.setSignType(signType);
        task.setTaskId(taskId);
        task.setKeyId(keyId);
        if (attributes != null) {
            GetPubKeyResponseTask.Attributes attributesElement = this.of.createGetPubKeyResponseTaskAttributes();
            attributesElement.getAttribute().addAll(attributes);
            task.setAttributes(attributesElement);
        }
        if (certificateChain != null) {
            CertificateChainType certificateChainType = this.of.createCertificateChainType();
            for (Certificate cert : certificateChain) {
                try {
                    certificateChainType.getCertificateData().add(cert.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new MessageContentException("Error encoding certificate in given chain for sign task: " + e.getMessage(), e);
                }
            }
            task.setCertificateChain(certificateChainType);
        }
        task.setPublicKey(publicKey);
        return task;
    }

    private void populateBaseTask(BaseSignTask baseSignTask, String signTaskId, String signType, String keyId, List<Attribute> attributes) {
        baseSignTask.setSignType(signType);
        baseSignTask.setSignTaskId(signTaskId);
        baseSignTask.setKeyId(keyId);
        if (attributes != null) {
            BaseSignTask.Attributes attributesElement = this.of.createBaseSignTaskAttributes();
            attributesElement.getAttribute().addAll(attributes);
            baseSignTask.setAttributes(attributesElement);
        }
    }
}

