/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.SpamProtectionException;
import org.certificateservices.messages.TimeoutException;
import org.certificateservices.messages.utils.MsgSender;

public abstract class BaseHTTPSender {
    protected URL baseURL;
    protected String requestType;
    protected String outputContentType;

    public BaseHTTPSender(String url, String requestType, String outputContentType) throws MalformedURLException {
        this.baseURL = new URL(url);
        this.requestType = requestType;
        this.outputContentType = outputContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() {
        boolean isConnected = false;
        HttpURLConnection connection = null;
        if (this.baseURL == null) {
            return isConnected;
        }
        try {
            connection = (HttpURLConnection)this.baseURL.openConnection();
            connection.connect();
            isConnected = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return isConnected;
    }

    protected byte[] sendMsg(byte[] request) throws MessageContentException, MessageProcessingException, IOException, SpamProtectionException, TimeoutException {
        SynchronousCallback callback = new SynchronousCallback();
        SendMsgRunnable sendMsgRunnable = new SendMsgRunnable(request, (MsgSender.MsgCallback)callback);
        sendMsgRunnable.run();
        if (callback.error != null) {
            if (callback.error instanceof MessageContentException) {
                throw (MessageContentException)callback.error;
            }
            if (callback.error instanceof TimeoutException) {
                throw (TimeoutException)callback.error;
            }
            if (callback.error instanceof MessageProcessingException) {
                throw (MessageProcessingException)callback.error;
            }
            if (callback.error instanceof IOException) {
                throw (IOException)callback.error;
            }
            if (callback.error instanceof SpamProtectionException) {
                throw (SpamProtectionException)callback.error;
            }
            throw new MessageProcessingException("Error sending message to " + this.baseURL + " : " + callback.error.getMessage(), callback.error);
        }
        return callback.responseData;
    }

    protected void sendMsg(byte[] request, MsgSender.MsgCallback callback) {
        Thread t = new Thread(new SendMsgRunnable(request, callback));
        t.start();
    }

    protected void sendMsg(String parameters, MsgSender.MsgCallback callback) throws MessageContentException {
        Thread t = new Thread(new SendMsgRunnable(parameters, callback));
        t.start();
    }

    protected byte[] sendMsg(String parameters) throws MessageContentException, MessageProcessingException, IOException, SpamProtectionException {
        SynchronousCallback callback = new SynchronousCallback();
        SendMsgRunnable sendMsgRunnable = new SendMsgRunnable(parameters, (MsgSender.MsgCallback)callback);
        sendMsgRunnable.run();
        if (callback.error != null) {
            if (callback.error instanceof MessageContentException) {
                throw (MessageContentException)callback.error;
            }
            if (callback.error instanceof TimeoutException) {
                throw (TimeoutException)callback.error;
            }
            if (callback.error instanceof MessageProcessingException) {
                throw (MessageProcessingException)callback.error;
            }
            if (callback.error instanceof IOException) {
                throw (IOException)callback.error;
            }
            if (callback.error instanceof SpamProtectionException) {
                throw (SpamProtectionException)callback.error;
            }
            throw new MessageProcessingException("Error sending message to " + this.baseURL + " : " + callback.error.getMessage(), callback.error);
        }
        return callback.responseData;
    }

    protected class SynchronousCallback
    implements MsgSender.MsgCallback {
        byte[] responseData;
        Exception error;

        protected SynchronousCallback() {
        }

        @Override
        public void responseReceived(byte[] responseData) {
            this.responseData = responseData;
        }

        @Override
        public void errorOccurred(Exception e) {
            this.error = e;
        }
    }

    protected class SendMsgRunnable
    implements Runnable {
        byte[] request;
        String parameters = null;
        MsgSender.MsgCallback callback;
        boolean doOutput = false;
        URL url;

        protected SendMsgRunnable(byte[] request, MsgSender.MsgCallback callback) {
            this.request = request;
            this.callback = callback;
            this.doOutput = true;
            this.url = BaseHTTPSender.this.baseURL;
        }

        protected SendMsgRunnable(String parameters, MsgSender.MsgCallback callback) throws MessageContentException {
            this.parameters = parameters;
            this.callback = callback;
            try {
                this.url = new URL(BaseHTTPSender.this.baseURL.toString() + "?" + parameters);
            }
            catch (MalformedURLException e) {
                throw new MessageContentException("Error building GET request to server, invalid URL parameters: " + parameters, e);
            }
        }

        @Override
        public void run() {
            try {
                int httpStatus;
                int responseCode;
                HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
                con.setRequestMethod(BaseHTTPSender.this.requestType);
                con.setRequestProperty("content-type", BaseHTTPSender.this.outputContentType);
                if (this.doOutput && this.request != null) {
                    con.setDoOutput(true);
                    OutputStream os = con.getOutputStream();
                    os.write(this.request);
                    os.flush();
                    os.close();
                }
                if ((responseCode = (httpStatus = con.getResponseCode()) / 100) == 2) {
                    int n;
                    DataInputStream inputStream = new DataInputStream(con.getInputStream());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[65535];
                    while ((n = inputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, n);
                    }
                    inputStream.close();
                    this.callback.responseReceived(baos.toByteArray());
                } else if (httpStatus == 429) {
                    this.callback.errorOccurred(new SpamProtectionException("Error sending message to " + this.url + ", got response code :" + con.getResponseCode() + " message: " + con.getResponseMessage()));
                } else if (responseCode == 4) {
                    this.callback.errorOccurred(new MessageContentException("Error sending message to " + this.url + ", got response code :" + con.getResponseCode() + " message: " + con.getResponseMessage()));
                } else if (httpStatus == 503) {
                    this.callback.errorOccurred(new TimeoutException("Timeout sending message to " + this.url + ", got response code :" + con.getResponseCode() + " message: " + con.getResponseMessage()));
                } else {
                    this.callback.errorOccurred(new MessageProcessingException("Error sending message to " + this.url + ", got response code :" + con.getResponseCode() + " message: " + con.getResponseMessage()));
                }
            }
            catch (ProtocolException e) {
                this.callback.errorOccurred(new MessageProcessingException("Error sending message to " + this.url + ": " + e.getMessage(), e));
            }
            catch (IOException e) {
                this.callback.errorOccurred(e);
            }
        }
    }
}

