/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.v2x.backend;

import java.io.InputStream;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.v2x.backend.jaxb.ObjectFactory;
import org.certificateservices.messages.v2x.backend.jaxb.SignCertRequest;
import org.certificateservices.messages.v2x.backend.jaxb.SignCertResponse;
import org.certificateservices.messages.v2x.backend.jaxb.SignErrorRequest;
import org.certificateservices.messages.v2x.backend.jaxb.SignErrorResponse;
import org.certificateservices.messages.v2x.backend.jaxb.ValidityUnitType;
import org.certificateservices.messages.v2x.registration.jaxb.RegionsType;

public class V2XBackendPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/v2x_backend_2_0";
    private static final String V2X_BACKEND_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/v2x_backend_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_V2X_BACKEND_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_V2X_BACKEND_VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.v2x.backend.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_V2X_BACKEND_VERSION)) {
            return this.getClass().getResourceAsStream(V2X_BACKEND_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported SysConfig Payload version: " + payLoadVersion);
    }

    @Override
    public String[] getRelatedSchemas(String payloadVersion) {
        return new String[]{"/v2x_registration_schema2_0.xsd"};
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_V2X_BACKEND_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_V2X_BACKEND_VERSION;
    }

    public byte[] generateSignCertRequest(String requestId, String destinationId, String organisation, String canonicalId, Integer assuranceLevel, Integer confidenceLevel, String caId, String profileName, ValidityUnitType validityUnit, Integer validityDuration, RegionsType regions, byte[] publicVerificationKey, byte[] publicEncryptionKey, byte[] requestHash, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        SignCertRequest payload = this.of.createSignCertRequest();
        payload.setCanonicalId(canonicalId);
        payload.setAssuranceLevel(assuranceLevel);
        payload.setConfidenceLevel(confidenceLevel);
        payload.setCaId(caId);
        payload.setProfileName(profileName);
        payload.setValidityUnit(validityUnit);
        payload.setValidityDuration(validityDuration);
        payload.setRegions(regions);
        payload.setPublicVerificationKey(publicVerificationKey);
        payload.setPublicEncryptionKey(publicEncryptionKey);
        payload.setRequestHash(requestHash);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateSignCertResponse(String relatedEndEntity, CSMessage request, String canonicalId, String responseCode, String message, byte[] responseData) throws MessageContentException, MessageProcessingException {
        SignCertResponse payload = this.of.createSignCertResponse();
        payload.setCanonicalId(canonicalId);
        payload.setResponseCode(responseCode);
        payload.setMessage(message);
        payload.setResponseData(responseData);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }

    public byte[] generateSignErrorRequest(String requestId, String destinationId, String organisation, String canonicalId, String caId, String responseCode, String message, byte[] requestHash, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        SignErrorRequest payload = this.of.createSignErrorRequest();
        payload.setCanonicalId(canonicalId);
        payload.setCaId(caId);
        payload.setMessage(message);
        payload.setResponseCode(responseCode);
        payload.setRequestHash(requestHash);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData generateSignErrorResponse(String relatedEndEntity, CSMessage request, String canonicalId, String responseCode, String message, byte[] responseData) throws MessageContentException, MessageProcessingException {
        SignErrorResponse payload = this.of.createSignErrorResponse();
        payload.setCanonicalId(canonicalId);
        payload.setResponseCode(responseCode);
        payload.setMessage(message);
        payload.setResponseData(responseData);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload);
    }
}

