/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages;

public enum SigningAlgorithmScheme {
    RSAWithSHA256("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"),
    RSAWithSHA512("http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"),
    ECDSAWithSHA256("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"),
    ECDSAWithSHA512("http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");

    String hashAlgorithmURI;
    String signatureAlgorithmURI;

    private SigningAlgorithmScheme(String hashAlgorithmURI, String signatureAlgorithmURI) {
        this.hashAlgorithmURI = hashAlgorithmURI;
        this.signatureAlgorithmURI = signatureAlgorithmURI;
    }

    public String getHashAlgorithmURI() {
        return this.hashAlgorithmURI;
    }

    public String getSignatureAlgorithmURI() {
        return this.signatureAlgorithmURI;
    }

    public static SigningAlgorithmScheme getByName(String name) {
        if (name != null) {
            for (SigningAlgorithmScheme s : SigningAlgorithmScheme.values()) {
                if (!s.name().equalsIgnoreCase(name.trim())) continue;
                return s;
            }
        }
        return null;
    }
}

