/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.authorization;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.authorization.jaxb.GetRequesterRolesRequest;
import org.certificateservices.messages.authorization.jaxb.GetRequesterRolesResponse;
import org.certificateservices.messages.authorization.jaxb.GetRolesType;
import org.certificateservices.messages.authorization.jaxb.ObjectFactory;
import org.certificateservices.messages.authorization.jaxb.TokenTypePermission;
import org.certificateservices.messages.authorization.jaxb.TokenTypePermissionType;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;

public class AuthorizationPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/authorization2_0";
    public static final String AUTHORIZATION_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/authorization_schema2_0.xsd";
    public static final String AUTHORIZATION_XSD_SCHEMA_2_1_RESOURCE_LOCATION = "/authorization_schema2_1.xsd";
    public static final String AUTHORIZATION_XSD_SCHEMA_2_2_RESOURCE_LOCATION = "/authorization_schema2_2.xsd";
    public static final String AUTHORIZATION_XSD_SCHEMA_2_3_RESOURCE_LOCATION = "/authorization_schema2_3.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_AUTHORIZATION_VERSIONS = new String[]{"2.3", "2.2", "2.1", "2.0"};
    private static final String DEFAULT_AUTHORIZATION_VERSION = "2.3";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.authorization.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals("2.0")) {
            return this.getClass().getResourceAsStream(AUTHORIZATION_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals("2.1")) {
            return this.getClass().getResourceAsStream(AUTHORIZATION_XSD_SCHEMA_2_1_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals("2.2")) {
            return this.getClass().getResourceAsStream(AUTHORIZATION_XSD_SCHEMA_2_2_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals(DEFAULT_AUTHORIZATION_VERSION)) {
            return this.getClass().getResourceAsStream(AUTHORIZATION_XSD_SCHEMA_2_3_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported Authorization Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_AUTHORIZATION_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_AUTHORIZATION_VERSION;
    }

    public byte[] genGetRequesterRolesRequest(String requestId, String destinationId, String organisation, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.genGetRequesterRolesRequest(requestId, destinationId, organisation, null, originator, assertions);
    }

    public byte[] genGetRequesterRolesRequest(String requestId, String destinationId, String organisation, List<String> tokenTypeQuery, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetRequesterRolesRequest payload = this.of.createGetRequesterRolesRequest();
        if (tokenTypeQuery != null && tokenTypeQuery.size() > 0) {
            payload.setTokenTypePermissionQuery(this.of.createGetRequesterRolesRequestTokenTypePermissionQuery());
            payload.getTokenTypePermissionQuery().getTokenType().addAll(tokenTypeQuery);
        }
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetRequesterRolesResponse(String relatedEndEntity, CSMessage request, List<String> roles, Collection<TokenTypePermission> tokenTypePermissions, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetRequesterRolesResponse response = this.of.createGetRequesterRolesResponse();
        response.setRoles(new GetRolesType.Roles());
        for (String role : roles) {
            response.getRoles().getRole().add(role);
        }
        String payloadVersion = request.getPayLoadVersion();
        if (tokenTypePermissions != null && tokenTypePermissions.size() > 0) {
            response.setTokenTypePermissions(this.of.createGetRolesTypeTokenTypePermissions());
            for (TokenTypePermission ttp : tokenTypePermissions) {
                if (ttp.getRuleType() == TokenTypePermissionType.RECOVERKEYS && payloadVersion.equals("2.0") || ttp.getRuleType() == TokenTypePermissionType.REQUEST && (payloadVersion.equals("2.0") || payloadVersion.equals("2.1")) || (ttp.getRuleType() == TokenTypePermissionType.BATCHUPDATE || ttp.getRuleType() == TokenTypePermissionType.IMPORT || ttp.getRuleType() == TokenTypePermissionType.EXPORT || ttp.getRuleType() == TokenTypePermissionType.UNBLOCK) && (payloadVersion.equals("2.0") || payloadVersion.equals("2.1") || payloadVersion.equals("2.2"))) continue;
                response.getTokenTypePermissions().getTokenTypePermission().add(ttp);
            }
        }
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, false);
    }
}

