/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csagent;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csagent.jaxb.DiscoveredCredential;
import org.certificateservices.messages.csagent.jaxb.DiscoveredCredentialData;
import org.certificateservices.messages.csagent.jaxb.DiscoveredCredentialDataRequest;
import org.certificateservices.messages.csagent.jaxb.DiscoveredCredentialDataResponse;
import org.certificateservices.messages.csagent.jaxb.DiscoveredCredentialsRequest;
import org.certificateservices.messages.csagent.jaxb.DiscoveredCredentialsResponse;
import org.certificateservices.messages.csagent.jaxb.ObjectFactory;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.utils.MessageGenerateUtils;

public class CSAgentProtocolPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/cs_agent_protocol2_0";
    public static final String CS_AGENT_PROTOCOL_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs_agent_protocol_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_CSAGENT_PROTOCOL_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_CSAGENT_PROTOCOL__VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.csagent.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_CSAGENT_PROTOCOL__VERSION)) {
            return this.getClass().getResourceAsStream(CS_AGENT_PROTOCOL_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported CS Agent Protocol Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_CSAGENT_PROTOCOL_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_CSAGENT_PROTOCOL__VERSION;
    }

    public byte[] genDiscoveredCredentialsRequest(String requestId, String destinationId, String organisation, String agentId, String scanId, Date scanTimeStamp, List<DiscoveredCredential> discoveredCredentials, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        DiscoveredCredentialsRequest payload = this.of.createDiscoveredCredentialsRequest();
        payload.setAgentId(agentId);
        payload.setScanId(scanId);
        payload.setScanTimeStamp(MessageGenerateUtils.dateToXMLGregorianCalendar(scanTimeStamp));
        DiscoveredCredentialsRequest.DiscoveredCredentials dcs = new DiscoveredCredentialsRequest.DiscoveredCredentials();
        dcs.getDc().addAll(discoveredCredentials);
        payload.setDiscoveredCredentials(dcs);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genDiscoveredCredentialsResponse(String relatedEndEntity, CSMessage request, List<String> hashValues) throws MessageContentException, MessageProcessingException {
        DiscoveredCredentialsResponse response = this.of.createDiscoveredCredentialsResponse();
        DiscoveredCredentialsResponse.UnknownCredentials ucs = new DiscoveredCredentialsResponse.UnknownCredentials();
        if (hashValues != null) {
            ucs.getH().addAll(hashValues);
        }
        response.setUnknownCredentials(ucs);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, false);
    }

    public byte[] genDiscoveredCredentialDataRequest(String requestId, String destinationId, String organisation, String agentId, String scanId, Date scanTimeStamp, List<DiscoveredCredentialData> discoveredCredentialDataList, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        DiscoveredCredentialDataRequest payload = this.of.createDiscoveredCredentialDataRequest();
        payload.setAgentId(agentId);
        payload.setScanId(scanId);
        payload.setScanTimeStamp(MessageGenerateUtils.dateToXMLGregorianCalendar(scanTimeStamp));
        DiscoveredCredentialDataRequest.DiscoveredCredentialData dcs = new DiscoveredCredentialDataRequest.DiscoveredCredentialData();
        dcs.getDcd().addAll(discoveredCredentialDataList);
        payload.setDiscoveredCredentialData(dcs);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genDiscoveredCredentialDataResponse(String relatedEndEntity, CSMessage request) throws MessageContentException, MessageProcessingException {
        DiscoveredCredentialDataResponse response = this.of.createDiscoveredCredentialDataResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, false);
    }
}

