/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.dss1.core;

import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.dss1.core.jaxb.AnyType;
import org.certificateservices.messages.dss1.core.jaxb.InputDocuments;
import org.certificateservices.messages.dss1.core.jaxb.InternationalStringType;
import org.certificateservices.messages.dss1.core.jaxb.ObjectFactory;
import org.certificateservices.messages.dss1.core.jaxb.RequestBaseType;
import org.certificateservices.messages.dss1.core.jaxb.ResponseBaseType;
import org.certificateservices.messages.dss1.core.jaxb.Result;
import org.certificateservices.messages.dss1.core.jaxb.SignRequest;
import org.certificateservices.messages.dss1.core.jaxb.SignResponse;
import org.certificateservices.messages.dss1.core.jaxb.SignatureObject;
import org.certificateservices.messages.dss1.core.jaxb.VerifyRequest;
import org.certificateservices.messages.saml2.BaseSAMLMessageParser;
import org.certificateservices.messages.utils.XMLSigner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DSS1CoreMessageParser
extends BaseSAMLMessageParser {
    public static final String NAMESPACE = "urn:oasis:names:tc:dss:1.0:core:schema";
    public static final String SAML_1_1_NAMESPACE = "urn:oasis:names:tc:SAML:1.0:assertion";
    protected static final String BASE_JAXB_CONTEXT = "org.certificateservices.messages.saml1_1.assertions.jaxb:org.certificateservices.messages.dss1.core.jaxb:org.certificateservices.messages.xmldsig.jaxb";
    protected static final String ASSERTION_XSD_SCHEMA_1_1_RESOURCE_LOCATION = "/cs-message-oasis-sstc-saml-schema-protocol-1.1.xsd";
    protected static final String DSS_XSD_SCHEMA_1_0_RESOURCE_LOCATION = "/cs-message-oasis-dss-core-schema-v1.0-os.xsd";
    protected ObjectFactory dssOf = new ObjectFactory();
    private DSS1CoreSignatureLocationFinder dss1CoreSignatureLocationFinder = new DSS1CoreSignatureLocationFinder();

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public String getJAXBPackages() {
        return BASE_JAXB_CONTEXT;
    }

    @Override
    public String[] getDefaultSchemaLocations() throws SAXException {
        return new String[]{"/xmldsig-core-schema.xsd", ASSERTION_XSD_SCHEMA_1_1_RESOURCE_LOCATION, DSS_XSD_SCHEMA_1_0_RESOURCE_LOCATION};
    }

    @Override
    public XMLSigner.SignatureLocationFinder getSignatureLocationFinder() {
        return this.dss1CoreSignatureLocationFinder;
    }

    @Override
    public XMLSigner.OrganisationLookup getOrganisationLookup() {
        return null;
    }

    @Override
    protected String lookupSchemaForElement(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (namespaceURI != null) {
            if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                return "/xml.xsd";
            }
            if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                return "/xmldsig-core-schema.xsd";
            }
            if (namespaceURI.equals(NAMESPACE)) {
                return DSS_XSD_SCHEMA_1_0_RESOURCE_LOCATION;
            }
            if (namespaceURI.equals(SAML_1_1_NAMESPACE)) {
                return ASSERTION_XSD_SCHEMA_1_1_RESOURCE_LOCATION;
            }
        }
        return null;
    }

    public SignRequest genSignRequest(String requestID, String profile, List<Object> optionalInputs, InputDocuments inputDocuments) {
        SignRequest sr = this.dssOf.createSignRequest();
        this.populateRequestBase(sr, requestID, profile, optionalInputs, inputDocuments);
        return sr;
    }

    public byte[] genSignRequest(ContextMessageSecurityProvider.Context context, String requestID, String profile, List<Object> optionalInputs, InputDocuments inputDocuments, boolean sign) throws MessageProcessingException, MessageContentException {
        SignRequest sr = this.genSignRequest(requestID, profile, optionalInputs, inputDocuments);
        if (sign) {
            return this.marshallAndSign(context, sr);
        }
        return this.marshall(sr);
    }

    public SignResponse genSignResponse(String requestID, String profile, Result result, List<Object> optionalOutputs, SignatureObject signatureObject) {
        SignResponse sr = this.dssOf.createSignResponse();
        this.populateResponseBase(sr, requestID, profile, result, optionalOutputs);
        sr.setSignatureObject(signatureObject);
        return sr;
    }

    public byte[] genSignResponse(ContextMessageSecurityProvider.Context context, String requestID, String profile, Result result, List<Object> optionalOutputs, SignatureObject signatureObject, boolean sign) throws MessageProcessingException, MessageContentException {
        SignResponse sr = this.genSignResponse(requestID, profile, result, optionalOutputs, signatureObject);
        if (sign) {
            return this.marshallAndSign(context, sr);
        }
        return this.marshall(sr);
    }

    public VerifyRequest genVerifyRequest(String requestID, String profile, List<Object> optionalInputs, InputDocuments inputDocuments, SignatureObject signatureObject) {
        VerifyRequest vr = this.dssOf.createVerifyRequest();
        this.populateRequestBase(vr, requestID, profile, optionalInputs, inputDocuments);
        vr.setSignatureObject(signatureObject);
        return vr;
    }

    public byte[] genVerifyRequest(ContextMessageSecurityProvider.Context context, String requestID, String profile, List<Object> optionalInputs, InputDocuments inputDocuments, SignatureObject signatureObject, boolean sign) throws MessageProcessingException, MessageContentException {
        VerifyRequest vr = this.genVerifyRequest(requestID, profile, optionalInputs, inputDocuments, signatureObject);
        if (sign) {
            return this.marshallAndSign(context, vr);
        }
        return this.marshall(vr);
    }

    public JAXBElement<ResponseBaseType> genVerifyResponse(String requestID, String profile, Result result, List<Object> optionalOutputs) {
        ResponseBaseType rb = this.dssOf.createResponseBaseType();
        this.populateResponseBase(rb, requestID, profile, result, optionalOutputs);
        return this.dssOf.createVerifyResponse(rb);
    }

    public byte[] genVerifyResponse(ContextMessageSecurityProvider.Context context, String requestID, String profile, Result result, List<Object> optionalOutputs, boolean sign) throws MessageProcessingException, MessageContentException {
        JAXBElement<ResponseBaseType> vr = this.genVerifyResponse(requestID, profile, result, optionalOutputs);
        if (sign) {
            return this.marshallAndSign(context, vr);
        }
        return this.marshall(vr);
    }

    public void populateRequestBase(RequestBaseType requestBase, String requestID, String profile, List<Object> optionalInputs, InputDocuments inputDocuments) {
        requestBase.setRequestID(requestID);
        requestBase.setProfile(profile);
        if (optionalInputs != null) {
            AnyType anyType = this.dssOf.createAnyType();
            anyType.getAny().addAll(optionalInputs);
            requestBase.setOptionalInputs(anyType);
        }
        requestBase.setInputDocuments(inputDocuments);
    }

    public Result genResult(String resultMajor, String resultMinor, String resultMessage, String resultMessageLang) {
        Result r = this.dssOf.createResult();
        r.setResultMajor(resultMajor);
        r.setResultMinor(resultMinor);
        if (resultMessage != null) {
            InternationalStringType rm = this.dssOf.createInternationalStringType();
            rm.setLang(resultMessageLang);
            rm.setValue(resultMessage);
            r.setResultMessage(rm);
        }
        return r;
    }

    protected void populateResponseBase(ResponseBaseType responseBase, String requestID, String profile, Result result, List<Object> optionalOutputs) {
        responseBase.setRequestID(requestID);
        responseBase.setProfile(profile);
        responseBase.setResult(result);
        if (optionalOutputs != null) {
            AnyType anyType = this.dssOf.createAnyType();
            anyType.getAny().addAll(optionalOutputs);
            responseBase.setOptionalOutputs(anyType);
        }
    }

    public static class DSS1CoreSignatureLocationFinder
    implements XMLSigner.SignatureLocationFinder {
        @Override
        public Element[] getSignatureLocations(Document doc) throws MessageContentException {
            try {
                Element docElement = doc.getDocumentElement();
                if (docElement.getNamespaceURI().equals(DSS1CoreMessageParser.NAMESPACE)) {
                    NodeList nl = docElement.getElementsByTagNameNS(DSS1CoreMessageParser.NAMESPACE, "OptionalInputs");
                    if (nl.getLength() != 1) {
                        nl = docElement.getElementsByTagNameNS(DSS1CoreMessageParser.NAMESPACE, "OptionalOutputs");
                    }
                    if (nl.getLength() != 1) {
                        throw new MessageContentException("Error cannot sign DSS xml document that doesn't contain one OptionalInputs or OptionalOutputs child element.");
                    }
                    return new Element[]{(Element)nl.item(0)};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageContentException("Invalid DSS message type sent for signature.");
        }

        @Override
        public String getIDAttribute() {
            return null;
        }

        @Override
        public String getIDValue(Element signedElement) throws MessageContentException {
            return null;
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            return null;
        }
    }
}

