/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.Base64;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.SigningAlgorithmScheme;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.SystemTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSigner {
    public static String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static String ENVELOPE_TRANSFORM = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    private static String C14N_TRANSFORM = "http://www.w3.org/2001/10/xml-exc-c14n#";
    static Logger log = Logger.getLogger(XMLSigner.class.getName());
    static SystemTime systemTime = new DefaultSystemTime();
    private DocumentBuilderFactory documentBuilderFactory;
    private DocumentBuilder documentBuilder;
    private CertificateFactory cf;
    private SignatureLocationFinder defaultSignatureLocationFinder;
    private OrganisationLookup defaultOrganisationLookup;
    private Set<String> supportedDigestsAlgorithm;
    private Set<String> supportedSignatureAlgorithm;
    private MessageSecurityProvider messageSecurityProvider;
    private Transformer transformer;
    private boolean signMessages;

    @Deprecated
    public XMLSigner(MessageSecurityProvider messageSecurityProvider, DocumentBuilder documentBuilder, boolean signMessages, SignatureLocationFinder defaultSignatureLocationFinder, OrganisationLookup defaultOrganisationLookup) throws MessageProcessingException {
        this(messageSecurityProvider, signMessages, defaultSignatureLocationFinder, defaultOrganisationLookup);
        this.documentBuilder = documentBuilder;
    }

    public XMLSigner(MessageSecurityProvider messageSecurityProvider, boolean signMessages, SignatureLocationFinder defaultSignatureLocationFinder, OrganisationLookup defaultOrganisationLookup) throws MessageProcessingException {
        this.messageSecurityProvider = messageSecurityProvider;
        this.defaultSignatureLocationFinder = defaultSignatureLocationFinder;
        this.defaultOrganisationLookup = defaultOrganisationLookup;
        this.signMessages = signMessages;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new MessageProcessingException("Error instantiating CertificateFactory for XMLSigner: " + e.getMessage(), e);
        }
        this.supportedDigestsAlgorithm = new HashSet<String>();
        this.supportedSignatureAlgorithm = new HashSet<String>();
        for (SigningAlgorithmScheme scheme : SigningAlgorithmScheme.values()) {
            this.supportedDigestsAlgorithm.add(scheme.getHashAlgorithmURI());
            this.supportedSignatureAlgorithm.add(scheme.getSignatureAlgorithmURI());
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            this.transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new MessageProcessingException("Error creating Transformer for XMLSigner: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public void verifyEnvelopedSignature(byte[] message) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(ContextMessageSecurityProvider.DEFAULT_CONTEXT, message, false);
    }

    public void verifyEnvelopedSignature(ContextMessageSecurityProvider.Context context, byte[] message) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(context, message, false);
    }

    @Deprecated
    public void verifyEnvelopedSignature(byte[] message, boolean authorizeAgainstOrganisation) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(ContextMessageSecurityProvider.DEFAULT_CONTEXT, message, authorizeAgainstOrganisation);
    }

    public void verifyEnvelopedSignature(ContextMessageSecurityProvider.Context context, byte[] message, boolean authorizeAgainstOrganisation) throws MessageContentException, MessageProcessingException {
        Document doc;
        try {
            doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(message));
        }
        catch (Exception e) {
            throw new MessageContentException("Error validating signature of message: " + e.getMessage(), e);
        }
        this.verifyEnvelopedSignature(context, doc, authorizeAgainstOrganisation);
    }

    @Deprecated
    public void verifyEnvelopedSignature(Document doc, boolean performValidation) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, performValidation);
    }

    public void verifyEnvelopedSignature(ContextMessageSecurityProvider.Context context, Document doc, boolean performValidation) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(context, doc, performValidation ? this.defaultOrganisationLookup : null);
    }

    public void verifyEnvelopedSignature(ContextMessageSecurityProvider.Context context, Document doc, OrganisationLookup organisationLookup) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(context, doc, this.defaultSignatureLocationFinder, organisationLookup);
    }

    @Deprecated
    public void verifyEnvelopedSignature(Document doc, OrganisationLookup organisationLookup) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(doc, this.defaultSignatureLocationFinder, organisationLookup);
    }

    @Deprecated
    public void verifyEnvelopedSignature(byte[] message, SignatureLocationFinder signatureLocationFinder, OrganisationLookup organisationLookup) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(ContextMessageSecurityProvider.DEFAULT_CONTEXT, message, signatureLocationFinder, organisationLookup);
    }

    public void verifyEnvelopedSignature(ContextMessageSecurityProvider.Context context, byte[] message, SignatureLocationFinder signatureLocationFinder, OrganisationLookup organisationLookup) throws MessageContentException, MessageProcessingException {
        Document doc;
        try {
            doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(message));
        }
        catch (Exception e) {
            throw new MessageContentException("Error validating signature of message: " + e.getMessage(), e);
        }
        this.verifyEnvelopedSignature(context, doc, signatureLocationFinder, organisationLookup);
    }

    @Deprecated
    public void verifyEnvelopedSignature(Document doc, SignatureLocationFinder signatureLocationFinder, OrganisationLookup organisationLookup) throws MessageContentException, MessageProcessingException {
        this.verifyEnvelopedSignature(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, signatureLocationFinder, organisationLookup);
    }

    public void verifyEnvelopedSignature(ContextMessageSecurityProvider.Context context, Document doc, SignatureLocationFinder signatureLocationFinder, OrganisationLookup organisationLookup) throws MessageContentException, MessageProcessingException {
        try {
            Element[] signedElements;
            for (Element signedElement : signedElements = signatureLocationFinder.getSignatureLocations(doc)) {
                XMLSignatureFactory signatureFactory;
                XMLSignature sig;
                String certData;
                Element signature = this.findSignatureElementInObject(signedElement);
                this.checkValidSignatureURI(signature);
                this.checkValidDigestURI(signature);
                this.checkValidTransform(signature);
                this.checkValidReferenceURI(signedElement, signature, signatureLocationFinder.getIDAttribute());
                Certificate signerCert = null;
                NodeList certList = signature.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "X509Certificate");
                if (certList.getLength() > 0 && (certData = certList.item(0).getFirstChild().getNodeValue()) != null) {
                    signerCert = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)certData)));
                }
                if (signerCert == null) {
                    throw new MessageContentException("Invalid signature, no related certificate found.");
                }
                DOMValidateContext validationContext = new DOMValidateContext(signerCert.getPublicKey(), (Node)signature);
                String idAttribute = signatureLocationFinder.getIDAttribute();
                if (idAttribute != null) {
                    validationContext.setIdAttributeNS(signedElement, null, signatureLocationFinder.getIDAttribute());
                }
                if (!(sig = (signatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI())).unmarshalXMLSignature(validationContext)).validate(validationContext)) {
                    throw new MessageContentException("Error, signed message didn't pass validation.");
                }
                String organisation = null;
                if (organisationLookup != null) {
                    organisation = organisationLookup.findOrganisation(doc);
                }
                if (!(this.messageSecurityProvider instanceof ContextMessageSecurityProvider ? !((ContextMessageSecurityProvider)this.messageSecurityProvider).isValidAndAuthorized(context, (X509Certificate)signerCert, organisation) : !this.messageSecurityProvider.isValidAndAuthorized((X509Certificate)signerCert, organisation))) continue;
                throw new MessageContentException("A certificate with DN " + ((X509Certificate)signerCert).getSubjectDN().toString() + " signing a message wasn't authorized or valid.");
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error validating signature of message: " + e.getMessage(), e);
        }
    }

    public X509Certificate findSignerCertificate(byte[] message) throws MessageContentException, MessageProcessingException {
        return this.findSignerCertificate(message, this.defaultSignatureLocationFinder);
    }

    public X509Certificate findSignerCertificate(byte[] message, SignatureLocationFinder signatureLocationFinder) throws MessageContentException, MessageProcessingException {
        try {
            String certData;
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(message));
            Element signedElement = signatureLocationFinder.getSignatureLocations(doc)[0];
            Element signature = this.findSignatureElementInObject(signedElement);
            X509Certificate signerCert = null;
            NodeList certList = signature.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "X509Certificate");
            if (certList.getLength() > 0 && (certData = certList.item(0).getFirstChild().getNodeValue()) != null) {
                signerCert = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)certData)));
            }
            if (signerCert == null) {
                throw new MessageContentException("Invalid signature, no related certificate found.");
            }
            return signerCert;
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error parsing the certificate from signature in message: " + e.getMessage(), e);
        }
    }

    public static boolean checkBasicCertificateValidation(X509Certificate cert) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null && !keyUsage[0]) {
            log.severe("Error processing Certificate Services message signing certificate expired has not keyUsage digitalSignature.");
            return false;
        }
        Date currentTime = systemTime.getSystemTime();
        if (currentTime.after(cert.getNotAfter())) {
            log.severe("Error processing Certificate Services message signing certificate expired: " + cert.getNotAfter());
            return false;
        }
        if (currentTime.before(cert.getNotBefore())) {
            log.severe("Error processing Certificate Services message signing certificate not yet valid: " + cert.getNotBefore());
            return false;
        }
        return true;
    }

    @Deprecated
    public void sign(Document doc, SignatureLocationFinder signatureLocationFinder) throws MessageProcessingException, MessageContentException {
        this.sign(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, signatureLocationFinder);
    }

    public void sign(ContextMessageSecurityProvider.Context context, Document doc, SignatureLocationFinder signatureLocationFinder) throws MessageProcessingException, MessageContentException {
        try {
            if (this.signMessages) {
                Element[] signatureLocations;
                for (Element signatureLocation : signatureLocations = signatureLocationFinder.getSignatureLocations(doc)) {
                    XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
                    SigningAlgorithmScheme scheme = this.messageSecurityProvider instanceof ContextMessageSecurityProvider ? ((ContextMessageSecurityProvider)this.messageSecurityProvider).getSigningAlgorithmScheme(context) : this.messageSecurityProvider.getSigningAlgorithmScheme();
                    DigestMethod digestMethod = fac.newDigestMethod(scheme.getHashAlgorithmURI(), null);
                    String messageID = signatureLocationFinder.getIDValue(signatureLocation);
                    ArrayList<Transform> transFormList = new ArrayList<Transform>();
                    transFormList.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                    transFormList.add(fac.newTransform(C14N_TRANSFORM, (TransformParameterSpec)null));
                    Reference ref = fac.newReference(messageID == null ? "" : "#" + messageID, digestMethod, transFormList, null, null);
                    ArrayList<Reference> refList = new ArrayList<Reference>();
                    refList.add(ref);
                    CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
                    SignatureMethod sm = fac.newSignatureMethod(scheme.getSignatureAlgorithmURI(), null);
                    SignedInfo signedInfo = fac.newSignedInfo(cm, sm, refList);
                    List<QName> beforeSiblings = signatureLocationFinder.getSiblingsBeforeSignature(signatureLocation);
                    Node siblingNode = null;
                    if (beforeSiblings != null) {
                        for (QName name : beforeSiblings) {
                            NodeList foundList = signatureLocation.getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
                            if (foundList.getLength() <= 0) continue;
                            siblingNode = foundList.item(0);
                            break;
                        }
                    }
                    PrivateKey signingKey = this.messageSecurityProvider instanceof ContextMessageSecurityProvider ? ((ContextMessageSecurityProvider)this.messageSecurityProvider).getSigningKey(context) : this.messageSecurityProvider.getSigningKey();
                    DOMSignContext signContext = siblingNode != null ? new DOMSignContext(signingKey, (Node)signatureLocation, siblingNode) : new DOMSignContext(signingKey, (Node)signatureLocation);
                    String idAttribute = signatureLocationFinder.getIDAttribute();
                    if (idAttribute != null) {
                        signContext.setIdAttributeNS(signatureLocation, null, idAttribute);
                    }
                    signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
                    KeyInfoFactory kif = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
                    ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                    X509Certificate cert = this.messageSecurityProvider instanceof ContextMessageSecurityProvider ? ((ContextMessageSecurityProvider)this.messageSecurityProvider).getSigningCertificate(context) : this.messageSecurityProvider.getSigningCertificate();
                    certs.add(cert);
                    X509Data x509Data = kif.newX509Data(certs);
                    KeyInfo ki = kif.newKeyInfo(Collections.singletonList(x509Data));
                    XMLSignature signature = fac.newXMLSignature(signedInfo, ki);
                    Provider signProvider = this.messageSecurityProvider instanceof ContextMessageSecurityProvider ? Security.getProvider(((ContextMessageSecurityProvider)this.messageSecurityProvider).getProvider(context)) : Security.getProvider(this.messageSecurityProvider.getProvider());
                    if (signProvider != null) {
                        log.fine("Performing xml signature using provider: " + signProvider.getName());
                        signContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", signProvider);
                    }
                    signature.sign(signContext);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new MessageProcessingException("Error signing the XML, " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MessageProcessingException("Error signing the XML, " + e.getMessage(), e);
        }
        catch (MarshalException e) {
            throw new MessageProcessingException("Error signing the XML, " + e.getMessage(), e);
        }
        catch (XMLSignatureException e) {
            throw new MessageProcessingException("Error signing the XML, " + e.getMessage(), e);
        }
    }

    public byte[] marshallDoc(Document doc) throws MessageProcessingException, MessageContentException {
        try {
            StringWriter writer = new StringWriter();
            this.transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageProcessingException("Error marshalling to XML, " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageProcessingException("Error marshalling to XML, " + e.getMessage(), e);
        }
    }

    public byte[] marshallAndSign(ContextMessageSecurityProvider.Context context, Document doc, SignatureLocationFinder signatureLocationFinder) throws MessageProcessingException, MessageContentException {
        this.sign(context, doc, signatureLocationFinder);
        return this.marshallDoc(doc);
    }

    @Deprecated
    public byte[] marshallAndSign(Document doc, SignatureLocationFinder signatureLocationFinder) throws MessageProcessingException, MessageContentException {
        this.sign(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, signatureLocationFinder);
        return this.marshallDoc(doc);
    }

    private Element findSignatureElementInObject(Element signedElement) throws MessageContentException {
        NodeList childs = signedElement.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node next = childs.item(i);
            if (!(next instanceof Element) || !((Element)next).getLocalName().equals("Signature") || !((Element)next).getNamespaceURI().equals(XMLDSIG_NAMESPACE)) continue;
            return (Element)next;
        }
        throw new MessageContentException("Required digital signature not found in message.");
    }

    private void checkValidReferenceURI(Element signedElement, Element signature, String signedElementIDAttr) throws MessageContentException {
        try {
            if (signedElementIDAttr != null) {
                String objectID = signedElement.getAttribute(signedElementIDAttr);
                Element transform = (Element)signature.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "Reference").item(0);
                String referenceID = transform.getAttribute("URI");
                if (!referenceID.equals("#" + objectID)) {
                    throw new MessageContentException("Error checking reference URI of digital signature it doesn't match the id of the signed element.");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            throw new MessageContentException("Error checking Reference URI with the signed object: " + e.getMessage(), e);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder != null) {
            return this.documentBuilder;
        }
        return this.documentBuilderFactory.newDocumentBuilder();
    }

    private void checkValidTransform(Element signature) throws MessageContentException {
        try {
            Element transform = (Element)signature.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "Transform").item(0);
            String algorithm = transform.getAttribute("Algorithm");
            if (!algorithm.equals(ENVELOPE_TRANSFORM)) {
                throw new MessageContentException("Error unsupported transform in digital sigature: " + algorithm + " only enveloped signatures are supported.");
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            throw new MessageContentException("Error extracting transform from digital sigature: " + e.getMessage(), e);
        }
    }

    private void checkValidDigestURI(Element signature) throws MessageContentException {
        try {
            Element transform = (Element)signature.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "DigestMethod").item(0);
            String algorithm = transform.getAttribute("Algorithm");
            if (!this.supportedDigestsAlgorithm.contains(algorithm)) {
                throw new MessageContentException("Error unsupported digest algorithm in digital sigature: " + algorithm + ".");
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            throw new MessageContentException("Error extracting digest algorithm from digital sigature: " + e.getMessage(), e);
        }
    }

    private void checkValidSignatureURI(Element signature) throws MessageContentException {
        try {
            Element transform = (Element)signature.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "SignatureMethod").item(0);
            String algorithm = transform.getAttribute("Algorithm");
            if (!this.supportedSignatureAlgorithm.contains(algorithm)) {
                throw new MessageContentException("Error unsupported digest algorithm in digital sigature: " + algorithm + ".");
            }
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            throw new MessageContentException("Error extracting digest algorithm from digital sigature: " + e.getMessage(), e);
        }
    }

    public static interface OrganisationLookup {
        public static final String UNKNOWN = "UNKNOWN";

        public String findOrganisation(Document var1) throws MessageContentException, MessageProcessingException;
    }

    public static interface SignatureLocationFinder {
        public Element[] getSignatureLocations(Document var1) throws MessageContentException;

        public String getIDAttribute();

        public String getIDValue(Element var1) throws MessageContentException;

        public List<QName> getSiblingsBeforeSignature(Element var1) throws MessageContentException;
    }
}

